/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers1;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers2;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers4;
import com.jaquadro.minecraft.storagedrawers.storage.DefaultStorageProvider;
import com.jaquadro.minecraft.storagedrawers.storage.DrawerData;
import com.jaquadro.minecraft.storagedrawers.storage.IStorageProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;

public class TileEntityDrawersStandard
extends TileEntityDrawers {
    private static final String[] GUI_IDS = new String[]{null, "StorageDrawers:basicDrawers1", "StorageDrawers:basicDrawers2", null, "StorageDrawers:basicDrawers4"};
    private IStorageProvider storageProvider = new StandardStorageProvider();

    public TileEntityDrawersStandard() {
        super(1);
    }

    public void setDrawerCount(int count) {
        this.initWithDrawerCount(count);
    }

    protected IStorageProvider getStorageProvider() {
        if (this.storageProvider == null) {
            this.storageProvider = new StandardStorageProvider();
        }
        return this.storageProvider;
    }

    @Override
    protected IDrawer createDrawer(int slot) {
        return new DrawerData(this.getStorageProvider(), slot);
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        switch (this.getDrawerCount()) {
            case 1: {
                return new ContainerDrawers1(playerInventory, this);
            }
            case 2: {
                return new ContainerDrawers2(playerInventory, this);
            }
            case 4: {
                return new ContainerDrawers4(playerInventory, this);
            }
        }
        return null;
    }

    public String func_174875_k() {
        return GUI_IDS[this.getDrawerCount()];
    }

    private class StandardStorageProvider
    extends DefaultStorageProvider {
        public StandardStorageProvider() {
            super((TileEntity)TileEntityDrawersStandard.this, TileEntityDrawersStandard.this);
        }

        @Override
        public int getSlotStackCapacity(int slot) {
            ConfigManager config = StorageDrawers.config;
            return TileEntityDrawersStandard.this.getEffectiveStorageMultiplier() * TileEntityDrawersStandard.this.getDrawerCapacity();
        }

        @Override
        public boolean isLocked(int slot, LockAttribute attr) {
            return TileEntityDrawersStandard.this.isItemLocked(attr);
        }

        @Override
        public boolean isVoid(int slot) {
            return TileEntityDrawersStandard.this.isVoid();
        }

        @Override
        public boolean isShrouded(int slot) {
            return TileEntityDrawersStandard.this.isShrouded();
        }

        @Override
        public boolean setIsShrouded(int slot, boolean state) {
            TileEntityDrawersStandard.this.setIsShrouded(state);
            return true;
        }

        @Override
        public boolean isStorageUnlimited(int slot) {
            return TileEntityDrawersStandard.this.isUnlimited();
        }

        @Override
        public boolean isVendingUnlimited(int slot) {
            return TileEntityDrawersStandard.this.isVending();
        }
    }
}

