/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.chameleon.model.DefaultHandler;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerDecoratorModel;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerSealedModel;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;

public final class BasicDrawerModel {

    public static class ModelHandler
    extends DefaultHandler {
        private IBakedModel parent;

        public ModelHandler(IBakedModel parent) {
            this.parent = parent;
        }

        public IBakedModel handleBlockState(IBlockState state) {
            EnumBasicDrawer drawer = (EnumBasicDrawer)((Object)state.func_177229_b((IProperty)BlockDrawers.BLOCK));
            EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING);
            if (!(state instanceof IExtendedBlockState)) {
                return this.parent;
            }
            IExtendedBlockState xstate = (IExtendedBlockState)state;
            TileEntityDrawers tile = (TileEntityDrawers)xstate.getValue(BlockDrawers.TILE);
            if (!DrawerDecoratorModel.shouldHandleState(tile)) {
                return this.parent;
            }
            return new DrawerDecoratorModel(this.parent, xstate, drawer, dir, tile);
        }

        public IBakedModel handleItemState(ItemStack stack) {
            if (stack == null) {
                return this.parent;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_150297_b("tile", 10)) {
                return this.parent;
            }
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            IBlockState state = block.func_176203_a(stack.func_77960_j());
            return new DrawerSealedModel(this.parent, state, true);
        }

        public TextureAtlasSprite func_177554_e() {
            return this.parent.func_177554_e();
        }
    }

    public static class Register
    extends DefaultRegister {
        public Register() {
            super((Block)ModBlocks.basicDrawers);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (EnumBasicDrawer drawer : EnumBasicDrawer.values()) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    for (BlockPlanks.EnumType woodType : BlockPlanks.EnumType.values()) {
                        states.add(ModBlocks.basicDrawers.func_176223_P().func_177226_a((IProperty)BlockDrawers.BLOCK, (Comparable)((Object)drawer)).func_177226_a((IProperty)BlockDrawers.FACING, (Comparable)dir).func_177226_a((IProperty)BlockDrawers.VARIANT, (Comparable)woodType));
                    }
                }
            }
            return states;
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new ModelHandler(existingModel);
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new ModelHandler(existingModel);
        }

        public List<ResourceLocation> getTextureResources() {
            ArrayList<ResourceLocation> resource = new ArrayList<ResourceLocation>();
            resource.add(DrawerDecoratorModel.iconClaim);
            resource.add(DrawerDecoratorModel.iconClaimLock);
            resource.add(DrawerDecoratorModel.iconLock);
            resource.add(DrawerDecoratorModel.iconShroudCover);
            resource.add(DrawerDecoratorModel.iconVoid);
            resource.add(DrawerSealedModel.iconTapeCover);
            return resource;
        }
    }
}

