/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.chameleon.model.DefaultHandler;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerDecoratorModel;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerSealedModel;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;

public final class CompDrawerModel {

    public static class ModelHandler
    extends DefaultHandler {
        private IBakedModel parent;

        public ModelHandler(IBakedModel parent) {
            this.parent = parent;
        }

        public IBakedModel handleBlockState(IBlockState state) {
            EnumCompDrawer drawer = (EnumCompDrawer)((Object)state.func_177229_b((IProperty)BlockCompDrawers.SLOTS));
            EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING);
            if (!(state instanceof IExtendedBlockState)) {
                return this.parent;
            }
            IExtendedBlockState xstate = (IExtendedBlockState)state;
            TileEntityDrawers tile = (TileEntityDrawers)xstate.getValue(BlockDrawers.TILE);
            if (!DrawerDecoratorModel.shouldHandleState(tile)) {
                return this.parent;
            }
            return new DrawerDecoratorModel(this.parent, xstate, drawer, dir, tile);
        }

        public IBakedModel handleItemState(ItemStack stack) {
            if (stack == null) {
                return this.parent;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_150297_b("tile", 10)) {
                return this.parent;
            }
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            IBlockState state = block.func_176203_a(stack.func_77960_j());
            return new DrawerSealedModel(this.parent, state, true);
        }

        public TextureAtlasSprite func_177554_e() {
            return this.parent.func_177554_e();
        }
    }

    public static class Register
    extends DefaultRegister {
        public Register() {
            super((Block)ModBlocks.compDrawers);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (EnumCompDrawer drawer : EnumCompDrawer.values()) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    states.add(ModBlocks.compDrawers.func_176223_P().func_177226_a((IProperty)BlockCompDrawers.SLOTS, (Comparable)((Object)drawer)).func_177226_a((IProperty)BlockCompDrawers.FACING, (Comparable)dir));
                }
            }
            return states;
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new ModelHandler(existingModel);
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new ModelHandler(existingModel);
        }
    }
}

