/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.model.ChamModel;
import com.jaquadro.minecraft.chameleon.model.DefaultBlockHandler;
import com.jaquadro.minecraft.chameleon.model.DefaultItemHandler;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.resources.IconUtil;
import com.jaquadro.minecraft.chameleon.resources.register.SmartHandlerRegister;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerDecoratorModel;
import com.jaquadro.minecraft.storagedrawers.client.model.dynamic.CommonDrawerRenderer;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;

public class CustomDrawerModel
extends ChamModel {
    private static final int[] iconIndex = new int[]{0, 0, 1, 0, 2};
    private TextureAtlasSprite iconParticle;

    public static CustomDrawerModel fromBlock(IBlockState state) {
        IExtendedBlockState xstate;
        TileEntityDrawers tile;
        if (state instanceof IExtendedBlockState && (tile = (TileEntityDrawers)(xstate = (IExtendedBlockState)state).getValue(BlockDrawers.TILE)) != null) {
            ItemStack matFront = tile.getEffectiveMaterialFront();
            ItemStack matSide = tile.getEffectiveMaterialSide();
            ItemStack matTrim = tile.getEffectiveMaterialTrim();
            return new CustomDrawerModel(state, matFront, matSide, matTrim, false);
        }
        return new CustomDrawerModel(state, false);
    }

    public static CustomDrawerModel fromItem(ItemStack stack) {
        IBlockState state = ModBlocks.customDrawers.func_176203_a(stack.func_77960_j());
        if (!stack.func_77942_o()) {
            return new CustomDrawerModel(state, true);
        }
        NBTTagCompound tag = stack.func_77978_p();
        ItemStack matFront = null;
        ItemStack matSide = null;
        ItemStack matTrim = null;
        if (tag.func_150297_b("MatF", 10)) {
            matFront = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatF"));
        }
        if (tag.func_150297_b("MatS", 10)) {
            matSide = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatS"));
        }
        if (tag.func_150297_b("MatT", 10)) {
            matTrim = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("MatT"));
        }
        return new CustomDrawerModel(state, matFront, matSide, matTrim, true);
    }

    private CustomDrawerModel(IBlockState state, boolean mergeLayers) {
        this(state, null, null, null, mergeLayers);
    }

    private CustomDrawerModel(IBlockState state, ItemStack matFront, ItemStack matSide, ItemStack matTrim, boolean mergeLayers) {
        super(state, mergeLayers, new Object[]{matFront, matSide, matTrim});
    }

    protected void renderMippedLayer(ChamRender renderer, IBlockState state, Object ... args) {
        EnumBasicDrawer info = (EnumBasicDrawer)((Object)state.func_177229_b((IProperty)BlockDrawers.BLOCK));
        int index = iconIndex[info.getDrawerCount()];
        TextureAtlasSprite iconFront = IconUtil.getIconFromStack((ItemStack)((ItemStack)args[0]));
        TextureAtlasSprite iconSide = IconUtil.getIconFromStack((ItemStack)((ItemStack)args[1]));
        TextureAtlasSprite iconTrim = IconUtil.getIconFromStack((ItemStack)((ItemStack)args[2]));
        if (iconFront == null) {
            iconFront = iconSide;
        }
        if (iconTrim == null) {
            iconTrim = iconSide;
        }
        if (iconFront == null) {
            iconFront = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultFront[index]);
        }
        if (iconSide == null) {
            iconSide = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        if (iconTrim == null) {
            iconTrim = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        this.iconParticle = iconSide;
        CommonDrawerRenderer drawerRenderer = new CommonDrawerRenderer(renderer);
        drawerRenderer.renderBasePass(null, state, BlockPos.field_177992_a, (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING), iconSide, iconTrim, iconFront);
    }

    protected void renderTransLayer(ChamRender renderer, IBlockState state, Object ... args) {
        EnumBasicDrawer info = (EnumBasicDrawer)((Object)state.func_177229_b((IProperty)BlockDrawers.BLOCK));
        int index = iconIndex[info.getDrawerCount()];
        TextureAtlasSprite iconOverlayFace = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayFace[index]);
        TextureAtlasSprite iconOverlayHandle = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayHandle[index]);
        TextureAtlasSprite iconOverlayTrim = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayTrim[index]);
        CommonDrawerRenderer drawerRenderer = new CommonDrawerRenderer(renderer);
        drawerRenderer.renderOverlayPass(null, state, BlockPos.field_177992_a, (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING), iconOverlayTrim, iconOverlayHandle, iconOverlayFace);
    }

    public TextureAtlasSprite func_177554_e() {
        return this.iconParticle;
    }

    public static class ItemModelHandler
    extends DefaultItemHandler {
        public ItemModelHandler() {
            super(Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide));
        }

        public IBakedModel handleItemState(ItemStack stack) {
            return CustomDrawerModel.fromItem(stack);
        }
    }

    public static class ModelHandler
    extends DefaultBlockHandler {
        public ModelHandler() {
            super(Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide));
        }

        public IBakedModel handleBlockState(IBlockState state) {
            CustomDrawerModel mainModel = CustomDrawerModel.fromBlock(state);
            if (!(state instanceof IExtendedBlockState)) {
                return mainModel;
            }
            IExtendedBlockState xstate = (IExtendedBlockState)state;
            TileEntityDrawers tile = (TileEntityDrawers)xstate.getValue(BlockDrawers.TILE);
            if (!DrawerDecoratorModel.shouldHandleState(tile)) {
                return mainModel;
            }
            EnumBasicDrawer drawer = (EnumBasicDrawer)((Object)state.func_177229_b((IProperty)BlockDrawers.BLOCK));
            EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING);
            return new DrawerDecoratorModel((IBakedModel)mainModel, xstate, drawer, dir, tile);
        }
    }

    public static class Register
    extends SmartHandlerRegister<ModelHandler, ItemModelHandler> {
        public static final ResourceLocation iconDefaultSide = new ResourceLocation("StorageDrawers:blocks/drawers_raw_side");
        public static final ResourceLocation[] iconDefaultFront = new ResourceLocation[]{new ResourceLocation("StorageDrawers:blocks/drawers_raw_front_1"), new ResourceLocation("StorageDrawers:blocks/drawers_raw_front_2"), new ResourceLocation("StorageDrawers:blocks/drawers_raw_front_4")};
        public static final ResourceLocation[] iconOverlayTrim = new ResourceLocation[]{new ResourceLocation("StorageDrawers:blocks/overlay/shading_trim_1"), new ResourceLocation("StorageDrawers:blocks/overlay/shading_trim_2"), new ResourceLocation("StorageDrawers:blocks/overlay/shading_trim_4")};
        public static final ResourceLocation[] iconOverlayBoldTrim = new ResourceLocation[]{new ResourceLocation("StorageDrawers:blocks/overlay/shading_boldtrim_1"), new ResourceLocation("StorageDrawers:blocks/overlay/shading_boldtrim_2"), new ResourceLocation("StorageDrawers:blocks/overlay/shading_boldtrim_4")};
        public static final ResourceLocation[] iconOverlayFace = new ResourceLocation[]{new ResourceLocation("StorageDrawers:blocks/overlay/shading_face_1"), new ResourceLocation("StorageDrawers:blocks/overlay/shading_face_2"), new ResourceLocation("StorageDrawers:blocks/overlay/shading_face_4")};
        public static final ResourceLocation[] iconOverlayHandle = new ResourceLocation[]{new ResourceLocation("StorageDrawers:blocks/overlay/handle_1"), new ResourceLocation("StorageDrawers:blocks/overlay/handle_2"), new ResourceLocation("StorageDrawers:blocks/overlay/handle_4")};

        public Register() {
            super((Block)ModBlocks.customDrawers);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (EnumBasicDrawer drawer : EnumBasicDrawer.values()) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    states.add(ModBlocks.customDrawers.func_176223_P().func_177226_a((IProperty)BlockDrawers.BLOCK, (Comparable)((Object)drawer)).func_177226_a((IProperty)BlockDrawers.FACING, (Comparable)dir));
                }
            }
            return states;
        }

        public List<ResourceLocation> getTextureResources() {
            ArrayList<ResourceLocation> resource = new ArrayList<ResourceLocation>();
            resource.add(iconDefaultSide);
            resource.addAll(Arrays.asList(iconDefaultFront));
            resource.addAll(Arrays.asList(iconOverlayTrim));
            resource.addAll(Arrays.asList(iconOverlayBoldTrim));
            resource.addAll(Arrays.asList(iconOverlayFace));
            resource.addAll(Arrays.asList(iconOverlayHandle));
            return resource;
        }
    }
}

