/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.model.ChamModel;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.client.model.dynamic.CommonFramingRenderer;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.vector.Vector3f;

public class FramingTableModel
extends ChamModel {
    private TextureAtlasSprite iconParticle;

    public FramingTableModel(IBlockState state) {
        this(state, false);
    }

    protected FramingTableModel(IBlockState state, boolean mergeLayers) {
        super(state, mergeLayers, new Object[0]);
    }

    protected void renderStart(ChamRender renderer, IBlockState state, Object ... args) {
        renderer.state.setRotateTransform(3, ((EnumFacing)state.func_177229_b((IProperty)BlockFramingTable.FACING)).func_176745_a());
    }

    protected void renderEnd(ChamRender renderer, IBlockState state, Object ... args) {
        renderer.state.clearRotateTransform();
    }

    protected void renderSolidLayer(ChamRender renderer, IBlockState state, Object ... args) {
        TextureAtlasSprite iconBase = Chameleon.instance.iconRegistry.getIcon(Register.iconBaseOak);
        TextureAtlasSprite iconTrim = Chameleon.instance.iconRegistry.getIcon(Register.iconTrimOak);
        this.renderSolidLayer(state, new CommonFramingRenderer(renderer), iconBase, iconTrim);
        this.iconParticle = iconBase;
    }

    protected void renderTransLayer(ChamRender renderer, IBlockState state, Object ... args) {
        TextureAtlasSprite iconOverlayLeft = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayLeft);
        TextureAtlasSprite iconOverlayRight = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayRight);
        this.renderTransLayer(state, new CommonFramingRenderer(renderer), iconOverlayLeft, iconOverlayRight);
    }

    protected void renderSolidLayer(IBlockState state, CommonFramingRenderer common, TextureAtlasSprite iconBase, TextureAtlasSprite iconTrim) {
        if (((Boolean)state.func_177229_b((IProperty)BlockFramingTable.RIGHT_SIDE)).booleanValue()) {
            common.renderRight(null, state, BlockPos.field_177992_a, iconBase, iconTrim);
        } else {
            common.renderLeft(null, state, BlockPos.field_177992_a, iconBase, iconTrim);
        }
    }

    protected void renderTransLayer(IBlockState state, CommonFramingRenderer common, TextureAtlasSprite iconLeft, TextureAtlasSprite iconRight) {
        if (((Boolean)state.func_177229_b((IProperty)BlockFramingTable.RIGHT_SIDE)).booleanValue()) {
            common.renderOverlayRight(null, state, BlockPos.field_177992_a, iconRight);
        } else {
            common.renderOverlayLeft(null, state, BlockPos.field_177992_a, iconLeft);
        }
    }

    public TextureAtlasSprite func_177554_e() {
        return this.iconParticle;
    }

    public static class ItemModel
    extends FramingTableModel {
        private static final ItemTransformVec3f transformDefault = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(-0.15f, 0.0f, 0.0f), new Vector3f(0.65f, 0.65f, 0.65f));
        private static final ItemTransformVec3f transformThirdPerson = new ItemTransformVec3f(new Vector3f(10.0f, 0.0f, 180.0f), new Vector3f(0.2f, 0.1f, -0.15f), new Vector3f(0.3f, 0.3f, 0.3f));
        private static final ItemCameraTransforms transform = new ItemCameraTransforms(transformThirdPerson, transformDefault, transformDefault, transformDefault, transformDefault, transformDefault);

        public ItemModel(ItemStack stack) {
            super(ModBlocks.framingTable.func_176203_a(stack.func_77960_j()), true);
        }

        @Override
        protected void renderSolidLayer(IBlockState state, CommonFramingRenderer common, TextureAtlasSprite iconBase, TextureAtlasSprite iconTrim) {
            common.renderRight(null, state, BlockPos.field_177992_a, iconBase, iconTrim);
            common.renderLeft(null, state, BlockPos.field_177992_a.func_177974_f(), iconBase, iconTrim);
        }

        @Override
        protected void renderTransLayer(IBlockState state, CommonFramingRenderer common, TextureAtlasSprite iconLeft, TextureAtlasSprite iconRight) {
            common.renderOverlayRight(null, state, BlockPos.field_177992_a, iconRight);
            common.renderOverlayLeft(null, state, BlockPos.field_177992_a.func_177974_f(), iconLeft);
        }

        public ItemCameraTransforms func_177552_f() {
            return transform;
        }
    }

    public static class Register
    extends DefaultRegister {
        public static final ResourceLocation iconBaseOak = new ResourceLocation("StorageDrawers:blocks/base/base_oak");
        public static final ResourceLocation iconTrimOak = new ResourceLocation("StorageDrawers:blocks/base/trim_oak");
        public static final ResourceLocation iconOverlayLeft = new ResourceLocation("StorageDrawers:blocks/overlay/shading_worktable_left");
        public static final ResourceLocation iconOverlayRight = new ResourceLocation("StorageDrawers:blocks/overlay/shading_worktable_right");

        public Register() {
            super((Block)ModBlocks.framingTable);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                for (Boolean side : new Boolean[]{false, true}) {
                    states.add(ModBlocks.framingTable.func_176223_P().func_177226_a((IProperty)BlockFramingTable.FACING, (Comparable)dir).func_177226_a((IProperty)BlockFramingTable.RIGHT_SIDE, (Comparable)side));
                }
            }
            return states;
        }

        public List<ResourceLocation> getTextureResources() {
            return Arrays.asList(iconBaseOak, iconTrimOak, iconOverlayLeft, iconOverlayRight);
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new FramingTableModel(state);
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new ItemModel(stack);
        }
    }
}

