/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model.dynamic;

import com.jaquadro.minecraft.chameleon.render.ChamRender;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public class CommonFramingRenderer {
    private static double unit = 0.0625;
    private static double unit2 = unit * 2.0;
    private static double unit4 = unit * 4.0;
    private static double[][] baseBoundsLeftY = new double[][]{{unit, 1.0 - unit2, unit, 1.0, 1.0, 1.0 - unit}};
    private static double[][] trimBoundsLeftY = new double[][]{{0.0, 1.0 - unit2, unit, unit, 1.0, 1.0 - unit}, {0.0, 1.0 - unit2, 0.0, unit, 1.0, unit}, {0.0, 1.0 - unit2, 1.0 - unit, unit, 1.0, 1.0}, {unit, 1.0 - unit2, 0.0, 1.0, 1.0, unit}, {unit, 1.0 - unit2, 1.0 - unit, 1.0, 1.0, 1.0}};
    private static double[][] trimBoundsLeftZ = new double[][]{{0.0, 1.0 - unit2, 0.0, unit, 1.0, 1.0}, {unit, 1.0 - unit2, 0.0, 1.0, 1.0, 1.0}};
    private static double[][] trimBoundsLeftX = new double[][]{{0.0, 1.0 - unit2, 0.0, 1.0, 1.0, unit}, {0.0, 1.0 - unit2, unit, 1.0, 1.0, 1.0 - unit}, {0.0, 1.0 - unit2, 1.0 - unit, 1.0, 1.0, 1.0}};
    private static double[][] baseBoundsRightY = new double[][]{{0.0, 1.0 - unit2, unit, 1.0 - unit, 1.0, 1.0 - unit}};
    private static double[][] trimBoundsRightY = new double[][]{{1.0 - unit, 1.0 - unit2, unit, 1.0, 1.0, 1.0 - unit}, {1.0 - unit, 1.0 - unit2, 0.0, 1.0, 1.0, unit}, {1.0 - unit, 1.0 - unit2, 1.0 - unit, 1.0, 1.0, 1.0}, {0.0, 1.0 - unit2, 0.0, 1.0 - unit, 1.0, unit}, {0.0, 1.0 - unit2, 1.0 - unit, 1.0 - unit, 1.0, 1.0}};
    private static double[][] trimBoundsRightZ = new double[][]{{1.0 - unit, 1.0 - unit2, 0.0, 1.0, 1.0, 1.0}, {0.0, 1.0 - unit2, 0.0, 1.0 - unit, 1.0, 1.0}};
    private static double[][] trimBoundsRightX = new double[][]{{0.0, 1.0 - unit2, 0.0, 1.0, 1.0, unit}, {0.0, 1.0 - unit2, unit, 1.0, 1.0, 1.0 - unit}, {0.0, 1.0 - unit2, 1.0 - unit, 1.0, 1.0, 1.0}};
    private ChamRender renderer;

    public CommonFramingRenderer(ChamRender renderer) {
        this.renderer = renderer;
    }

    public void renderLeft(IBlockAccess blockAccess, IBlockState state, BlockPos pos, TextureAtlasSprite iconBase, TextureAtlasSprite iconTrim) {
        this.renderTableBox(blockAccess, state, pos, iconBase, iconTrim, baseBoundsLeftY, trimBoundsLeftY, trimBoundsLeftZ, trimBoundsLeftX, true);
        this.renderStructure(blockAccess, state, pos, iconBase, true);
    }

    public void renderRight(IBlockAccess blockAccess, IBlockState state, BlockPos pos, TextureAtlasSprite iconBase, TextureAtlasSprite iconTrim) {
        this.renderTableBox(blockAccess, state, pos, iconBase, iconTrim, baseBoundsRightY, trimBoundsRightY, trimBoundsRightZ, trimBoundsRightX, false);
        this.renderStructure(blockAccess, state, pos, iconBase, false);
    }

    public void renderOverlayLeft(IBlockAccess blockAccess, IBlockState state, BlockPos pos, TextureAtlasSprite iconOverlay) {
        this.renderOverlay(blockAccess, state, pos, iconOverlay, baseBoundsLeftY);
    }

    public void renderOverlayRight(IBlockAccess blockAccess, IBlockState state, BlockPos pos, TextureAtlasSprite iconOverlay) {
        this.renderOverlay(blockAccess, state, pos, iconOverlay, baseBoundsRightY);
    }

    public void renderOverlay(IBlockAccess blockAccess, IBlockState state, BlockPos pos, TextureAtlasSprite iconOverlay, double[][] baseBoundsY) {
        this.renderer.targetFaceGroup(true);
        this.renderer.state.setUVRotation(1, this.renderer.state.rotateTransform);
        for (double[] bound : baseBoundsY) {
            this.renderer.setRenderBounds(bound);
            this.renderer.renderFace(ChamRender.FACE_YPOS, blockAccess, state, pos, iconOverlay);
        }
        this.renderer.state.clearUVRotation(1);
        this.renderer.targetFaceGroup(false);
    }

    private void renderStructure(IBlockAccess blockAccess, IBlockState state, BlockPos pos, TextureAtlasSprite iconBase, boolean left) {
        this.renderFoot(blockAccess, state, pos, iconBase, left);
        this.renderLegs(blockAccess, state, pos, iconBase, left);
        this.renderBraces(blockAccess, state, pos, iconBase, left);
    }

    private void renderTableBox(IBlockAccess blockAccess, IBlockState state, BlockPos pos, TextureAtlasSprite iconBase, TextureAtlasSprite iconTrim, double[][] baseBoundsY, double[][] trimBoundsY, double[][] trimBoundsZ, double[][] trimBoundsX, boolean left) {
        EnumFacing xSide = left ? ChamRender.FACE_XNEG : ChamRender.FACE_XPOS;
        for (int i = 0; i < 2; ++i) {
            this.renderer.state.setUVRotation(i, this.renderer.state.rotateTransform);
        }
        for (double[] bound : baseBoundsY) {
            this.renderTableSurface(blockAccess, state, pos, iconBase, bound);
        }
        for (double[] bound : trimBoundsY) {
            this.renderTableSurface(blockAccess, state, pos, iconTrim, bound);
        }
        this.renderer.targetFaceGroup(true);
        for (double[] bound : trimBoundsZ) {
            this.renderer.setRenderBounds(bound);
            this.renderer.renderFace(ChamRender.FACE_ZNEG, blockAccess, state, pos, iconTrim);
            this.renderer.renderFace(ChamRender.FACE_ZPOS, blockAccess, state, pos, iconTrim);
        }
        for (double[] bound : trimBoundsX) {
            this.renderer.setRenderBounds(bound);
            this.renderer.renderFace(xSide, blockAccess, state, pos, iconTrim);
        }
        this.renderer.targetFaceGroup(false);
        for (int i = 0; i < 2; ++i) {
            this.renderer.state.clearUVRotation(i);
        }
    }

    private void renderTableSurface(IBlockAccess blockAccess, IBlockState state, BlockPos pos, TextureAtlasSprite icon, double[] bound) {
        this.renderer.setRenderBounds(bound);
        this.renderer.targetFaceGroup(true);
        this.renderer.renderFace(ChamRender.FACE_YPOS, blockAccess, state, pos, icon);
        this.renderer.targetFaceGroup(false);
        this.renderer.renderFace(ChamRender.FACE_YNEG, blockAccess, state, pos, icon);
    }

    private void renderFoot(IBlockAccess blockAccess, IBlockState state, BlockPos pos, TextureAtlasSprite icon, boolean left) {
        int i;
        float oldColor = this.renderer.state.colorMultYPos;
        this.renderer.state.colorMultYPos = 0.9f;
        for (int i2 = 0; i2 < 2; ++i2) {
            this.renderer.state.setUVRotation(i2, (this.renderer.state.rotateTransform + 1) % 4);
        }
        double xStart = left ? unit2 : 1.0 - unit2 - unit2;
        this.renderer.setRenderBounds(xStart, 0.0, 0.0, xStart + unit2, unit2, 1.0);
        for (i = 0; i < 6; ++i) {
            this.renderer.renderFace(EnumFacing.func_82600_a((int)i), blockAccess, state, pos, icon);
        }
        for (i = 0; i < 2; ++i) {
            this.renderer.state.clearUVRotation(i);
        }
        this.renderer.state.colorMultYPos = oldColor;
    }

    private void renderLegs(IBlockAccess blockAccess, IBlockState state, BlockPos pos, TextureAtlasSprite icon, boolean left) {
        int i;
        for (int i2 = 2; i2 < 6; ++i2) {
            this.renderer.state.setUVRotation(i2, 1);
        }
        double xStart = left ? unit2 : 1.0 - unit2 - unit2;
        this.renderer.setRenderBounds(xStart, unit2, unit2, xStart + unit2, 1.0 - unit2, unit2 + unit2);
        for (i = 2; i < 6; ++i) {
            this.renderer.renderFace(EnumFacing.func_82600_a((int)i), blockAccess, state, pos, icon);
        }
        this.renderer.setRenderBounds(xStart, unit2, 1.0 - unit2 - unit2, xStart + unit2, 1.0 - unit2, 1.0 - unit2);
        for (i = 2; i < 6; ++i) {
            this.renderer.renderFace(EnumFacing.func_82600_a((int)i), blockAccess, state, pos, icon);
        }
        for (i = 2; i < 6; ++i) {
            this.renderer.state.clearUVRotation(i);
        }
    }

    private void renderBraces(IBlockAccess blockAccess, IBlockState state, BlockPos pos, TextureAtlasSprite icon, boolean left) {
        int i;
        float oldColor = this.renderer.state.colorMultYPos;
        this.renderer.state.colorMultYPos = 0.85f;
        for (int i2 = 0; i2 < 2; ++i2) {
            this.renderer.state.setUVRotation(i2, this.renderer.state.rotateTransform);
        }
        double xStart = left ? unit2 + unit2 : 0.0;
        double xStop = left ? 1.0 : 1.0 - unit2 - unit2;
        this.renderer.setRenderBounds(xStart, unit4, unit2, xStop, unit4 + unit2, unit2 + unit2);
        for (i = 0; i < 4; ++i) {
            this.renderer.renderFace(EnumFacing.func_82600_a((int)i), blockAccess, state, pos, icon);
        }
        this.renderer.setRenderBounds(xStart, unit4, 1.0 - unit2 - unit2, xStop, unit4 + unit2, 1.0 - unit2);
        for (i = 0; i < 4; ++i) {
            this.renderer.renderFace(EnumFacing.func_82600_a((int)i), blockAccess, state, pos, icon);
        }
        for (i = 0; i < 2; ++i) {
            this.renderer.state.clearUVRotation(i);
        }
        this.renderer.state.colorMultYPos = oldColor;
    }
}

