/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.resources.ModelRegistry;
import com.jaquadro.minecraft.chameleon.resources.register.IUnifiedRegister;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrimCustom;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntitySlave;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityTrim;
import com.jaquadro.minecraft.storagedrawers.client.model.BasicDrawerModel;
import com.jaquadro.minecraft.storagedrawers.client.model.CompDrawerModel;
import com.jaquadro.minecraft.storagedrawers.client.model.CustomDrawerModel;
import com.jaquadro.minecraft.storagedrawers.client.model.CustomTrimModel;
import com.jaquadro.minecraft.storagedrawers.client.model.FramingTableModel;
import com.jaquadro.minecraft.storagedrawers.client.renderer.TileEntityDrawersRenderer;
import com.jaquadro.minecraft.storagedrawers.client.renderer.TileEntityFramingRenderer;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.item.ItemBasicDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemCompDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemController;
import com.jaquadro.minecraft.storagedrawers.item.ItemCustomDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemCustomTrim;
import com.jaquadro.minecraft.storagedrawers.item.ItemFramingTable;
import com.jaquadro.minecraft.storagedrawers.item.ItemTrim;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ModBlocks {
    public static BlockDrawers basicDrawers;
    public static BlockCompDrawers compDrawers;
    public static BlockController controller;
    public static BlockSlave controllerSlave;
    public static BlockTrim trim;
    public static BlockFramingTable framingTable;
    public static BlockDrawersCustom customDrawers;
    public static BlockTrimCustom customTrim;

    public void init() {
        basicDrawers = new BlockDrawers("basicDrawers");
        compDrawers = new BlockCompDrawers("compDrawers");
        controller = new BlockController("controller");
        controllerSlave = new BlockSlave("controllerSlave");
        trim = new BlockTrim("trim");
        framingTable = new BlockFramingTable("framingTable");
        customDrawers = new BlockDrawersCustom("customDrawers");
        customTrim = new BlockTrimCustom("customTrim");
        ConfigManager config = StorageDrawers.config;
        GameRegistry.registerBlock((Block)basicDrawers, ItemBasicDrawers.class, (String)"basicDrawers");
        GameRegistry.registerTileEntity(TileEntityDrawersStandard.class, (String)ModBlocks.getQualifiedName((Block)basicDrawers));
        if (config.isBlockEnabled("compdrawers")) {
            GameRegistry.registerBlock((Block)compDrawers, ItemCompDrawers.class, (String)"compDrawers");
            GameRegistry.registerTileEntity(TileEntityDrawersComp.class, (String)ModBlocks.getQualifiedName((Block)compDrawers));
        }
        if (config.isBlockEnabled("controller")) {
            GameRegistry.registerBlock((Block)controller, ItemController.class, (String)"controller");
            GameRegistry.registerTileEntity(TileEntityController.class, (String)ModBlocks.getQualifiedName((Block)controller));
        }
        if (config.isBlockEnabled("controllerSlave")) {
            GameRegistry.registerBlock((Block)controllerSlave, (String)"controllerSlave");
            GameRegistry.registerTileEntity(TileEntitySlave.class, (String)ModBlocks.getQualifiedName((Block)controllerSlave));
        }
        if (config.isBlockEnabled("trim")) {
            GameRegistry.registerBlock((Block)trim, ItemTrim.class, (String)"trim");
        }
        if (config.cache.enableFramedDrawers) {
            GameRegistry.registerBlock((Block)framingTable, ItemFramingTable.class, (String)"framingTable");
            GameRegistry.registerTileEntity(TileEntityFramingTable.class, (String)ModBlocks.getQualifiedName((Block)framingTable));
            GameRegistry.registerBlock((Block)customDrawers, ItemCustomDrawers.class, (String)"customDrawers");
            GameRegistry.registerBlock((Block)customTrim, ItemCustomTrim.class, (String)"customTrim");
            GameRegistry.registerTileEntity(TileEntityTrim.class, (String)ModBlocks.getQualifiedName(trim));
        }
        StorageDrawers.proxy.registerDrawer((Block)basicDrawers);
        StorageDrawers.proxy.registerDrawer((Block)compDrawers);
        for (String key : new String[]{"drawerBasic"}) {
            OreDictionary.registerOre((String)key, (ItemStack)new ItemStack((Block)basicDrawers, 1, Short.MAX_VALUE));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initDynamic() {
        basicDrawers.initDynamic();
        compDrawers.initDynamic();
        customDrawers.initDynamic();
    }

    @SideOnly(value=Side.CLIENT)
    public void initClient() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDrawersStandard.class, (TileEntitySpecialRenderer)new TileEntityDrawersRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDrawersComp.class, (TileEntitySpecialRenderer)new TileEntityDrawersRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFramingTable.class, (TileEntitySpecialRenderer)new TileEntityFramingRenderer());
        ModelRegistry modelRegistry = Chameleon.instance.modelRegistry;
        modelRegistry.registerModel((IUnifiedRegister)new BasicDrawerModel.Register());
        modelRegistry.registerModel((IUnifiedRegister)new CompDrawerModel.Register());
        modelRegistry.registerModel((IUnifiedRegister)new FramingTableModel.Register());
        modelRegistry.registerModel((IUnifiedRegister)new CustomDrawerModel.Register());
        modelRegistry.registerModel((IUnifiedRegister)new CustomTrimModel.Register());
        modelRegistry.registerItemVariants((Block)trim);
        modelRegistry.registerItemVariants((Block)controller);
        modelRegistry.registerItemVariants((Block)controllerSlave);
    }

    public static String getQualifiedName(Block block) {
        return GameData.getBlockRegistry().getNameForObject((Object)block).toString();
    }
}

