/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class DrawerInventoryHelper {
    private static final Random RANDOM = new Random();

    public static void dropInventoryItems(World world, BlockPos pos, IDrawerGroup group) {
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            ItemStack stack;
            if (!group.isDrawerEnabled(i)) continue;
            IDrawer drawer = group.getDrawer(i);
            while (drawer.getStoredItemCount() > 0 && (stack = drawer.getStoredItemCopy()) != null && stack.field_77994_a != 0) {
                DrawerInventoryHelper.spawnItemStack(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
                drawer.setStoredItemCount(0);
            }
        }
    }

    private static void spawnItemStack(World world, double x, double y, double z, ItemStack stack) {
        float xOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        float yOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        float zOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int dropAmt = RANDOM.nextInt(21) + 10;
            if (dropAmt > stack.field_77994_a) {
                dropAmt = stack.field_77994_a;
            }
            stack.field_77994_a -= dropAmt;
            EntityItem entityitem = new EntityItem(world, x + (double)xOff, y + (double)yOff, z + (double)zOff, new ItemStack(stack.func_77973_b(), dropAmt, stack.func_77960_j()));
            if (stack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            float velocity = 0.05f;
            entityitem.field_70159_w = RANDOM.nextGaussian() * (double)velocity;
            entityitem.field_70181_x = RANDOM.nextGaussian() * (double)velocity + (double)0.2f;
            entityitem.field_70179_y = RANDOM.nextGaussian() * (double)velocity;
            world.func_72838_d((Entity)entityitem);
        }
    }
}

