/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStatus;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeVoid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;

public class InventoryUpgrade
implements IInventory {
    private static final int upgradeCapacity = 5;
    private TileEntityDrawers tile;

    public InventoryUpgrade(TileEntityDrawers tileEntity) {
        this.tile = tileEntity;
    }

    public int func_70302_i_() {
        return 5;
    }

    public ItemStack func_70301_a(int slot) {
        return this.tile.getUpgrade(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack stack = this.tile.getUpgrade(slot);
        if (count > 0) {
            this.tile.setUpgrade(slot, null);
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.tile.setUpgrade(slot, item);
    }

    public String func_70005_c_() {
        return this.tile.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.tile.func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return this.tile.func_145748_c_();
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        this.tile.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.tile.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return item.func_77973_b() instanceof ItemUpgradeStorage || item.func_77973_b() instanceof ItemUpgradeStatus || item.func_77973_b() instanceof ItemUpgradeVoid;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean canRemoveStorageUpgrade(int storageLevel) {
        return this.canRemoveStorageUpgrade(this.tile, storageLevel);
    }

    private boolean canRemoveStorageUpgrade(TileEntityDrawers tile, int storageLevel) {
        int storageMult = StorageDrawers.config.getStorageUpgradeMultiplier(storageLevel);
        int effectiveStorageMult = tile.getEffectiveStorageMultiplier();
        if (effectiveStorageMult == storageMult) {
            --storageMult;
        }
        int addedStackCapacity = storageMult * tile.getDrawerCapacity();
        for (int i = 0; i < tile.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!tile.isDrawerEnabled(i) || (drawer = tile.getDrawer(i)).isEmpty()) continue;
            int addedItemCapacity = addedStackCapacity * drawer.getStoredItemStackSize();
            if (drawer.getMaxCapacity() - addedItemCapacity >= drawer.getStoredItemCount()) continue;
            return false;
        }
        return true;
    }
}

