/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.inventory.IDrawerInventory;
import com.jaquadro.minecraft.storagedrawers.api.inventory.IInventoryAdapter;
import com.jaquadro.minecraft.storagedrawers.api.inventory.SlotType;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IItemLockable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.inventory.ISideManager;
import com.jaquadro.minecraft.storagedrawers.storage.IUpgradeProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;

public class StorageInventory
implements IDrawerInventory {
    private static final int[] emptySlots = new int[0];
    private final IDrawerGroup group;
    private final ISideManager sideMan;
    private final IUpgradeProvider upgrade;
    private final int[] inventorySlots;

    public StorageInventory(IDrawerGroup drawerGroup, ISideManager sideManager, IUpgradeProvider upgradeProvider) {
        this.group = drawerGroup;
        this.sideMan = sideManager;
        this.upgrade = upgradeProvider;
        this.inventorySlots = new int[this.group.getDrawerCount() * SlotType.values.length];
        int n = this.inventorySlots.length;
        for (int i = 0; i < n; ++i) {
            this.inventorySlots[i] = i;
        }
    }

    @Override
    public int getDrawerSlot(int inventorySlot) {
        return inventorySlot % this.group.getDrawerCount();
    }

    @Override
    public SlotType getInventorySlotType(int inventorySlot) {
        return SlotType.values[inventorySlot / this.group.getDrawerCount()];
    }

    @Override
    public int getInventorySlot(int drawerSlot, SlotType type) {
        return this.group.getDrawerCount() * type.ordinal() + drawerSlot;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack) {
        if (!StorageDrawers.config.cache.enableSidedInput) {
            return false;
        }
        int lowerThresh = SlotType.INPUT.ordinal() * this.group.getDrawerCount();
        int upperThresh = lowerThresh + this.group.getDrawerCount();
        if (slot < lowerThresh || slot >= upperThresh) {
            return false;
        }
        int baseSlot = this.getDrawerSlot(slot);
        if (!this.group.isDrawerEnabled(baseSlot)) {
            return false;
        }
        IDrawer drawer = this.group.getDrawer(baseSlot);
        if (drawer == null) {
            return false;
        }
        if (drawer.isEmpty() && drawer instanceof IItemLockable && ((IItemLockable)((Object)drawer)).isItemLocked(LockAttribute.LOCK_EMPTY)) {
            return false;
        }
        return drawer.canItemBeStored(stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack) {
        if (!StorageDrawers.config.cache.enableSidedOutput) {
            return false;
        }
        int lowerThresh = SlotType.OUTPUT.ordinal() * this.group.getDrawerCount();
        int upperThresh = lowerThresh + this.group.getDrawerCount();
        if (slot < lowerThresh || slot >= upperThresh) {
            return false;
        }
        int baseSlot = this.getDrawerSlot(slot);
        if (!this.group.isDrawerEnabled(baseSlot)) {
            return false;
        }
        IDrawer drawer = this.group.getDrawer(baseSlot);
        if (drawer == null) {
            return false;
        }
        if (drawer.getStoredItemCount() == 0) {
            return false;
        }
        return drawer.canItemBeExtracted(stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] autoSides;
        for (int aside : autoSides = this.sideMan.getSlotsForSide(side)) {
            if (side.ordinal() != aside) continue;
            return this.inventorySlots;
        }
        return emptySlots;
    }

    public boolean func_180462_a(int slot, ItemStack item, EnumFacing side) {
        return this.canInsertItem(slot, item);
    }

    public boolean func_180461_b(int slot, ItemStack item, EnumFacing side) {
        return this.canExtractItem(slot, item);
    }

    public int func_70302_i_() {
        return this.inventorySlots.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.func_70302_i_()) {
            return null;
        }
        IDrawer drawer = this.group.getDrawer(this.getDrawerSlot(slot));
        if (drawer == null) {
            return null;
        }
        if (!(drawer instanceof IInventoryAdapter)) {
            return null;
        }
        IInventoryAdapter adapter = (IInventoryAdapter)((Object)drawer);
        adapter.syncInventory();
        return adapter.getInventoryStack(this.getInventorySlotType(slot));
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (slot < 0 || slot >= this.func_70302_i_()) {
            return null;
        }
        IDrawer drawer = this.group.getDrawer(this.getDrawerSlot(slot));
        if (drawer == null) {
            return null;
        }
        if (!(drawer instanceof IInventoryAdapter)) {
            return null;
        }
        IInventoryAdapter adapter = (IInventoryAdapter)((Object)drawer);
        adapter.syncInventory();
        ItemStack stack = adapter.getInventoryStack(SlotType.OUTPUT).func_77946_l();
        stack.field_77994_a = Math.min(stack.field_77994_a, count);
        adapter.getInventoryStack((SlotType)SlotType.OUTPUT).field_77994_a -= stack.field_77994_a;
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        if (slot < 0 || slot >= this.func_70302_i_()) {
            return;
        }
        IDrawer drawer = this.group.getDrawer(this.getDrawerSlot(slot));
        if (drawer == null) {
            return;
        }
        if (!(drawer instanceof IInventoryAdapter)) {
            return;
        }
        IInventoryAdapter adapter = (IInventoryAdapter)((Object)drawer);
        switch (this.getInventorySlotType(slot)) {
            case INPUT: {
                if (drawer.isEmpty()) {
                    this.setInventorySlotContents(drawer, item);
                    return;
                }
                adapter.setInStack(item);
                break;
            }
            case OUTPUT: {
                adapter.setOutStack(item);
            }
        }
    }

    private void setInventorySlotContents(IDrawer drawer, ItemStack item) {
        if (item == null) {
            drawer.setStoredItem(null, 0);
        } else {
            drawer.setStoredItem(item, 0);
            if (!drawer.canItemBeStored(item)) {
                drawer = this.findDrawer(item);
            }
            if (drawer == null) {
                return;
            }
            int insertCount = item.field_77994_a;
            if (insertCount > drawer.getMaxCapacity()) {
                insertCount = drawer.getMaxCapacity();
            }
            drawer.setStoredItemCount(insertCount);
            if (!this.upgrade.isVoid()) {
                item.field_77994_a = insertCount;
            }
        }
    }

    private IDrawer findDrawer(ItemStack item) {
        for (int i = 0; i < this.group.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!this.group.isDrawerEnabled(i) || !(drawer = this.group.getDrawer(i)).canItemBeStored(item)) continue;
            return drawer;
        }
        return null;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        int n = this.group.getDrawerCount();
        for (int i = 0; i < n; ++i) {
            IDrawer drawer;
            if (!this.group.isDrawerEnabled(i) || !((drawer = this.group.getDrawer(i)) instanceof IInventoryAdapter)) continue;
            ((IInventoryAdapter)((Object)drawer)).syncInventory();
        }
    }

    @Override
    public boolean syncInventoryIfNeeded() {
        boolean synced = false;
        int n = this.group.getDrawerCount();
        for (int i = 0; i < n; ++i) {
            IDrawer drawer;
            if (!this.group.isDrawerEnabled(i) || !((drawer = this.group.getDrawer(i)) instanceof IInventoryAdapter)) continue;
            synced |= ((IInventoryAdapter)((Object)drawer)).syncInventoryIfNeeded();
        }
        return synced;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot < 0 || slot >= this.func_70302_i_()) {
            return false;
        }
        IDrawer drawer = this.group.getDrawer(this.getDrawerSlot(slot));
        if (drawer == null) {
            return false;
        }
        switch (this.getInventorySlotType(slot)) {
            case INPUT: {
                return this.canInsertItem(slot, item);
            }
        }
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

