/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.google.common.base.Function;
import com.jaquadro.minecraft.chameleon.resources.IItemMeshResolver;
import com.jaquadro.minecraft.chameleon.resources.IItemVariantProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBasicDrawers
extends ItemDrawers
implements IItemMeshResolver,
IItemVariantProvider {
    @SideOnly(value=Side.CLIENT)
    private MeshDefinition meshResolver;
    private Function nameFunction;

    public ItemBasicDrawers(Block block) {
        this(block, new Function(){

            @Nullable
            public Object apply(Object input) {
                ItemStack stack = (ItemStack)input;
                return EnumBasicDrawer.byMetadata(stack.func_77960_j()).getUnlocalizedName();
            }
        });
    }

    protected ItemBasicDrawers(Block block, Function function) {
        super(block);
        this.func_77627_a(true);
        this.nameFunction = function;
    }

    @Override
    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + this.nameFunction.apply((Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshResolver() {
        if (this.meshResolver == null) {
            this.meshResolver = new MeshDefinition();
        }
        return this.meshResolver;
    }

    public List<ResourceLocation> getItemVariants() {
        ResourceLocation location = GameData.getItemRegistry().getNameForObject((Object)this);
        ArrayList<ResourceLocation> variants = new ArrayList<ResourceLocation>();
        for (EnumBasicDrawer type : EnumBasicDrawer.values()) {
            for (BlockPlanks.EnumType material : BlockPlanks.EnumType.values()) {
                variants.add(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + '_' + type.func_176610_l() + '_' + material.func_176610_l()));
            }
        }
        return variants;
    }

    @SideOnly(value=Side.CLIENT)
    private class MeshDefinition
    implements ItemMeshDefinition {
        private MeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            if (stack == null) {
                return null;
            }
            EnumBasicDrawer drawer = EnumBasicDrawer.byMetadata(stack.func_77960_j());
            String material = "oak";
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("material")) {
                material = stack.func_77978_p().func_74779_i("material");
            }
            String key = "StorageDrawers:basicDrawers_" + drawer + "_" + material;
            return new ModelResourceLocation(key, "inventory");
        }
    }
}

