/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.google.common.base.Function;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemCustomDrawers
extends ItemDrawers {
    private Function nameFunction;

    public ItemCustomDrawers(Block block) {
        this(block, new Function(){

            @Nullable
            public Object apply(Object input) {
                ItemStack stack = (ItemStack)input;
                return EnumBasicDrawer.byMetadata(stack.func_77960_j()).getUnlocalizedName();
            }
        });
    }

    protected ItemCustomDrawers(Block block, Function function) {
        super(block);
        this.func_77627_a(true);
        this.nameFunction = function;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + this.nameFunction.apply((Object)stack);
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            return false;
        }
        TileEntityDrawers tile = (TileEntityDrawers)world.func_175625_s(pos);
        if (tile != null && stack.func_77942_o() && !stack.func_77978_p().func_74764_b("tile")) {
            if (stack.func_77978_p().func_74764_b("MatS")) {
                tile.setMaterialSide(ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("MatS")));
            }
            if (stack.func_77978_p().func_74764_b("MatT")) {
                tile.setMaterialTrim(ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("MatT")));
            }
            if (stack.func_77978_p().func_74764_b("MatF")) {
                tile.setMaterialFront(ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("MatF")));
            }
        }
        return true;
    }

    public static ItemStack makeItemStack(IBlockState blockState, int count, ItemStack matSide, ItemStack matTrim, ItemStack matFront) {
        Block block = blockState.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        if (!(item instanceof ItemCustomDrawers)) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (matSide != null) {
            tag.func_74782_a("MatS", (NBTBase)ItemCustomDrawers.getMaterialTag(matSide));
        }
        if (matTrim != null) {
            tag.func_74782_a("MatT", (NBTBase)ItemCustomDrawers.getMaterialTag(matTrim));
        }
        if (matFront != null) {
            tag.func_74782_a("MatF", (NBTBase)ItemCustomDrawers.getMaterialTag(matFront));
        }
        ItemStack stack = new ItemStack(item, count, block.func_176201_c(blockState));
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    private static NBTTagCompound getMaterialTag(ItemStack mat) {
        mat = mat.func_77946_l();
        mat.field_77994_a = 1;
        NBTTagCompound itag = new NBTTagCompound();
        mat.func_77955_b(itag);
        return itag;
    }
}

