/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityTrim;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemCustomTrim
extends ItemBlock {
    public ItemCustomTrim(Block block) {
        super(block);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            return false;
        }
        TileEntityTrim tile = (TileEntityTrim)world.func_175625_s(pos);
        if (tile != null && stack.func_77942_o() && !stack.func_77978_p().func_74764_b("tile")) {
            if (stack.func_77978_p().func_74764_b("MatS")) {
                tile.setMaterialSide(ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("MatS")));
            }
            if (stack.func_77978_p().func_74764_b("MatT")) {
                tile.setMaterialTrim(ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("MatT")));
            }
        }
        return true;
    }

    public static ItemStack makeItemStack(Block block, int count, ItemStack matSide, ItemStack matTrim) {
        Item item = Item.func_150898_a((Block)block);
        if (!(item instanceof ItemCustomTrim)) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (matSide != null) {
            tag.func_74782_a("MatS", (NBTBase)ItemCustomTrim.getMaterialTag(matSide));
        }
        if (matTrim != null) {
            tag.func_74782_a("MatT", (NBTBase)ItemCustomTrim.getMaterialTag(matTrim));
        }
        ItemStack stack = new ItemStack(item, count, 0);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    private static NBTTagCompound getMaterialTag(ItemStack mat) {
        mat = mat.func_77946_l();
        mat.field_77994_a = 1;
        NBTTagCompound itag = new NBTTagCompound();
        mat.func_77955_b(itag);
        return itag;
    }
}

