/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.google.common.base.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class UniqueMetaIdentifier {
    private final ResourceLocation loc;
    private final int meta;

    public UniqueMetaIdentifier(String modId, String name) {
        this.loc = new ResourceLocation(modId, name);
        this.meta = Short.MAX_VALUE;
    }

    public UniqueMetaIdentifier(String modId, String name, int meta) {
        this.loc = new ResourceLocation(modId, name);
        this.meta = meta;
    }

    public UniqueMetaIdentifier(String qualifiedName, int meta) {
        this.loc = new ResourceLocation(qualifiedName);
        this.meta = meta;
    }

    public UniqueMetaIdentifier(String compoundName) {
        this(compoundName, ';');
    }

    public UniqueMetaIdentifier(ResourceLocation loc) {
        this.loc = loc;
        this.meta = Short.MAX_VALUE;
    }

    public UniqueMetaIdentifier(ResourceLocation loc, int meta) {
        this.loc = loc;
        this.meta = meta;
    }

    public UniqueMetaIdentifier(String compoundName, char separator) {
        String[] parts1 = compoundName.split("[ ]*" + separator + "[ ]*");
        this.loc = new ResourceLocation(parts1[0]);
        this.meta = parts1.length >= 2 ? Integer.parseInt(parts1[1]) : Short.MAX_VALUE;
    }

    public ResourceLocation getResourceLocation() {
        return this.loc;
    }

    public int getMeta() {
        return this.meta;
    }

    public String getModID() {
        return this.loc.func_110624_b();
    }

    public String getName() {
        return this.loc.func_110623_a();
    }

    public Block getBlock() {
        return GameRegistry.findBlock((String)this.loc.func_110624_b(), (String)this.loc.func_110623_a());
    }

    public Item getItem() {
        return GameRegistry.findItem((String)this.loc.func_110624_b(), (String)this.loc.func_110623_a());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        UniqueMetaIdentifier other = (UniqueMetaIdentifier)obj;
        return Objects.equal((Object)this.loc, (Object)other.loc) && this.meta == other.meta;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.loc}) ^ this.meta * 37;
    }

    public String toString() {
        return String.format("%s;%d", this.loc, this.meta);
    }

    public static UniqueMetaIdentifier createFor(ItemStack itemStack) {
        if (itemStack.func_77973_b() == null) {
            return null;
        }
        ResourceLocation name = GameData.getItemRegistry().getNameForObject((Object)itemStack.func_77973_b());
        return new UniqueMetaIdentifier(name, itemStack.func_77952_i());
    }

    public static UniqueMetaIdentifier createFor(Block block, int meta) {
        if (block == null) {
            return null;
        }
        ResourceLocation name = GameData.getBlockRegistry().getNameForObject((Object)block);
        return new UniqueMetaIdentifier(name, meta);
    }

    public static UniqueMetaIdentifier createFor(Block block) {
        if (block == null) {
            return null;
        }
        ResourceLocation name = GameData.getBlockRegistry().getNameForObject((Object)block);
        return new UniqueMetaIdentifier(name);
    }
}

