/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.inventory.IDrawerInventory;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.IPriorityGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.ISmartGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.ILockable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IShroudable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntitySlave;
import com.jaquadro.minecraft.storagedrawers.inventory.DrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.jaquadro.minecraft.storagedrawers.util.ItemMetaListRegistry;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityController
extends TileEntity
implements IDrawerGroup,
IPriorityGroup,
ISmartGroup,
ISidedInventory {
    private static final int PRI_VOID = 0;
    private static final int PRI_LOCKED = 1;
    private static final int PRI_NORMAL = 2;
    private static final int PRI_EMPTY = 3;
    private static final int PRI_LOCKED_EMPTY = 4;
    private static final int PRI_DISABLED = 5;
    private static final int[] emptySlots = new int[0];
    private Queue<BlockPos> searchQueue = new LinkedList<BlockPos>();
    private Set<BlockPos> searchDiscovered = new HashSet<BlockPos>();
    private Comparator<SlotRecord> slotRecordComparator = new Comparator<SlotRecord>(){

        @Override
        public int compare(SlotRecord o1, SlotRecord o2) {
            return o1.priority - o2.priority;
        }
    };
    private Map<BlockPos, StorageRecord> storage = new HashMap<BlockPos, StorageRecord>();
    private List<SlotRecord> invSlotList = new ArrayList<SlotRecord>();
    private List<SlotRecord> drawerSlotList = new ArrayList<SlotRecord>();
    private ItemMetaListRegistry<SlotRecord> invPrimaryLookup = new ItemMetaListRegistry();
    private ItemMetaListRegistry<SlotRecord> drawerPrimaryLookup = new ItemMetaListRegistry();
    private int[] inventorySlots = new int[0];
    private int[] drawerSlots = new int[0];
    private int[] autoSides = new int[]{0, 1, 2, 3, 4, 5};
    private int drawerSize = 0;
    private int range;
    private long lastClickTime;
    private UUID lastClickUUID;
    private String customName;
    private DrawerItemHandler itemHandler = new DrawerItemHandler(this);

    private int getSlotPriority(SlotRecord record, boolean invBased) {
        int drawerSlot;
        IDrawerGroup group = this.getGroupForCoord(record.coord);
        if (group == null) {
            return 5;
        }
        int n = drawerSlot = invBased ? group.getDrawerInventory().getDrawerSlot(record.slot) : record.slot;
        if (!group.isDrawerEnabled(drawerSlot)) {
            return 5;
        }
        IDrawer drawer = group.getDrawer(drawerSlot);
        if (drawer.isEmpty()) {
            if (drawer instanceof ILockable && ((ILockable)((Object)drawer)).isLocked(LockAttribute.LOCK_EMPTY) || group instanceof ILockable && ((ILockable)((Object)group)).isLocked(LockAttribute.LOCK_EMPTY)) {
                return 4;
            }
            return 3;
        }
        if (drawer instanceof IVoidable && ((IVoidable)((Object)drawer)).isVoid() || group instanceof IVoidable && ((IVoidable)((Object)group)).isVoid()) {
            return 0;
        }
        if (drawer instanceof ILockable && ((ILockable)((Object)drawer)).isLocked(LockAttribute.LOCK_POPULATED) || group instanceof ILockable && ((ILockable)((Object)group)).isLocked(LockAttribute.LOCK_POPULATED)) {
            return 1;
        }
        return 2;
    }

    public TileEntityController() {
        this.invSlotList.add(new SlotRecord(null, 0));
        this.inventorySlots = new int[]{0};
        this.range = StorageDrawers.config.getControllerRange();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public int interactPutItemsIntoInventory(EntityPlayer player) {
        if (this.inventorySlots.length <= 1) {
            this.updateCache();
        }
        boolean dumpInventory = this.field_145850_b.func_82737_E() - this.lastClickTime < 10L && player.getPersistentID().equals(this.lastClickUUID);
        int count = 0;
        if (!dumpInventory) {
            ItemStack currentStack = player.field_71071_by.func_70448_g();
            if (currentStack != null) {
                count = this.insertItems(currentStack, player.func_146103_bH());
                if (currentStack.field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
            }
        } else {
            int n = player.field_71071_by.func_70302_i_();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.field_71071_by.func_70301_a(i);
                if (subStack == null) continue;
                count += this.insertItems(subStack, player.func_146103_bH());
                if (subStack.field_77994_a != 0) continue;
                player.field_71071_by.func_70299_a(i, null);
            }
            if (count > 0) {
                StorageDrawers.proxy.updatePlayerInventory(player);
            }
        }
        this.lastClickTime = this.field_145850_b.func_82737_E();
        this.lastClickUUID = player.getPersistentID();
        return count;
    }

    private int insertItems(ItemStack stack, GameProfile profile) {
        int itemsLeft = stack.field_77994_a;
        for (int slot : this.enumerateDrawersForInsertion(stack, false)) {
            IDrawerGroup group = this.getGroupForDrawerSlot(slot);
            if (group instanceof IProtectable && !SecurityManager.hasAccess(profile, (IProtectable)((Object)group))) continue;
            IDrawer drawer = this.getDrawer(slot);
            ItemStack itemProto = drawer.getStoredItemPrototype();
            if (itemProto == null) break;
            itemsLeft = this.insertItemsIntoDrawer(drawer, itemsLeft);
            if (drawer instanceof IVoidable && ((IVoidable)((Object)drawer)).isVoid()) {
                itemsLeft = 0;
            }
            if (itemsLeft != 0) continue;
            break;
        }
        int count = stack.field_77994_a - itemsLeft;
        stack.field_77994_a = itemsLeft;
        return count;
    }

    private int insertItemsIntoDrawer(IDrawer drawer, int itemCount) {
        IFractionalDrawer fracDrawer;
        int capacity = drawer.getMaxCapacity();
        int storedItems = drawer.getStoredItemCount();
        int storableItems = capacity - storedItems;
        if (drawer instanceof IFractionalDrawer && !(fracDrawer = (IFractionalDrawer)drawer).isSmallestUnit() && fracDrawer.getStoredItemRemainder() > 0) {
            --storableItems;
        }
        if (storableItems == 0) {
            return itemCount;
        }
        int remainder = Math.max(itemCount - storableItems, 0);
        drawer.setStoredItemCount(storedItems += Math.min(itemCount, storableItems));
        return remainder;
    }

    public void toggleProtection(GameProfile profile, ISecurityProvider provider) {
        IProtectable template = null;
        UUID state = null;
        for (StorageRecord record : this.storage.values()) {
            IProtectable protectable;
            if (record.storage == null || !(record.storage instanceof IProtectable) || !SecurityManager.hasOwnership(profile, protectable = (IProtectable)((Object)record.storage))) continue;
            if (template == null) {
                template = protectable;
                if (template.getOwner() == null) {
                    state = profile.getId();
                } else {
                    state = null;
                    provider = null;
                }
            }
            protectable.setOwner(state);
            protectable.setSecurityProvider(provider);
        }
    }

    public void toggleShroud(GameProfile profile) {
        IShroudable template = null;
        boolean state = false;
        for (StorageRecord record : this.storage.values()) {
            if (record.storage == null || record.storage instanceof IProtectable && !SecurityManager.hasAccess(profile, (IProtectable)((Object)record.storage))) continue;
            int n = record.storage.getDrawerCount();
            for (int i = 0; i < n; ++i) {
                IDrawer drawer;
                if (!record.storage.isDrawerEnabled(i) || !((drawer = record.storage.getDrawer(i)) instanceof IShroudable)) continue;
                IShroudable shroudableStorage = (IShroudable)((Object)drawer);
                if (template == null) {
                    template = shroudableStorage;
                    state = !template.isShrouded();
                }
                shroudableStorage.setIsShrouded(state);
            }
        }
    }

    public void toggleLock(EnumSet<LockAttribute> attributes, LockAttribute key, GameProfile profile) {
        ILockable template = null;
        boolean state = false;
        for (StorageRecord record : this.storage.values()) {
            if (record.storage == null || record.storage instanceof IProtectable && !SecurityManager.hasAccess(profile, (IProtectable)((Object)record.storage))) continue;
            if (record.storage instanceof ILockable) {
                ILockable lockableStorage = (ILockable)((Object)record.storage);
                if (template == null) {
                    template = lockableStorage;
                    state = !template.isLocked(key);
                }
                for (LockAttribute attr : attributes) {
                    lockableStorage.setLocked(attr, state);
                }
                continue;
            }
            int n = record.storage.getDrawerCount();
            for (int i = 0; i < n; ++i) {
                IDrawer drawer;
                if (!record.storage.isDrawerEnabled(i) || !((drawer = record.storage.getDrawer(i)) instanceof IShroudable)) continue;
                ILockable lockableStorage = (ILockable)((Object)drawer);
                if (template == null) {
                    template = lockableStorage;
                    state = !template.isLocked(key);
                }
                for (LockAttribute attr : attributes) {
                    lockableStorage.setLocked(attr, state);
                }
            }
        }
    }

    private void resetCache() {
        this.storage.clear();
        this.invSlotList.clear();
        this.drawerSlotList.clear();
        this.drawerSize = 0;
    }

    public boolean isValidSlave(BlockPos coord) {
        StorageRecord record = this.storage.get(coord);
        if (record == null || !record.mark) {
            return false;
        }
        return record.storage == null;
    }

    public void updateCache() {
        int preCount = this.inventorySlots.length;
        this.resetCache();
        this.populateNodes(this.func_174877_v());
        this.flattenLists();
        this.inventorySlots = this.sortSlotRecords(this.invSlotList, true);
        this.drawerSlots = this.sortSlotRecords(this.drawerSlotList, false);
        this.rebuildPrimaryLookup(this.invPrimaryLookup, this.invSlotList, true);
        this.rebuildPrimaryLookup(this.drawerPrimaryLookup, this.drawerSlotList, false);
        if (!(preCount == this.inventorySlots.length || preCount != 0 && this.inventorySlots.length != 0 || this.field_145850_b.field_72995_K)) {
            this.func_70296_d();
        }
    }

    private void indexSlotRecords(List<SlotRecord> records, boolean invBased) {
        int n = records.size();
        for (int i = 0; i < n; ++i) {
            SlotRecord record = records.get(i);
            if (record == null) continue;
            record.index = i;
            record.priority = this.getSlotPriority(record, invBased);
        }
    }

    private int[] sortSlotRecords(List<SlotRecord> records, boolean invBased) {
        this.indexSlotRecords(records, invBased);
        ArrayList<SlotRecord> copied = new ArrayList<SlotRecord>(records);
        Collections.sort(copied, this.slotRecordComparator);
        int[] slotMap = new int[copied.size()];
        for (int i = 0; i < slotMap.length; ++i) {
            slotMap[i] = ((SlotRecord)copied.get((int)i)).index;
        }
        return slotMap;
    }

    private void rebuildPrimaryLookup(ItemMetaListRegistry<SlotRecord> lookup, List<SlotRecord> records, boolean invBased) {
        lookup.clear();
        for (SlotRecord record : records) {
            IDrawer drawer;
            int drawerSlot;
            IDrawerGroup group = this.getGroupForCoord(record.coord);
            if (group == null || !group.isDrawerEnabled(drawerSlot = invBased ? group.getDrawerInventory().getDrawerSlot(record.slot) : record.slot) || (drawer = group.getDrawer(drawerSlot)).isEmpty()) continue;
            ItemStack item = drawer.getStoredItemPrototype();
            lookup.register(item.func_77973_b(), item.func_77952_i(), record);
        }
    }

    private boolean containsNullEntries(List<SlotRecord> list) {
        int nullCount = 0;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (list.get(i) != null) continue;
            ++nullCount;
        }
        return nullCount > 0;
    }

    private void flattenLists() {
        SlotRecord record;
        int i;
        int n;
        if (this.containsNullEntries(this.invSlotList)) {
            ArrayList<SlotRecord> newInvSlotList = new ArrayList<SlotRecord>();
            n = this.invSlotList.size();
            for (i = 0; i < n; ++i) {
                record = this.invSlotList.get(i);
                if (record == null) continue;
                newInvSlotList.add(record);
            }
            this.invSlotList = newInvSlotList;
        }
        if (this.containsNullEntries(this.drawerSlotList)) {
            ArrayList<SlotRecord> newDrawerSlotList = new ArrayList<SlotRecord>();
            n = this.drawerSlotList.size();
            for (i = 0; i < n; ++i) {
                record = this.drawerSlotList.get(i);
                if (record == null) continue;
                newDrawerSlotList.add(record);
            }
            this.drawerSlotList = newDrawerSlotList;
        }
    }

    private void clearRecordInfo(BlockPos coord, StorageRecord record) {
        SlotRecord slotRecord;
        int i;
        record.clear();
        for (i = 0; i < this.invSlotList.size(); ++i) {
            slotRecord = this.invSlotList.get(i);
            if (slotRecord == null || !coord.equals((Object)slotRecord.coord)) continue;
            this.invSlotList.set(i, null);
        }
        for (i = 0; i < this.drawerSlotList.size(); ++i) {
            slotRecord = this.drawerSlotList.get(i);
            if (slotRecord == null || !coord.equals((Object)slotRecord.coord)) continue;
            this.drawerSlotList.set(i, null);
        }
    }

    private void updateRecordInfo(BlockPos coord, StorageRecord record, TileEntity te) {
        if (te == null) {
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            return;
        }
        if (te instanceof TileEntityController) {
            if (record.storage == null && record.invStorageSize > 0) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = null;
            record.invStorageSize = 1;
            this.invSlotList.add(new SlotRecord(null, 0));
        } else if (te instanceof TileEntitySlave) {
            if (record.storage == null && record.invStorageSize == 0 && ((TileEntitySlave)te).getController() == this) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = null;
            record.invStorageSize = 0;
            ((TileEntitySlave)te).bindController(this.func_174877_v());
        } else if (te instanceof IDrawerGroup) {
            int i;
            IDrawerInventory inventory;
            IDrawerGroup group = (IDrawerGroup)te;
            if (record.storage == group) {
                return;
            }
            if (record.storage != null && record.storage != group) {
                this.clearRecordInfo(coord, record);
            }
            if ((inventory = group.getDrawerInventory()) == null) {
                return;
            }
            record.storage = group;
            record.invStorageSize = inventory.func_70302_i_();
            record.drawerStorageSize = group.getDrawerCount();
            int n = record.invStorageSize;
            for (i = 0; i < n; ++i) {
                this.invSlotList.add(new SlotRecord(coord, i));
            }
            n = record.drawerStorageSize;
            for (i = 0; i < n; ++i) {
                this.drawerSlotList.add(new SlotRecord(coord, i));
            }
            this.drawerSize += record.drawerStorageSize;
        } else if (record.storage != null) {
            this.clearRecordInfo(coord, record);
        }
    }

    private void populateNodes(BlockPos root) {
        this.searchQueue.clear();
        this.searchQueue.add(root);
        this.searchDiscovered.clear();
        this.searchDiscovered.add(root);
        while (!this.searchQueue.isEmpty()) {
            BlockPos[] neighbors;
            Block block;
            BlockPos coord = this.searchQueue.remove();
            int depth = Math.max(Math.max(Math.abs(coord.func_177958_n() - root.func_177958_n()), Math.abs(coord.func_177956_o() - root.func_177956_o())), Math.abs(coord.func_177952_p() - root.func_177952_p()));
            if (depth > this.range || !((block = this.field_145850_b.func_180495_p(coord).func_177230_c()) instanceof INetworked)) continue;
            StorageRecord record = this.storage.get(coord);
            if (record == null) {
                record = new StorageRecord();
                this.storage.put(coord, record);
            }
            if (block instanceof BlockSlave) {
                ((BlockSlave)block).getTileEntitySafe(this.field_145850_b, coord);
            }
            this.updateRecordInfo(coord, record, this.field_145850_b.func_175625_s(coord));
            record.mark = true;
            record.distance = depth;
            for (BlockPos n : neighbors = new BlockPos[]{coord.func_177976_e(), coord.func_177974_f(), coord.func_177968_d(), coord.func_177978_c(), coord.func_177984_a(), coord.func_177977_b()}) {
                if (this.searchDiscovered.contains(n)) continue;
                this.searchQueue.add(n);
                this.searchDiscovered.add(n);
            }
        }
    }

    private IDrawerGroup getGroupForInvSlot(int invSlot) {
        if (invSlot >= this.invSlotList.size()) {
            return null;
        }
        SlotRecord record = this.invSlotList.get(invSlot);
        if (record == null) {
            return null;
        }
        return this.getGroupForCoord(record.coord);
    }

    private IDrawerGroup getGroupForDrawerSlot(int drawerSlot) {
        if (drawerSlot >= this.drawerSlotList.size()) {
            return null;
        }
        SlotRecord record = this.drawerSlotList.get(drawerSlot);
        if (record == null) {
            return null;
        }
        return this.getGroupForCoord(record.coord);
    }

    private IDrawerGroup getGroupForCoord(BlockPos coord) {
        TileEntity tile;
        if (coord == null || !this.storage.containsKey(coord)) {
            return null;
        }
        StorageRecord record = this.storage.get(coord);
        if (record == null) {
            return null;
        }
        if (record.storage instanceof TileEntity && (tile = (TileEntity)record.storage).func_145837_r() && tile != this.field_145850_b.func_175625_s(coord)) {
            this.storage.remove(coord);
            return null;
        }
        return record.storage;
    }

    private int getLocalInvSlot(int invSlot) {
        if (invSlot >= this.invSlotList.size()) {
            return 0;
        }
        SlotRecord record = this.invSlotList.get(invSlot);
        if (record == null) {
            return 0;
        }
        return record.slot;
    }

    private int getLocalDrawerSlot(int drawerSlot) {
        if (drawerSlot >= this.drawerSlotList.size()) {
            return 0;
        }
        SlotRecord record = this.drawerSlotList.get(drawerSlot);
        if (record == null) {
            return 0;
        }
        return record.slot;
    }

    private IDrawerInventory getDrawerInventory(int invSlot) {
        IDrawerGroup group = this.getGroupForInvSlot(invSlot);
        if (group == null) {
            return null;
        }
        return group.getDrawerInventory();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = tag.func_74779_i("CustomName");
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.updateCache();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.customName);
        }
        return tag;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 5, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        if (this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    @Override
    public IDrawerInventory getDrawerInventory() {
        return null;
    }

    @Override
    public int getDrawerCount() {
        return this.drawerSlotList.size();
    }

    @Override
    public IDrawer getDrawer(int slot) {
        IDrawerGroup group = this.getGroupForDrawerSlot(slot);
        if (group == null) {
            return null;
        }
        return group.getDrawer(this.getLocalDrawerSlot(slot));
    }

    @Override
    public boolean isDrawerEnabled(int slot) {
        IDrawerGroup group = this.getGroupForDrawerSlot(slot);
        if (group == null) {
            return false;
        }
        return group.isDrawerEnabled(this.getLocalDrawerSlot(slot));
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        return this.drawerSlots;
    }

    public void func_70296_d() {
        for (StorageRecord record : this.storage.values()) {
            IDrawerGroup group = record.storage;
            if (group == null || group.getDrawerInventory() == null) continue;
            group.markDirtyIfNeeded();
        }
        super.func_70296_d();
    }

    @Override
    public boolean markDirtyIfNeeded() {
        boolean synced = false;
        for (StorageRecord record : this.storage.values()) {
            IDrawerGroup group = record.storage;
            if (group == null || group.getDrawerInventory() == null) continue;
            synced |= group.markDirtyIfNeeded();
        }
        if (synced) {
            super.func_70296_d();
        }
        return synced;
    }

    public int[] func_180463_a(EnumFacing side) {
        for (int aside : this.autoSides) {
            if (side.ordinal() != aside) continue;
            return this.inventorySlots;
        }
        return emptySlots;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return false;
        }
        if (slot >= this.invSlotList.size()) {
            return false;
        }
        SlotRecord record = this.invSlotList.get(slot);
        List<SlotRecord> primaryRecords = this.invPrimaryLookup.getEntries(stack.func_77973_b(), stack.func_77952_i());
        if (primaryRecords != null && !primaryRecords.contains(record)) {
            for (SlotRecord candidate : primaryRecords) {
                IDrawerInventory candidateInventory;
                IDrawerGroup candidateGroup = this.getGroupForCoord(candidate.coord);
                if (candidateGroup == null || !(candidateInventory = candidateGroup.getDrawerInventory()).canInsertItem(candidate.slot, stack)) continue;
                return false;
            }
        }
        return inventory.canInsertItem(this.getLocalInvSlot(slot), stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return false;
        }
        return inventory.canExtractItem(this.getLocalInvSlot(slot), stack);
    }

    public int func_70302_i_() {
        return this.inventorySlots.length;
    }

    public ItemStack func_70301_a(int slot) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return null;
        }
        return inventory.func_70301_a(this.getLocalInvSlot(slot));
    }

    public ItemStack func_70298_a(int slot, int count) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return null;
        }
        return inventory.func_70298_a(this.getLocalInvSlot(slot), count);
    }

    public ItemStack func_70304_b(int slot) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return null;
        }
        return inventory.func_70304_b(this.getLocalInvSlot(slot));
    }

    public void func_70299_a(int slot, ItemStack stack) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return;
        }
        inventory.func_70299_a(this.getLocalInvSlot(slot), stack);
        inventory.func_70296_d();
    }

    public void setInventoryName(String name) {
        this.customName = name;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "storageDrawers.container.controller";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return false;
        }
        if (slot >= this.invSlotList.size()) {
            return false;
        }
        SlotRecord record = this.invSlotList.get(slot);
        List<SlotRecord> primaryRecords = this.invPrimaryLookup.getEntries(stack.func_77973_b(), stack.func_77952_i());
        if (primaryRecords != null && !primaryRecords.contains(record)) {
            for (SlotRecord candidate : primaryRecords) {
                IDrawerInventory candidateInventory;
                IDrawerGroup candidateGroup = this.getGroupForCoord(candidate.coord);
                if (candidateGroup == null || !(candidateInventory = candidateGroup.getDrawerInventory()).func_94041_b(candidate.slot, stack)) continue;
                return false;
            }
        }
        return inventory.func_94041_b(this.getLocalInvSlot(slot), stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public Iterable<Integer> enumerateDrawersForInsertion(ItemStack stack, boolean strict) {
        return new DrawerStackIterator(stack, strict, true);
    }

    @Override
    public Iterable<Integer> enumerateDrawersForExtraction(ItemStack stack, boolean strict) {
        return new DrawerStackIterator(stack, strict, false);
    }

    private class DrawerStackIterator
    implements Iterable<Integer> {
        private ItemStack stack;
        private boolean strict;
        private boolean insert;

        public DrawerStackIterator(ItemStack stack, boolean strict, boolean insert) {
            this.stack = stack;
            this.strict = strict;
            this.insert = insert;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                List<SlotRecord> primaryRecords;
                Iterator<SlotRecord> iter1;
                int index2;
                Integer nextSlot;
                {
                    this.primaryRecords = TileEntityController.this.drawerPrimaryLookup.getEntries(DrawerStackIterator.this.stack.func_77973_b(), DrawerStackIterator.this.stack.func_77952_i());
                    this.nextSlot = null;
                }

                @Override
                public boolean hasNext() {
                    if (this.nextSlot == null) {
                        this.advance();
                    }
                    return this.nextSlot != null;
                }

                @Override
                public Integer next() {
                    if (this.nextSlot == null) {
                        this.advance();
                    }
                    Integer slot = this.nextSlot;
                    this.nextSlot = null;
                    return slot;
                }

                private void advance() {
                    if (this.iter1 == null && this.primaryRecords != null && this.primaryRecords.size() > 0) {
                        this.iter1 = this.primaryRecords.iterator();
                    }
                    if (this.iter1 != null) {
                        while (this.iter1.hasNext()) {
                            int slot;
                            SlotRecord candidate = this.iter1.next();
                            IDrawerGroup candidateGroup = TileEntityController.this.getGroupForCoord(candidate.coord);
                            if (candidateGroup == null) continue;
                            IDrawer drawer = candidateGroup.getDrawer(candidate.slot);
                            if (DrawerStackIterator.this.insert) {
                                boolean voiding;
                                boolean bl = voiding = drawer instanceof IVoidable ? ((IVoidable)((Object)drawer)).isVoid() : false;
                                if (!drawer.canItemBeStored(DrawerStackIterator.this.stack) || !drawer.isEmpty() && drawer.getRemainingCapacity() <= 0 && !voiding) {
                                    continue;
                                }
                            } else if (!drawer.canItemBeExtracted(DrawerStackIterator.this.stack) || drawer.getStoredItemCount() <= 0) continue;
                            if ((slot = TileEntityController.this.drawerSlotList.indexOf(candidate)) <= -1) continue;
                            this.nextSlot = slot;
                            return;
                        }
                    }
                    while (this.index2 < TileEntityController.this.drawerSlots.length) {
                        block12: {
                            int slot;
                            block14: {
                                IDrawer drawer;
                                block13: {
                                    boolean voiding;
                                    ItemStack proto;
                                    slot = TileEntityController.this.drawerSlots[this.index2];
                                    if (!TileEntityController.this.isDrawerEnabled(slot)) break block12;
                                    drawer = TileEntityController.this.getDrawer(slot);
                                    if (DrawerStackIterator.this.strict && (proto = drawer.getStoredItemPrototype()) != null && !proto.func_77969_a(DrawerStackIterator.this.stack)) break block12;
                                    if (!DrawerStackIterator.this.insert) break block13;
                                    boolean bl = voiding = drawer instanceof IVoidable ? ((IVoidable)((Object)drawer)).isVoid() : false;
                                    if (drawer.canItemBeStored(DrawerStackIterator.this.stack) && (drawer.isEmpty() || drawer.getRemainingCapacity() > 0 || voiding)) break block14;
                                    break block12;
                                }
                                if (!drawer.canItemBeExtracted(DrawerStackIterator.this.stack) || drawer.getStoredItemCount() <= 0) break block12;
                            }
                            SlotRecord record = (SlotRecord)TileEntityController.this.drawerSlotList.get(slot);
                            if (this.primaryRecords == null || !this.primaryRecords.contains(record)) {
                                this.nextSlot = slot;
                                ++this.index2;
                                return;
                            }
                        }
                        ++this.index2;
                    }
                }
            };
        }
    }

    private static class SlotRecord {
        public BlockPos coord;
        public int slot;
        public int index;
        public int priority;

        public SlotRecord(BlockPos coord, int slot) {
            this.coord = coord;
            this.slot = slot;
        }
    }

    private static class StorageRecord {
        public IDrawerGroup storage;
        public boolean mark;
        public int invStorageSize;
        public int drawerStorageSize;
        public int distance = Integer.MAX_VALUE;

        private StorageRecord() {
        }

        public void clear() {
            this.storage = null;
            this.mark = false;
            this.invStorageSize = 0;
            this.drawerStorageSize = 0;
            this.distance = Integer.MAX_VALUE;
        }
    }
}

