/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.chameleon.model.ProxyBuilderModel;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerDecoratorModel;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerSealedModel;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;

public final class CompDrawerModel {
    private static final ItemHandler itemHandler = new ItemHandler();

    private static class ItemHandler
    extends ItemOverrideList {
        public ItemHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel parent, ItemStack stack, World world, EntityLivingBase entity) {
            if (stack == null) {
                return parent;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_150297_b("tile", 10)) {
                return parent;
            }
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            IBlockState state = block.func_176203_a(stack.func_77960_j());
            return new DrawerSealedModel(parent, state, true);
        }
    }

    public static class Model
    extends ProxyBuilderModel {
        public Model(IBakedModel parent) {
            super(parent);
        }

        protected IBakedModel buildModel(IBlockState state, IBakedModel parent) {
            EnumCompDrawer drawer = (EnumCompDrawer)((Object)state.func_177229_b((IProperty)BlockCompDrawers.SLOTS));
            EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING);
            if (!(state instanceof IExtendedBlockState)) {
                return parent;
            }
            IExtendedBlockState xstate = (IExtendedBlockState)state;
            TileEntityDrawers tile = (TileEntityDrawers)xstate.getValue(BlockDrawers.TILE);
            if (!DrawerDecoratorModel.shouldHandleState(tile)) {
                return parent;
            }
            return new DrawerDecoratorModel(parent, xstate, drawer, dir, tile);
        }

        public ItemOverrideList func_188617_f() {
            return itemHandler;
        }
    }

    public static class Register
    extends DefaultRegister {
        public Register() {
            super((Block)ModBlocks.compDrawers);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (EnumCompDrawer drawer : EnumCompDrawer.values()) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    states.add(ModBlocks.compDrawers.func_176223_P().func_177226_a((IProperty)BlockCompDrawers.SLOTS, (Comparable)((Object)drawer)).func_177226_a((IProperty)BlockCompDrawers.FACING, (Comparable)dir));
                }
            }
            return states;
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new Model(existingModel);
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new Model(existingModel);
        }
    }
}

