/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model.component;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.geometry.Area2D;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.render.ChamRenderManager;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGeometry;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.dynamic.StatusModelData;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;

public class DrawerDecoratorModel
implements IBakedModel {
    public static final ResourceLocation iconLock = new ResourceLocation("StorageDrawers:blocks/indicator/lock_icon");
    public static final ResourceLocation iconClaim = new ResourceLocation("StorageDrawers:blocks/indicator/claim_icon");
    public static final ResourceLocation iconClaimLock = new ResourceLocation("StorageDrawers:blocks/indicator/claim_lock_icon");
    public static final ResourceLocation iconVoid = new ResourceLocation("StorageDrawers:blocks/indicator/void_icon");
    public static final ResourceLocation iconShroudCover = new ResourceLocation("StorageDrawers:blocks/drawers_oak_trim");
    private IBakedModel baseModel;
    private IExtendedBlockState blockState;
    private IDrawerGeometry drawer;
    private EnumFacing dir;
    private boolean shrouded;
    private boolean locked;
    private boolean owned;
    private boolean voiding;
    private boolean[] enabled;

    public DrawerDecoratorModel(IBakedModel baseModel, IExtendedBlockState blockState, IDrawerGeometry drawer, EnumFacing dir, TileEntityDrawers tile) {
        this.baseModel = baseModel;
        this.blockState = blockState;
        this.drawer = drawer;
        this.dir = dir;
        this.shrouded = tile.isShrouded();
        this.locked = tile.isLocked(LockAttribute.LOCK_POPULATED);
        this.owned = tile.getOwner() != null;
        this.voiding = tile.isVoid();
        this.enabled = new boolean[drawer.getDrawerCount()];
        for (int i = 0; i < this.enabled.length; ++i) {
            this.enabled[i] = !tile.getDrawer(i).isEmpty();
        }
    }

    public static boolean shouldHandleState(TileEntityDrawers tile) {
        return tile != null && (tile.isShrouded() || tile.isVoid() || tile.isLocked(LockAttribute.LOCK_POPULATED) || tile.getOwner() != null);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        ChamRender renderer = ChamRenderManager.instance.getRenderer(null);
        renderer.startBaking(DefaultVertexFormats.field_176599_b);
        if (this.shrouded) {
            this.buildShroudGeometry(renderer);
        }
        if (this.locked || this.owned) {
            this.buildLockGeometry(renderer);
        }
        if (this.voiding) {
            this.buildVoidGeometry(renderer);
        }
        renderer.stopBaking();
        List quads = renderer.takeBakedQuads(null);
        quads.addAll(this.baseModel.func_188616_a(state, side, rand));
        ChamRenderManager.instance.releaseRenderer(renderer);
        return quads;
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.baseModel.func_188617_f();
    }

    private void buildLockGeometry(ChamRender renderer) {
        TextureAtlasSprite lockIcon;
        double depth;
        double d = depth = this.drawer.isHalfDepth() ? 0.5 : 1.0;
        if (this.locked && this.owned) {
            lockIcon = Chameleon.instance.iconRegistry.getIcon(iconClaimLock);
        } else if (this.locked) {
            lockIcon = Chameleon.instance.iconRegistry.getIcon(iconLock);
        } else if (this.owned) {
            lockIcon = Chameleon.instance.iconRegistry.getIcon(iconClaim);
        } else {
            return;
        }
        renderer.setRenderBounds(0.46875, 0.9375, 0.0, 0.53125, 1.0, depth + 0.003);
        renderer.state.setRotateTransform(3, this.dir.func_176745_a());
        renderer.bakePartialFace(ChamRender.FACE_ZPOS, (IBlockState)this.blockState, lockIcon, 0.0, 0.0, 1.0, 1.0, false, 1.0f, 1.0f, 1.0f);
        renderer.state.clearRotateTransform();
    }

    private void buildVoidGeometry(ChamRender renderer) {
        double depth = this.drawer.isHalfDepth() ? 0.5 : 1.0;
        TextureAtlasSprite icon = Chameleon.instance.iconRegistry.getIcon(iconVoid);
        renderer.setRenderBounds(0.9375, 0.9375, 0.0, 1.0, 1.0, depth + 0.003);
        renderer.state.setRotateTransform(3, this.dir.func_176745_a());
        renderer.bakePartialFace(ChamRender.FACE_ZPOS, (IBlockState)this.blockState, icon, 0.0, 0.0, 1.0, 1.0, false, 1.0f, 1.0f, 1.0f);
        renderer.state.clearRotateTransform();
    }

    private void buildShroudGeometry(ChamRender renderer) {
        if (!(this.blockState.func_177230_c() instanceof BlockDrawers)) {
            return;
        }
        BlockDrawers block = (BlockDrawers)this.blockState.func_177230_c();
        StatusModelData data = block.getStatusInfo((IBlockState)this.blockState);
        int count = this.drawer.getDrawerCount();
        double depth = this.drawer.isHalfDepth() ? 0.5 : 1.0;
        double unit = 0.0625;
        double frontDepth = data.getFrontDepth() * unit;
        TextureAtlasSprite iconCover = Chameleon.instance.iconRegistry.getIcon(iconShroudCover);
        for (int i = 0; i < count; ++i) {
            if (!this.enabled[i]) continue;
            StatusModelData.Slot slot = data.getSlot(i);
            Area2D bounds = slot.getIconArea();
            renderer.setRenderBounds(bounds.getX() * unit, bounds.getY() * unit, 0.0, (bounds.getX() + bounds.getWidth()) * unit, (bounds.getY() + bounds.getHeight()) * unit, depth - frontDepth + 0.003);
            renderer.state.setRotateTransform(3, this.dir.func_176745_a());
            renderer.bakeFace(ChamRender.FACE_ZPOS, (IBlockState)this.blockState, iconCover, false, 1.0f, 1.0f, 1.0f);
            renderer.state.clearRotateTransform();
        }
    }
}

