/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IPriorityGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class DrawerItemHandler
implements IItemHandler {
    private IDrawerGroup group;

    public DrawerItemHandler(IDrawerGroup group) {
        this.group = group;
    }

    public int getSlots() {
        return this.group.getDrawerCount();
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.group instanceof IPriorityGroup) {
            int[] order = ((IPriorityGroup)((Object)this.group)).getAccessibleDrawerSlots();
            int n = slot = slot >= 0 && slot < order.length ? order[slot] : -1;
        }
        if (!this.group.isDrawerEnabled(slot)) {
            return null;
        }
        IDrawer drawer = this.group.getDrawer(slot);
        if (drawer.isEmpty()) {
            return null;
        }
        return drawer.getStoredItemCopy();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int insertCount;
        int remainder;
        int availableCount;
        if (this.group instanceof IPriorityGroup) {
            int[] order = ((IPriorityGroup)((Object)this.group)).getAccessibleDrawerSlots();
            int n = slot = slot >= 0 && slot < order.length ? order[slot] : -1;
        }
        if (!this.group.isDrawerEnabled(slot)) {
            return stack;
        }
        IDrawer drawer = this.group.getDrawer(slot);
        if (!drawer.canItemBeStored(stack)) {
            return stack;
        }
        int n = availableCount = drawer.isEmpty() ? drawer.getMaxCapacity(stack) : drawer.getRemainingCapacity();
        if (drawer instanceof IVoidable && ((IVoidable)((Object)drawer)).isVoid()) {
            availableCount = Integer.MAX_VALUE;
        }
        if ((remainder = stack.field_77994_a - (insertCount = Math.min(stack.field_77994_a, availableCount))) == stack.field_77994_a) {
            return stack;
        }
        if (!simulate) {
            if (drawer.isEmpty()) {
                drawer.setStoredItem(stack, insertCount);
            } else {
                drawer.setStoredItemCount(drawer.getStoredItemCount() + insertCount);
            }
        }
        if (remainder == 0) {
            return null;
        }
        ItemStack returnStack = stack.func_77946_l();
        returnStack.field_77994_a = remainder;
        return returnStack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.group instanceof IPriorityGroup) {
            int[] order = ((IPriorityGroup)((Object)this.group)).getAccessibleDrawerSlots();
            int n = slot = slot >= 0 && slot < order.length ? order[slot] : -1;
        }
        if (!this.group.isDrawerEnabled(slot)) {
            return null;
        }
        IDrawer drawer = this.group.getDrawer(slot);
        if (drawer.isEmpty() || drawer.getStoredItemCount() == 0) {
            return null;
        }
        ItemStack returnStack = drawer.getStoredItemCopy();
        returnStack.field_77994_a = Math.min(returnStack.field_77994_a, amount);
        returnStack.field_77994_a = Math.min(returnStack.field_77994_a, returnStack.func_77976_d());
        if (!simulate) {
            drawer.setStoredItemCount(drawer.getStoredItemCount() - returnStack.field_77994_a);
        }
        return returnStack;
    }
}

