/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.network;

import com.jaquadro.minecraft.storagedrawers.block.IBlockDestroyHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class BlockDestroyMessage
implements IMessage {
    private int x;
    private int y;
    private int z;
    private boolean failed;

    public BlockDestroyMessage() {
    }

    public BlockDestroyMessage(BlockPos pos) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.x = buf.readInt();
            this.y = buf.readShort();
            this.z = buf.readInt();
        }
        catch (IndexOutOfBoundsException e) {
            this.failed = true;
            FMLLog.log((String)"StorageDrawers", (Level)Level.ERROR, (Throwable)e, (String)"BlockDestroyMessage: Unexpected end of packet.\nMessage: %s", (Object[])new Object[]{ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex())});
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeShort(this.y);
        buf.writeInt(this.z);
    }

    public static class Handler
    implements IMessageHandler<BlockDestroyMessage, IMessage> {
        public IMessage onMessage(BlockDestroyMessage message, MessageContext ctx) {
            BlockPos pos;
            Block block;
            World world;
            if (!message.failed && ctx.side == Side.SERVER && (world = ctx.getServerHandler().field_147369_b.func_130014_f_()) != null && (block = world.func_180495_p(pos = new BlockPos(message.x, message.y, message.z)).func_177230_c()) instanceof IBlockDestroyHandler) {
                ((IBlockDestroyHandler)block).onBlockDestroyed(world, pos);
            }
            return null;
        }
    }
}

