/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.ChamTileEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.capabilities.BasicDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.network.MessageHandler;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class TileEntityDrawers
extends ChamTileEntity
implements IDrawerGroup {
    public static final ModelProperty<IDrawerAttributes> ATTRIBUTES = new ModelProperty();
    private UpgradeData upgradeData = new DrawerUpgradeData();
    private IDrawerAttributesModifiable drawerAttributes;
    private long lastClickTime;
    private UUID lastClickUUID;
    @CapabilityInject(value=IDrawerGroup.class)
    public static Capability<IDrawerGroup> DRAWER_GROUP_CAPABILITY = null;
    private final LazyOptional<?> capabilityGroup = LazyOptional.of(this::getGroup);

    protected TileEntityDrawers(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        this.drawerAttributes = new DrawerAttributes();
        this.upgradeData.setDrawerAttributes(this.drawerAttributes);
        this.injectPortableData(this.upgradeData);
    }

    public abstract IDrawerGroup getGroup();

    public IDrawerAttributes getDrawerAttributes() {
        return this.drawerAttributes;
    }

    public UpgradeData upgrades() {
        return this.upgradeData;
    }

    @Override
    public boolean isGroupValid() {
        return !this.func_145837_r();
    }

    public int getDrawerCapacity() {
        Block block = this.func_195044_w().func_177230_c();
        if (!(block instanceof BlockDrawers)) {
            return 0;
        }
        return ((BlockDrawers)block).getStorageUnits();
    }

    public int getEffectiveDrawerCapacity() {
        if (this.upgradeData.hasOneStackUpgrade()) {
            return 1;
        }
        return this.getDrawerCapacity() * (Integer)CommonConfig.GENERAL.baseStackStorage.get();
    }

    protected boolean emptySlotCanBeCleared(int slot) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        return !drawer.isEmpty() && drawer.getStoredItemCount() == 0;
    }

    protected void onAttributeChanged() {
        this.requestModelDataUpdate();
    }

    public boolean isRedstone() {
        return this.upgradeData.getRedstoneType() != null;
    }

    public int getRedstoneLevel() {
        EnumUpgradeRedstone type = this.upgradeData.getRedstoneType();
        if (type == null) {
            return 0;
        }
        switch (type) {
            case COMBINED: {
                return this.getCombinedRedstoneLevel();
            }
            case MAX: {
                return this.getMaxRedstoneLevel();
            }
            case MIN: {
                return this.getMinRedstoneLevel();
            }
        }
        return 0;
    }

    protected int getCombinedRedstoneLevel() {
        int active = 0;
        float fillRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            if (drawer.getMaxCapacity() > 0) {
                fillRatio += (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity();
            }
            ++active;
        }
        if (active == 0) {
            return 0;
        }
        if (fillRatio == (float)active) {
            return 15;
        }
        return (int)Math.ceil(fillRatio / (float)active * 14.0f);
    }

    protected int getMinRedstoneLevel() {
        float minRatio = 2.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            minRatio = drawer.getMaxCapacity() > 0 ? Math.min(minRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity()) : 0.0f;
        }
        if (minRatio > 1.0f) {
            return 0;
        }
        if (minRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(minRatio * 14.0f);
    }

    protected int getMaxRedstoneLevel() {
        float maxRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled() || drawer.getMaxCapacity() <= 0) continue;
            maxRatio = Math.max(maxRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity());
        }
        if (maxRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(maxRatio * 14.0f);
    }

    @Nonnull
    public ItemStack takeItemsFromSlot(int slot, int count) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled() || drawer.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = drawer.getStoredItemPrototype().func_77946_l();
        stack.func_190920_e(Math.min(count, drawer.getStoredItemCount()));
        drawer.setStoredItemCount(drawer.getStoredItemCount() - stack.func_190916_E());
        if (this.isRedstone() && this.func_145831_w() != null) {
            this.func_145831_w().func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
            this.func_145831_w().func_195593_d(this.func_174877_v().func_177977_b(), this.func_195044_w().func_177230_c());
        }
        return stack;
    }

    public int putItemsIntoSlot(int slot, @Nonnull ItemStack stack, int count) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        if (drawer.isEmpty()) {
            drawer = drawer.setStoredItem(stack);
        }
        if (!drawer.canItemBeStored(stack)) {
            return 0;
        }
        int countAdded = Math.min(count, stack.func_190916_E());
        if (!this.drawerAttributes.isVoid()) {
            countAdded = Math.min(countAdded, drawer.getRemainingCapacity());
        }
        drawer.setStoredItemCount(drawer.getStoredItemCount() + countAdded);
        stack.func_190918_g(countAdded);
        return countAdded;
    }

    public int interactPutCurrentItemIntoSlot(int slot, PlayerEntity player) {
        IDrawer drawer = this.getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        int count = 0;
        ItemStack playerStack = player.field_71071_by.func_70448_g();
        if (!playerStack.func_190926_b()) {
            count = this.putItemsIntoSlot(slot, playerStack, playerStack.func_190916_E());
        }
        return count;
    }

    public int interactPutCurrentInventoryIntoSlot(int slot, PlayerEntity player) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        int count = 0;
        if (!drawer.isEmpty()) {
            int n = player.field_71071_by.func_70302_i_();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.field_71071_by.func_70301_a(i);
                if (subStack.func_190926_b()) continue;
                int subCount = this.putItemsIntoSlot(slot, subStack, subStack.func_190916_E());
                if (subCount > 0 && subStack.func_190916_E() == 0) {
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                }
                count += subCount;
            }
        }
        if (count > 0) {
            StorageDrawers.proxy.updatePlayerInventory(player);
        }
        return count;
    }

    public int interactPutItemsIntoSlot(int slot, PlayerEntity player) {
        int count = this.func_145831_w().func_82737_E() - this.lastClickTime < 10L && player.func_110124_au().equals(this.lastClickUUID) ? this.interactPutCurrentInventoryIntoSlot(slot, player) : this.interactPutCurrentItemIntoSlot(slot, player);
        this.lastClickTime = this.func_145831_w().func_82737_E();
        this.lastClickUUID = player.func_110124_au();
        return count;
    }

    @Override
    public void readPortable(CompoundNBT tag) {
        super.readPortable(tag);
        if (tag.func_74764_b("Lock")) {
            EnumSet<LockAttribute> attrs = LockAttribute.getEnumSet(tag.func_74771_c("Lock"));
            if (attrs != null) {
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, attrs.contains((Object)LockAttribute.LOCK_EMPTY));
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, attrs.contains((Object)LockAttribute.LOCK_POPULATED));
            }
        } else {
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, false);
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, false);
        }
        if (tag.func_74764_b("Shr")) {
            this.drawerAttributes.setIsConcealed(tag.func_74767_n("Shr"));
        } else {
            this.drawerAttributes.setIsConcealed(false);
        }
        if (tag.func_74764_b("Qua")) {
            this.drawerAttributes.setIsShowingQuantity(tag.func_74767_n("Qua"));
        } else {
            this.drawerAttributes.setIsShowingQuantity(false);
        }
    }

    @Override
    public CompoundNBT writePortable(CompoundNBT tag) {
        tag = super.writePortable(tag);
        EnumSet<LockAttribute> attrs = EnumSet.noneOf(LockAttribute.class);
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_EMPTY)) {
            attrs.add(LockAttribute.LOCK_EMPTY);
        }
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            attrs.add(LockAttribute.LOCK_POPULATED);
        }
        if (!attrs.isEmpty()) {
            tag.func_74774_a("Lock", (byte)LockAttribute.getBitfield(attrs));
        }
        if (this.drawerAttributes.isConcealed()) {
            tag.func_74757_a("Shr", true);
        }
        if (this.drawerAttributes.isShowingQuantity()) {
            tag.func_74757_a("Qua", true);
        }
        return tag;
    }

    public void func_70296_d() {
        if (this.isRedstone() && this.func_145831_w() != null) {
            this.func_145831_w().func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
            this.func_145831_w().func_195593_d(this.func_174877_v().func_177977_b(), this.func_195044_w().func_177230_c());
        }
        super.func_70296_d();
    }

    protected void syncClientCount(int slot, int count) {
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            return;
        }
        PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 500.0, this.func_145831_w().field_73011_w.func_186058_p());
        MessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> point), (Object)new CountUpdateMessage(this.func_174877_v(), slot, count));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientUpdateCount(int slot, int count) {
        if (!this.func_145831_w().field_72995_K) {
            return;
        }
        Minecraft.func_71410_x().func_212871_a_(() -> this.clientUpdateCountAsync(slot, count));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientUpdateCountAsync(int slot, int count) {
        IDrawer drawer = this.getDrawer(slot);
        if (drawer.isEnabled() && drawer.getStoredItemCount() != count) {
            drawer.setStoredItemCount(count);
        }
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    @Deprecated
    public int getDrawerCount() {
        return this.getGroup().getDrawerCount();
    }

    @Override
    @Nonnull
    @Deprecated
    public IDrawer getDrawer(int slot) {
        return this.getGroup().getDrawer(slot);
    }

    @Override
    @Nonnull
    @Deprecated
    public int[] getAccessibleDrawerSlots() {
        return this.getGroup().getAccessibleDrawerSlots();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        IDrawerGroup group = this.getGroup();
        if (capability == DRAWER_GROUP_CAPABILITY) {
            return this.capabilityGroup.cast();
        }
        LazyOptional<T> cap = this.getGroup().getCapability(capability, facing);
        if (cap.isPresent()) {
            return cap;
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ATTRIBUTES, (Object)this.drawerAttributes).build();
    }

    private void refreshModelData() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            Minecraft.func_71410_x().field_71438_f.func_147585_a(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        });
    }

    private class DrawerUpgradeData
    extends UpgradeData {
        DrawerUpgradeData() {
            super(7);
        }

        @Override
        public boolean canAddUpgrade(@Nonnull ItemStack upgrade) {
            int lostStackCapacity;
            if (!super.canAddUpgrade(upgrade)) {
                return false;
            }
            return upgrade.func_77973_b() != ModItems.ONE_STACK_UPGRADE || this.stackCapacityCheck(lostStackCapacity = TileEntityDrawers.this.upgradeData.getStorageMultiplier() * (TileEntityDrawers.this.getEffectiveDrawerCapacity() - 1));
        }

        @Override
        public boolean canRemoveUpgrade(int slot) {
            if (!super.canRemoveUpgrade(slot)) {
                return false;
            }
            ItemStack upgrade = this.getUpgrade(slot);
            if (upgrade.func_77973_b() instanceof ItemUpgradeStorage) {
                int addedStackCapacity;
                int storageLevel = ((ItemUpgradeStorage)upgrade.func_77973_b()).level.getLevel();
                int storageMult = CommonConfig.UPGRADES.getLevelMult(storageLevel);
                int effectiveStorageMult = TileEntityDrawers.this.upgradeData.getStorageMultiplier();
                if (effectiveStorageMult == storageMult) {
                    --storageMult;
                }
                if (!this.stackCapacityCheck(addedStackCapacity = storageMult * TileEntityDrawers.this.getEffectiveDrawerCapacity())) {
                    return false;
                }
            }
            return true;
        }

        @Override
        protected void onUpgradeChanged(ItemStack oldUpgrade, ItemStack newUpgrade) {
            if (TileEntityDrawers.this.func_145831_w() != null && !TileEntityDrawers.this.func_145831_w().field_72995_K) {
                TileEntityDrawers.this.func_70296_d();
                TileEntityDrawers.this.markBlockForUpdate();
            }
        }

        private boolean stackCapacityCheck(int stackCapacity) {
            for (int i = 0; i < TileEntityDrawers.this.getDrawerCount(); ++i) {
                IDrawer drawer = TileEntityDrawers.this.getDrawer(i);
                if (!drawer.isEnabled() || drawer.isEmpty()) continue;
                int addedItemCapacity = stackCapacity * drawer.getStoredItemStackSize();
                if (drawer.getMaxCapacity() - addedItemCapacity >= drawer.getStoredItemCount()) continue;
                return false;
            }
            return true;
        }
    }

    private class DrawerAttributes
    extends BasicDrawerAttributes {
        private DrawerAttributes() {
        }

        @Override
        protected void onAttributeChanged() {
            if (!TileEntityDrawers.this.drawerAttributes.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                for (int slot = 0; slot < TileEntityDrawers.this.getGroup().getDrawerCount(); ++slot) {
                    if (!TileEntityDrawers.this.emptySlotCanBeCleared(slot)) continue;
                    IDrawer drawer = TileEntityDrawers.this.getGroup().getDrawer(slot);
                    drawer.setStoredItem(ItemStack.field_190927_a);
                }
            }
            TileEntityDrawers.this.onAttributeChanged();
            if (TileEntityDrawers.this.func_145831_w() != null && !TileEntityDrawers.this.func_145831_w().field_72995_K) {
                TileEntityDrawers.this.func_70296_d();
                TileEntityDrawers.this.markBlockForUpdate();
            }
        }
    }
}

