/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.TileDataShim;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.extensions.IForgeTileEntity;

public class ChamTileEntity
extends TileEntity
implements IForgeTileEntity {
    private CompoundNBT failureSnapshot;
    private List<TileDataShim> fixedShims;
    private List<TileDataShim> portableShims;

    public ChamTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public boolean hasDataPacket() {
        return true;
    }

    public boolean dataPacketRequiresRenderUpdate() {
        return false;
    }

    public void injectData(TileDataShim shim) {
        if (this.fixedShims == null) {
            this.fixedShims = new ArrayList<TileDataShim>();
        }
        this.fixedShims.add(shim);
    }

    public void injectPortableData(TileDataShim shim) {
        if (this.portableShims == null) {
            this.portableShims = new ArrayList<TileDataShim>();
        }
        this.portableShims.add(shim);
    }

    public final void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.failureSnapshot = null;
        try {
            this.readFixed(tag);
            this.readPortable(tag);
        }
        catch (Throwable t) {
            this.trapLoadFailure(t, tag);
        }
    }

    public final void read(CompoundNBT tag) {
        this.func_230337_a_(null, tag);
    }

    public final CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.failureSnapshot != null) {
            this.restoreLoadFailure(tag);
            return tag;
        }
        try {
            tag = this.writeFixed(tag);
            tag = this.writePortable(tag);
        }
        catch (Throwable t) {
            StorageDrawers.log.error("Tile Save Failure.", t);
        }
        return tag;
    }

    public void readPortable(CompoundNBT tag) {
        if (this.portableShims != null) {
            for (TileDataShim shim : this.portableShims) {
                shim.read(tag);
            }
        }
    }

    public CompoundNBT writePortable(CompoundNBT tag) {
        if (this.portableShims != null) {
            for (TileDataShim shim : this.portableShims) {
                tag = shim.write(tag);
            }
        }
        return tag;
    }

    protected void readFixed(CompoundNBT tag) {
        if (this.fixedShims != null) {
            for (TileDataShim shim : this.fixedShims) {
                shim.read(tag);
            }
        }
    }

    protected CompoundNBT writeFixed(CompoundNBT tag) {
        if (this.fixedShims != null) {
            for (TileDataShim shim : this.fixedShims) {
                tag = shim.write(tag);
            }
        }
        return tag;
    }

    private void trapLoadFailure(Throwable t, CompoundNBT tag) {
        this.failureSnapshot = tag.func_74737_b();
        StorageDrawers.log.error("Tile Load Failure.", t);
    }

    private void restoreLoadFailure(CompoundNBT tag) {
        for (String key : this.failureSnapshot.func_150296_c()) {
            if (tag.func_74764_b(key)) continue;
            tag.func_218657_a(key, this.failureSnapshot.func_74781_a(key).func_74737_b());
        }
    }

    protected boolean loadDidFail() {
        return this.failureSnapshot != null;
    }

    public final CompoundNBT func_189517_E_() {
        CompoundNBT tag = new CompoundNBT();
        this.func_189515_b(tag);
        return tag;
    }

    public final SUpdateTileEntityPacket func_189518_D_() {
        return this.hasDataPacket() ? new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_()) : null;
    }

    public final void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (pkt != null && pkt.func_148857_g() != null) {
            this.read(pkt.func_148857_g());
        }
        if (this.dataPacketRequiresRenderUpdate() && this.func_145831_w().field_72995_K) {
            BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public void markBlockForUpdate() {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            BlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public void markBlockForUpdateClient() {
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            BlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public void markBlockForRenderUpdate() {
        if (this.func_145831_w() == null) {
            return;
        }
        BlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 2);
    }
}

