/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntitySlave;
import com.jaquadro.minecraft.storagedrawers.client.renderer.TileEntityDrawersRenderer;
import com.jaquadro.minecraft.storagedrawers.core.ModItemGroup;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="storagedrawers")
public class ModBlocks {
    public static final BlockDrawers OAK_FULL_DRAWERS_1 = null;
    public static final BlockDrawers OAK_FULL_DRAWERS_2 = null;
    public static final BlockDrawers OAK_FULL_DRAWERS_4 = null;
    public static final BlockDrawers OAK_HALF_DRAWERS_1 = null;
    public static final BlockDrawers OAK_HALF_DRAWERS_2 = null;
    public static final BlockDrawers OAK_HALF_DRAWERS_4 = null;
    public static final BlockDrawers SPRUCE_FULL_DRAWERS_1 = null;
    public static final BlockDrawers SPRUCE_FULL_DRAWERS_2 = null;
    public static final BlockDrawers SPRUCE_FULL_DRAWERS_4 = null;
    public static final BlockDrawers SPRUCE_HALF_DRAWERS_1 = null;
    public static final BlockDrawers SPRUCE_HALF_DRAWERS_2 = null;
    public static final BlockDrawers SPRUCE_HALF_DRAWERS_4 = null;
    public static final BlockDrawers BIRCH_FULL_DRAWERS_1 = null;
    public static final BlockDrawers BIRCH_FULL_DRAWERS_2 = null;
    public static final BlockDrawers BIRCH_FULL_DRAWERS_4 = null;
    public static final BlockDrawers BIRCH_HALF_DRAWERS_1 = null;
    public static final BlockDrawers BIRCH_HALF_DRAWERS_2 = null;
    public static final BlockDrawers BIRCH_HALF_DRAWERS_4 = null;
    public static final BlockDrawers JUNGLE_FULL_DRAWERS_1 = null;
    public static final BlockDrawers JUNGLE_FULL_DRAWERS_2 = null;
    public static final BlockDrawers JUNGLE_FULL_DRAWERS_4 = null;
    public static final BlockDrawers JUNGLE_HALF_DRAWERS_1 = null;
    public static final BlockDrawers JUNGLE_HALF_DRAWERS_2 = null;
    public static final BlockDrawers JUNGLE_HALF_DRAWERS_4 = null;
    public static final BlockDrawers ACACIA_FULL_DRAWERS_1 = null;
    public static final BlockDrawers ACACIA_FULL_DRAWERS_2 = null;
    public static final BlockDrawers ACACIA_FULL_DRAWERS_4 = null;
    public static final BlockDrawers ACACIA_HALF_DRAWERS_1 = null;
    public static final BlockDrawers ACACIA_HALF_DRAWERS_2 = null;
    public static final BlockDrawers ACACIA_HALF_DRAWERS_4 = null;
    public static final BlockDrawers DARK_OAK_FULL_DRAWERS_1 = null;
    public static final BlockDrawers DARK_OAK_FULL_DRAWERS_2 = null;
    public static final BlockDrawers DARK_OAK_FULL_DRAWERS_4 = null;
    public static final BlockDrawers DARK_OAK_HALF_DRAWERS_1 = null;
    public static final BlockDrawers DARK_OAK_HALF_DRAWERS_2 = null;
    public static final BlockDrawers DARK_OAK_HALF_DRAWERS_4 = null;
    public static final BlockDrawers COMPACTING_DRAWERS_3 = null;
    public static final Block OAK_TRIM = null;
    public static final Block SPRUCE_TRIM = null;
    public static final Block BIRCH_TRIM = null;
    public static final Block JUNGLE_TRIM = null;
    public static final Block ACACIA_TRIM = null;
    public static final Block DARK_OAK_TRIM = null;
    public static final BlockController CONTROLLER = null;
    public static final BlockSlave CONTROLLER_SLAVE = null;

    @Mod.EventBusSubscriber(modid="storagedrawers", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registration {
        private static List<Block> blockList = new ArrayList<Block>();

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            Registration.registerDrawerBlock(event, "oak_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "oak_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "oak_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "oak_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "oak_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "oak_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "oak_trim");
            Registration.registerDrawerBlock(event, "spruce_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "spruce_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "spruce_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "spruce_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "spruce_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "spruce_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "spruce_trim");
            Registration.registerDrawerBlock(event, "birch_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "birch_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "birch_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "birch_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "birch_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "birch_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "birch_trim");
            Registration.registerDrawerBlock(event, "jungle_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "jungle_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "jungle_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "jungle_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "jungle_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "jungle_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "jungle_trim");
            Registration.registerDrawerBlock(event, "acacia_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "acacia_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "acacia_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "acacia_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "acacia_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "acacia_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "acacia_trim");
            Registration.registerDrawerBlock(event, "dark_oak_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "dark_oak_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "dark_oak_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "dark_oak_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "dark_oak_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "dark_oak_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "dark_oak_trim");
            Registration.registerCompactingDrawerBlock(event, "compacting_drawers_3");
            Registration.registerBlock(event, "controller", (Block)new BlockController(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200943_b(5.0f)));
            Registration.registerBlock(event, "controller_slave", new BlockSlave(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200943_b(5.0f)));
        }

        @SubscribeEvent
        public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
            Registration.registerTileEntity(event, "standard_drawers_1", TileEntityDrawersStandard.Slot1::new, new Block[]{OAK_FULL_DRAWERS_1, OAK_HALF_DRAWERS_1, SPRUCE_FULL_DRAWERS_1, SPRUCE_HALF_DRAWERS_1, BIRCH_FULL_DRAWERS_1, BIRCH_HALF_DRAWERS_1, JUNGLE_FULL_DRAWERS_1, JUNGLE_HALF_DRAWERS_1, ACACIA_FULL_DRAWERS_1, ACACIA_HALF_DRAWERS_1, DARK_OAK_FULL_DRAWERS_1, DARK_OAK_HALF_DRAWERS_1});
            Registration.registerTileEntity(event, "standard_drawers_2", TileEntityDrawersStandard.Slot2::new, new Block[]{OAK_FULL_DRAWERS_2, OAK_HALF_DRAWERS_2, SPRUCE_FULL_DRAWERS_2, SPRUCE_HALF_DRAWERS_2, BIRCH_FULL_DRAWERS_2, BIRCH_HALF_DRAWERS_2, JUNGLE_FULL_DRAWERS_2, JUNGLE_HALF_DRAWERS_2, ACACIA_FULL_DRAWERS_2, ACACIA_HALF_DRAWERS_2, DARK_OAK_FULL_DRAWERS_2, DARK_OAK_HALF_DRAWERS_2});
            Registration.registerTileEntity(event, "standard_drawers_4", TileEntityDrawersStandard.Slot4::new, new Block[]{OAK_FULL_DRAWERS_4, OAK_HALF_DRAWERS_4, SPRUCE_FULL_DRAWERS_4, SPRUCE_HALF_DRAWERS_4, BIRCH_FULL_DRAWERS_4, BIRCH_HALF_DRAWERS_4, JUNGLE_FULL_DRAWERS_4, JUNGLE_HALF_DRAWERS_4, ACACIA_FULL_DRAWERS_4, ACACIA_HALF_DRAWERS_4, DARK_OAK_FULL_DRAWERS_4, DARK_OAK_HALF_DRAWERS_4});
            Registration.registerTileEntity(event, "fractional_drawers_3", TileEntityDrawersComp.Slot3::new, new Block[]{COMPACTING_DRAWERS_3});
            Registration.registerTileEntity(event, "controller", TileEntityController::new, new Block[]{CONTROLLER});
            Registration.registerTileEntity(event, "controller_slave", TileEntitySlave::new, CONTROLLER_SLAVE);
        }

        private static Block registerDrawerBlock(RegistryEvent.Register<Block> event, String name, int drawerCount, boolean halfDepth) {
            return Registration.registerBlock(event, name, (Block)new BlockStandardDrawers(drawerCount, halfDepth, AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(5.0f).func_235842_b_(Registration::predFalse).func_235847_c_(Registration::predFalse)));
        }

        private static Block registerTrimBlock(RegistryEvent.Register<Block> event, String name) {
            return Registration.registerBlock(event, name, new BlockTrim(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(5.0f)));
        }

        private static Block registerCompactingDrawerBlock(RegistryEvent.Register<Block> event, String name) {
            return Registration.registerBlock(event, name, (Block)new BlockCompDrawers(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200943_b(10.0f).func_235842_b_(Registration::predFalse).func_235847_c_(Registration::predFalse)));
        }

        private static Block registerBlock(RegistryEvent.Register<Block> event, String name, Block block) {
            return Registration.registerBlock(event, name, block, blockList);
        }

        private static Block registerBlock(RegistryEvent.Register<Block> event, String name, Block block, List<Block> group) {
            block.setRegistryName(name);
            event.getRegistry().register((IForgeRegistryEntry)block);
            group.add(block);
            return block;
        }

        private static <T extends TileEntity> void registerTileEntity(RegistryEvent.Register<TileEntityType<?>> event, String name, Supplier<? extends T> factory, Block ... blocks) {
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(factory, (Block[])blocks).func_206865_a(null).setRegistryName(new ResourceLocation("storagedrawers", name)));
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            for (Block block : blockList) {
                ItemDrawers itemBlock = null;
                itemBlock = block instanceof BlockDrawers ? new ItemDrawers(block, new Item.Properties().func_200916_a(ModItemGroup.STORAGE_DRAWERS)) : new BlockItem(block, new Item.Properties().func_200916_a(ModItemGroup.STORAGE_DRAWERS));
                itemBlock.setRegistryName(block.getRegistryName());
                event.getRegistry().register((IForgeRegistryEntry)itemBlock);
            }
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void registerModels(ModelBakeEvent event) {
            ClientRegistry.bindTileEntityRenderer(Tile.STANDARD_DRAWERS_1, TileEntityDrawersRenderer::new);
            ClientRegistry.bindTileEntityRenderer(Tile.STANDARD_DRAWERS_2, TileEntityDrawersRenderer::new);
            ClientRegistry.bindTileEntityRenderer(Tile.STANDARD_DRAWERS_4, TileEntityDrawersRenderer::new);
            ClientRegistry.bindTileEntityRenderer(Tile.FRACTIONAL_DRAWERS_3, TileEntityDrawersRenderer::new);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void bindRenderTypes() {
            for (Block block : blockList) {
                if (!(block instanceof BlockDrawers)) continue;
                RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228641_d_());
            }
        }

        private static boolean predFalse(BlockState p_235436_0_, IBlockReader p_235436_1_, BlockPos p_235436_2_) {
            return false;
        }
    }

    @ObjectHolder(value="storagedrawers")
    public static final class Tile {
        public static final TileEntityType<TileEntityDrawersStandard> STANDARD_DRAWERS_1 = null;
        public static final TileEntityType<TileEntityDrawersStandard> STANDARD_DRAWERS_2 = null;
        public static final TileEntityType<TileEntityDrawersStandard> STANDARD_DRAWERS_4 = null;
        public static final TileEntityType<TileEntityDrawersComp> FRACTIONAL_DRAWERS_3 = null;
        public static final TileEntityType<TileEntityController> CONTROLLER = null;
        public static final TileEntityType<TileEntitySlave> CONTROLLER_SLAVE = null;
    }
}

