/*
 * Decompiled with CFR 0.152.
 */
package superworldsun.superslegend.entities.projectiles.items.bomb;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import superworldsun.superslegend.init.EntityInit;
import superworldsun.superslegend.init.SoundInit;
import superworldsun.superslegend.lists.ItemList;

public class BombEntity
extends AbstractArrowEntity {
    private static final DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(BombEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> field_226571_aq_ = EntityDataManager.func_187226_a(BombEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public ItemStack thrownStack = new ItemStack((IItemProvider)ItemList.bomb);
    private boolean dealtDamage;
    @Nullable
    private LivingEntity tntPlacedBy;
    private int fuse = 80;

    public BombEntity(EntityType<? extends BombEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public BombEntity(World worldIn, PlayerEntity thrower, ItemStack thrownStackIn) {
        super((EntityType)EntityInit.BOMBENTITY.get(), (LivingEntity)thrower, worldIn);
        this.thrownStack = thrownStackIn.func_77946_l();
        this.field_70180_af.func_187227_b(field_226571_aq_, (Object)thrownStackIn.func_77962_s());
    }

    @OnlyIn(value=Dist.CLIENT)
    public BombEntity(World worldIn, double x, double y, double z, @Nullable LivingEntity igniter) {
        super((EntityType)EntityInit.BOMBENTITY.get(), worldIn);
        this.func_70107_b(x, y, z);
        double d0 = worldIn.field_73012_v.nextDouble() * 6.2831854820251465;
        this.func_213293_j(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.setFuse(80);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.tntPlacedBy = igniter;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_226571_aq_, (Object)false);
        this.field_70180_af.func_187214_a(FUSE, (Object)80);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void func_70071_h_() {
        BlockPos currentPos;
        if (this.field_70173_aa % 22 == 0) {
            currentPos = this.func_233580_cy_();
            this.field_70170_p.func_184148_a(null, (double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p(), SoundInit.BOMB_FUSE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if (this.func_70090_H()) {
            currentPos = this.func_233580_cy_();
            this.field_70170_p.func_184148_a(null, (double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p(), SoundInit.BOMB_DEFUSE, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.func_70106_y();
        }
        if (this.func_70027_ad()) {
            this.explode();
            this.func_70106_y();
        }
        if (this.func_180799_ab()) {
            this.func_70027_ad();
            this.explode();
            this.func_70106_y();
        }
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_186678_a(1.0));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
        }
        --this.fuse;
        if (this.fuse <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.explode();
            }
        } else {
            this.func_233566_aG_();
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 0.6, this.func_226281_cx_(), 0.0, 0.1, 0.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 0.6, this.func_226281_cx_(), 0.0, 0.1, 0.0);
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 0.6, this.func_226281_cx_(), 0.0, 0.1, 0.0);
            }
        }
    }

    protected void explode() {
        float f = 4.0f;
        this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226283_e_(0.1f), this.func_226281_cx_(), 4.0f, Explosion.Mode.NONE);
    }

    protected ItemStack func_184550_j() {
        return this.thrownStack.func_77946_l();
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vector3d startVec, Vector3d endVec) {
        return this.dealtDamage ? null : super.func_213866_a(startVec, endVec);
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        Entity entity = p_213868_1_.func_216348_a();
        float f = 8.0f;
        Entity entity1 = this.func_234616_v_();
        DamageSource damagesource = DamageSource.func_76356_a((Entity)this, (Entity)entity1);
        this.dealtDamage = true;
        if (entity.func_70097_a(damagesource, f)) {
            if (entity.func_200600_R() == EntityType.field_200803_q) {
                this.explode();
            }
            if (entity instanceof LivingEntity) {
                this.explode();
            }
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Bomb", 10)) {
            this.thrownStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Bomb"));
        }
        this.setFuse(compound.func_74765_d("Fuse"));
        this.dealtDamage = compound.func_74767_n("DealtDamage");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("Bomb", (INBT)this.thrownStack.func_77955_b(new CompoundNBT()));
        compound.func_74757_a("DealtDamage", this.dealtDamage);
        compound.func_74777_a("Fuse", (short)this.getFuse());
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.15f;
    }

    @Nullable
    public LivingEntity getTntPlacedBy() {
        return this.tntPlacedBy;
    }

    public void setFuse(int fuseIn) {
        this.field_70180_af.func_187227_b(FUSE, (Object)fuseIn);
        this.fuse = fuseIn;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (FUSE.equals(key)) {
            this.fuse = this.getFuseDataManager();
        }
    }

    public int getFuseDataManager() {
        return (Integer)this.field_70180_af.func_187225_a(FUSE);
    }

    public int getFuse() {
        return this.fuse;
    }

    protected float func_203044_p() {
        return 0.99f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }
}

