/*
 * Decompiled with CFR 0.152.
 */
package superworldsun.superslegend.entities.projectiles.items.boomerang;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.TripWireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import superworldsun.superslegend.config.SupersLegendConfig;
import superworldsun.superslegend.init.SoundInit;

public abstract class BoomerangEntity
extends Entity {
    private BlockPos activatedPos;
    protected boolean isBouncing;
    private double bounceFactor = 0.85;
    private float prevBoomerangRotation;
    private boolean turningAround = false;
    protected int timeBeforeTurnAround = 30;
    List<ItemEntity> itemsPickedUp = new ArrayList<ItemEntity>();
    private ItemStack selfStack;
    private Hand hand = Hand.MAIN_HAND;
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Optional<UUID>> RETURN_UNIQUE_ID = EntityDataManager.func_187226_a(BoomerangEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public BoomerangEntity(EntityType<BoomerangEntity> type, World world) {
        super(type, world);
    }

    public BoomerangEntity(EntityType<BoomerangEntity> type, World worldIn, PlayerEntity entity, ItemStack itemstack, Hand hand) {
        this(type, worldIn);
        this.selfStack = itemstack;
        this.func_70101_b(entity.field_70177_z, entity.field_70125_A);
        double x = -MathHelper.func_76126_a((float)(entity.field_70177_z * 3.141593f / 180.0f));
        double z = MathHelper.func_76134_b((float)(entity.field_70177_z * 3.141593f / 180.0f));
        double motionX = 0.5 * x * (double)MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * 3.141593f));
        double motionY = -0.5 * (double)MathHelper.func_76126_a((float)(entity.field_70125_A / 180.0f * 3.141593f));
        double motionZ = 0.5 * z * (double)MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * 3.141593f));
        this.func_213317_d(new Vector3d(motionX, motionY, motionZ));
        this.func_70107_b(entity.func_226277_ct_(), this.getReturnEntityY(entity), entity.func_226281_cx_());
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.isBouncing = false;
        this.turningAround = false;
        this.hand = hand;
        this.setReturnToId(entity.func_110124_au());
    }

    public double getReturnEntityY(PlayerEntity entity) {
        return entity.func_226278_cu_() + (double)entity.func_70047_e() - (double)0.1f;
    }

    @Deprecated
    public void func_70071_h_() {
        Vector3d vec3d;
        Vector3d vec3d1;
        BlockRayTraceResult raytraceresult;
        PlayerEntity player = this.getReturnTo();
        if (this.field_70173_aa % 11 == 0) {
            BlockPos currentPos = this.func_233580_cy_();
            this.field_70170_p.func_184148_a(null, (double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p(), SoundInit.BOOMERANG_FLY_LOOP, SoundCategory.PLAYERS, 0.4f, 1.0f);
        }
        if ((raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d1 = this.func_213303_ch(), vec3d = this.func_213303_ch().func_178787_e(this.func_213322_ci()), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.ANY, null))) != null && raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = new BlockPos(raytraceresult.func_216347_e());
            BlockState state = this.field_70170_p.func_180495_p(pos);
            if (state.func_185904_a() == Material.field_151585_k && ((Boolean)SupersLegendConfig.COMMON.breaksFlowers.get()).booleanValue()) {
                this.field_70170_p.func_175655_b(pos, true);
            }
            if (state.func_185904_a() == Material.field_151582_l && ((Boolean)SupersLegendConfig.COMMON.breaksTallGrass.get()).booleanValue()) {
                this.field_70170_p.func_175655_b(pos, true);
            }
            if (state.func_177230_c() instanceof TorchBlock && ((Boolean)SupersLegendConfig.COMMON.breaksTorches.get()).booleanValue()) {
                this.field_70170_p.func_175655_b(pos, true);
            }
            if (state.func_177230_c() instanceof LeverBlock && ((Boolean)SupersLegendConfig.COMMON.activatesLevers.get()).booleanValue()) {
                if (this.timeBeforeTurnAround > 0 && ((Boolean)SupersLegendConfig.COMMON.turnAroundButton.get()).booleanValue()) {
                    this.timeBeforeTurnAround = 0;
                }
                if (this.activatedPos == null || !this.activatedPos.equals((Object)pos)) {
                    this.activatedPos = pos;
                    state.func_177230_c().func_225533_a_(state, this.field_70170_p, pos, player, Hand.MAIN_HAND, (BlockRayTraceResult)raytraceresult.hitInfo);
                }
            }
            if (state.func_177230_c() instanceof AbstractButtonBlock && ((Boolean)SupersLegendConfig.COMMON.activatesButtons.get()).booleanValue()) {
                if (this.timeBeforeTurnAround > 0 && ((Boolean)SupersLegendConfig.COMMON.turnAroundButton.get()).booleanValue()) {
                    this.timeBeforeTurnAround = 0;
                }
                if (this.activatedPos == null || !this.activatedPos.equals((Object)pos)) {
                    this.activatedPos = pos;
                    state.func_177230_c().func_225533_a_(state, this.field_70170_p, pos, player, Hand.MAIN_HAND, (BlockRayTraceResult)raytraceresult.hitInfo);
                }
            }
            if (state.func_177230_c() instanceof PressurePlateBlock && ((Boolean)SupersLegendConfig.COMMON.activatesPressurePlates.get()).booleanValue()) {
                if (this.timeBeforeTurnAround > 0 && ((Boolean)SupersLegendConfig.COMMON.turnAroundButton.get()).booleanValue()) {
                    this.timeBeforeTurnAround = 0;
                }
                if (this.activatedPos == null || !this.activatedPos.equals((Object)pos)) {
                    this.activatedPos = pos;
                    state.func_177230_c().func_225533_a_(state, this.field_70170_p, pos, player, Hand.MAIN_HAND, (BlockRayTraceResult)raytraceresult.hitInfo);
                }
            }
            if (state.func_177230_c() instanceof TripWireBlock && ((Boolean)SupersLegendConfig.COMMON.activatesTripWire.get()).booleanValue()) {
                if (this.timeBeforeTurnAround > 0 && ((Boolean)SupersLegendConfig.COMMON.turnAroundButton.get()).booleanValue()) {
                    this.timeBeforeTurnAround = 0;
                }
                if (this.activatedPos == null || !this.activatedPos.equals((Object)pos)) {
                    this.activatedPos = pos;
                    state.func_177230_c().func_225533_a_(state, this.field_70170_p, pos, player, Hand.MAIN_HAND, (BlockRayTraceResult)raytraceresult.hitInfo);
                }
            }
        }
        if (!this.turningAround) {
            Vector3d motionBefore = this.func_213322_ci();
            this.func_213315_a(MoverType.SELF, motionBefore);
            Vector3d motionAfter = this.func_213322_ci();
            double newX = motionAfter.field_72450_a;
            double newY = motionAfter.field_72448_b;
            double newZ = motionAfter.field_72449_c;
            boolean flag = false;
            if (motionAfter.field_72450_a != motionBefore.field_72450_a) {
                newX = -motionBefore.field_72450_a;
                flag = true;
            }
            if (motionAfter.field_72448_b != motionBefore.field_72448_b) {
                newY = -motionBefore.field_72448_b;
                flag = true;
            }
            if (motionAfter.field_72449_c != motionBefore.field_72449_c) {
                newZ = -motionBefore.field_72449_c;
                flag = true;
            }
            if (flag) {
                this.isBouncing = true;
                this.func_213317_d(new Vector3d(newX, newY, newZ).func_216372_d(this.bounceFactor, this.bounceFactor, this.bounceFactor));
            }
            this.beforeTurnAround(player);
            if (this.timeBeforeTurnAround-- <= 0) {
                this.turningAround = true;
            }
        } else if (player != null) {
            double z;
            double y;
            double x = player.func_226277_ct_() - this.func_226277_ct_();
            double d = Math.sqrt(x * x + (y = this.getReturnEntityY(player) - this.func_226278_cu_()) * y + (z = player.func_226281_cx_() - this.func_226281_cx_()) * z);
            if (d < 1.5) {
                this.setEntityDead();
            }
            this.func_213293_j(0.9 * x / d, 0.5 * y / d, 0.9 * z / d);
            this.func_70107_b(this.func_226277_ct_() + this.func_213322_ci().field_72450_a, this.func_226278_cu_() + this.func_213322_ci().field_72448_b, this.func_226281_cx_() + this.func_213322_ci().field_72449_c);
        }
        this.determineRotation();
        this.prevBoomerangRotation = this.getBoomerangRotation();
        this.setBoomerangRotation(this.getBoomerangRotation() + 36.0f);
        while (this.getBoomerangRotation() > 360.0f) {
            this.setBoomerangRotation(this.getBoomerangRotation() - 360.0f);
        }
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(0.5, 0.5, 0.5));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity instanceof ItemEntity) {
                this.itemsPickedUp.add((ItemEntity)entity);
                if (this.timeBeforeTurnAround <= 0 || !((Boolean)SupersLegendConfig.COMMON.turnAroundItem.get()).booleanValue()) continue;
                this.timeBeforeTurnAround = 0;
                continue;
            }
            if (!(entity instanceof LivingEntity) || entity == player) continue;
            this.onEntityHit(entity, player);
            if (this.timeBeforeTurnAround <= 0 || !((Boolean)SupersLegendConfig.COMMON.turnAroundMob.get()).booleanValue()) continue;
            this.timeBeforeTurnAround = 0;
        }
        for (ItemEntity item : this.itemsPickedUp) {
            item.func_213293_j(0.0, 0.0, 0.0);
            if (!item.func_70089_S()) continue;
            Vector3d pos = this.func_213303_ch();
            item.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
        super.func_70071_h_();
    }

    public void beforeTurnAround(PlayerEntity player) {
    }

    public void onEntityHit(Entity hitEntity, PlayerEntity player) {
        hitEntity.func_70097_a(this.causeNewDamage(this, (Entity)player), (float)this.getDamage(hitEntity, player));
    }

    protected abstract int getDamage(Entity var1, PlayerEntity var2);

    public abstract DamageSource causeNewDamage(BoomerangEntity var1, Entity var2);

    public void setEntityDead() {
        if (this.getReturnTo() != null && this.selfStack != null) {
            if (this.hand == Hand.OFF_HAND) {
                if (this.getReturnTo().func_184592_cb().func_190926_b()) {
                    this.getReturnTo().func_184611_a(Hand.OFF_HAND, this.selfStack);
                } else {
                    this.getReturnTo().field_71071_by.func_70441_a(this.selfStack);
                }
            } else {
                this.getReturnTo().field_71071_by.func_70441_a(this.selfStack);
            }
        }
        super.func_241204_bJ_();
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(RETURN_UNIQUE_ID, Optional.empty());
    }

    public float getBoomerangRotation() {
        return ((Float)this.func_184212_Q().func_187225_a(ROTATION)).floatValue();
    }

    public void setBoomerangRotation(float rotationIn) {
        this.func_184212_Q().func_187227_b(ROTATION, (Object)Float.valueOf(rotationIn));
    }

    @Nullable
    public UUID getReturnToId() {
        return ((Optional)this.field_70180_af.func_187225_a(RETURN_UNIQUE_ID)).orElse(null);
    }

    public void setReturnToId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(RETURN_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    @Nullable
    public PlayerEntity getReturnTo() {
        try {
            UUID uuid = this.getReturnToId();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isReturnTo(LivingEntity entityIn) {
        return entityIn == this.getReturnTo();
    }

    public void determineRotation() {
        Vector3d motion = this.func_213322_ci();
        this.field_70177_z = -57.29578f * (float)Math.atan2(motion.field_72450_a, motion.field_72449_c);
        double d1 = Math.sqrt(motion.field_72449_c * motion.field_72449_c + motion.field_72450_a * motion.field_72450_a);
        this.field_70125_A = -57.29578f * (float)Math.atan2(motion.field_72448_b, d1);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.isBouncing = compound.func_74767_n("IsBouncing");
        this.bounceFactor = compound.func_74769_h("BounceFactor");
        this.prevBoomerangRotation = compound.func_74760_g("PrevBoomerangRotation");
        this.setBoomerangRotation(compound.func_74760_g("BoomerangRotation"));
        this.turningAround = compound.func_74767_n("TurningAround");
        this.timeBeforeTurnAround = compound.func_74762_e("TimeBeforeTurnAround");
        if (compound.func_74764_b("xPos") && compound.func_74764_b("yPos") && compound.func_74764_b("zPos")) {
            this.activatedPos = new BlockPos(compound.func_74762_e("xPos"), compound.func_74762_e("yPos"), compound.func_74762_e("zPos"));
        }
        if (compound.func_150297_b("ReturnToUUID", 8)) {
            try {
                this.setReturnToId(UUID.fromString(compound.func_74779_i("ReturnToUUID")));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.selfStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("SelfStack"));
        ListNBT itemsGathered = compound.func_150295_c("ItemsPickedUp", 10);
        for (int i = 0; i < itemsGathered.size(); ++i) {
            CompoundNBT tag = itemsGathered.func_150305_b(i);
            ItemEntity item = new ItemEntity(this.field_70170_p, 0.0, 0.0, 0.0);
            item.func_70037_a(tag);
            this.itemsPickedUp.add(item);
        }
        this.hand = Hand.valueOf((String)compound.func_74779_i("hand"));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("IsBouncing", this.isBouncing);
        compound.func_74780_a("BounceFactor", this.bounceFactor);
        compound.func_74776_a("PrevBoomerangRotation", this.prevBoomerangRotation);
        compound.func_74776_a("BoomerangRotation", this.getBoomerangRotation());
        compound.func_74757_a("TurningAround", this.turningAround);
        compound.func_74768_a("TimeBeforeTurnAround", this.timeBeforeTurnAround);
        if (this.activatedPos != null) {
            compound.func_74768_a("xPos", this.activatedPos.func_177958_n());
            compound.func_74768_a("yPos", this.activatedPos.func_177956_o());
            compound.func_74768_a("zPos", this.activatedPos.func_177952_p());
        }
        if (this.getReturnToId() == null) {
            compound.func_74778_a("ReturnToUUID", "");
        } else {
            compound.func_74778_a("ReturnToUUID", this.getReturnToId().toString());
        }
        CompoundNBT selfStackTag = new CompoundNBT();
        this.selfStack.func_77955_b(selfStackTag);
        compound.func_218657_a("SelfStack", (INBT)selfStackTag);
        ListNBT itemsGathered = new ListNBT();
        for (int i = 0; i < this.itemsPickedUp.size(); ++i) {
            if (this.itemsPickedUp.get(i) == null) continue;
            CompoundNBT tag = new CompoundNBT();
            this.itemsPickedUp.get(i).func_213281_b(compound);
            itemsGathered.add((Object)tag);
        }
        compound.func_218657_a("ItemsPickedUp", (INBT)itemsGathered);
        compound.func_74778_a("hand", this.hand.toString());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

