/*
 * Decompiled with CFR 0.152.
 */
package superworldsun.superslegend.entities.projectiles.items.boomerang;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import superworldsun.superslegend.config.SupersLegendConfig;
import superworldsun.superslegend.entities.projectiles.items.boomerang.BoomerangEntity;
import superworldsun.superslegend.init.EntityInit;

public class RegularBoomerang
extends BoomerangEntity {
    public RegularBoomerang(EntityType<BoomerangEntity> type, World world) {
        super(type, world);
        this.timeBeforeTurnAround = (Integer)SupersLegendConfig.COMMON.RegularBoomerangRange.get() <= 0 ? 20 : (Integer)SupersLegendConfig.COMMON.RegularBoomerangRange.get();
    }

    public RegularBoomerang(World worldIn, PlayerEntity entity, ItemStack itemstack, Hand hand) {
        super((EntityType<BoomerangEntity>)((EntityType)EntityInit.REGULAR_BOOMERANG.get()), worldIn, entity, itemstack, hand);
        this.timeBeforeTurnAround = (Integer)SupersLegendConfig.COMMON.RegularBoomerangRange.get() <= 0 ? 20 : (Integer)SupersLegendConfig.COMMON.RegularBoomerangRange.get();
    }

    @Override
    protected int getDamage(Entity hitEntity, PlayerEntity player) {
        if ((Integer)SupersLegendConfig.COMMON.RegularBoomerangDamage.get() > 0) {
            return (Integer)SupersLegendConfig.COMMON.RegularBoomerangDamage.get();
        }
        return 0;
    }

    @Override
    public DamageSource causeNewDamage(BoomerangEntity entityboomerang, Entity entity) {
        return new IndirectEntityDamageSource("regular_boomerang", (Entity)entityboomerang, entity).func_76349_b();
    }

    @Override
    public void beforeTurnAround(PlayerEntity player) {
        if (!this.isBouncing && ((Boolean)SupersLegendConfig.COMMON.RegularBoomerangFollows.get()).booleanValue()) {
            double x = -MathHelper.func_76126_a((float)(player.field_70177_z * 3.141593f / 180.0f));
            double z = MathHelper.func_76134_b((float)(player.field_70177_z * 3.141593f / 180.0f));
            double motionX = 0.5 * x * (double)MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * 3.141593f));
            double motionY = -0.5 * (double)MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * 3.141593f));
            double motionZ = 0.5 * z * (double)MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * 3.141593f));
            this.func_213293_j(motionX, motionY, motionZ);
        }
    }
}

