/*
 * Decompiled with CFR 0.152.
 */
package teletubbies;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import teletubbies.Teletubbies;
import teletubbies.capability.ITeletubbies_CAP;
import teletubbies.capability.Teletubbies_CAPProvider;
import teletubbies.entity.monster.EntityZombieDipsy;
import teletubbies.entity.monster.EntityZombieLaaLaa;
import teletubbies.entity.monster.EntityZombiePo;
import teletubbies.entity.monster.EntityZombieTinkyWinky;
import teletubbies.entity.passive.EntityDipsy;
import teletubbies.entity.passive.EntityLaaLaa;
import teletubbies.entity.passive.EntityPo;
import teletubbies.entity.passive.EntityTinkyWinky;
import teletubbies.item.LaaLaaBall;
import teletubbies.vehicle.EntityPoScooter;

public class TeletubbiesEventHandler {
    @SubscribeEvent
    public void attachtCapabilityEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("teletubbies:TeletubbiesCap"), (ICapabilityProvider)new Teletubbies_CAPProvider((EntityPlayer)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            World world = player.field_70170_p;
            ITeletubbies_CAP capability = (ITeletubbies_CAP)player.getCapability(Teletubbies.Teletubbies_CAP, player.func_174811_aO());
            float fallDistance = capability.fallDistance();
            int ticks = capability.ticksOnGround();
            if (player.field_70122_E && ticks < 50) {
                capability.setTicksOnGround(ticks + 1);
            }
            if (!player.field_70122_E && ticks != 0) {
                capability.setTicksOnGround(0);
            }
            if (player.field_70143_R > fallDistance) {
                capability.setFallDistance(player.field_70143_R);
            }
            LaaLaaBall ball = null;
            if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof LaaLaaBall && player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() instanceof LaaLaaBall) {
                ball = (LaaLaaBall)player.func_184614_ca().func_77973_b();
            } else if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof LaaLaaBall) {
                ball = (LaaLaaBall)player.func_184614_ca().func_77973_b();
            } else if (player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() instanceof LaaLaaBall) {
                ball = (LaaLaaBall)player.func_184592_cb().func_77973_b();
            }
            if (ball != null && capability.canJump() && fallDistance >= 10.0f) {
                LaaLaaBall.jump(player, true);
            }
            if (player.field_70122_E) {
                capability.setFallDistance(0.0f);
            }
            if (player.func_70090_H() || player.func_180799_ab()) {
                capability.setFallDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public void fallEvent(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof LaaLaaBall) {
                event.setCanceled(true);
            }
            if (player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() instanceof LaaLaaBall) {
                event.setCanceled(true);
            }
        }
        if (event.getEntity() instanceof EntityPoScooter) {
            EntityPoScooter scooter = (EntityPoScooter)event.getEntity();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityZombie) {
            EntityZombie zombie = (EntityZombie)event.getEntity();
            zombie.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)zombie, EntityPo.class, true));
            zombie.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)zombie, EntityLaaLaa.class, true));
            zombie.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)zombie, EntityDipsy.class, true));
            zombie.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)zombie, EntityTinkyWinky.class, true));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onLivingDeathEvent(LivingDeathEvent event) {
        Random rand = new Random();
        int randomNumber = rand.nextInt(5) + 1;
        DamageSource damageSource = event.getSource();
        World world = event.getEntityLiving().field_70170_p;
        double posX = event.getEntityLiving().field_70165_t;
        double posY = event.getEntityLiving().field_70163_u;
        double posZ = event.getEntityLiving().field_70161_v;
        if (!world.field_72995_K && damageSource.func_76364_f() instanceof EntityZombie) {
            if (event.getEntity() instanceof EntityTinkyWinky && randomNumber == 1) {
                EntityZombieTinkyWinky zombieTinkyWinky = new EntityZombieTinkyWinky(world);
                EntityTinkyWinky.transferredToZombie = true;
                zombieTinkyWinky.func_70012_b(posX, posY, posZ, event.getEntityLiving().field_70177_z, event.getEntityLiving().field_70125_A);
                world.func_72838_d((Entity)zombieTinkyWinky);
            }
            if (event.getEntity() instanceof EntityDipsy && randomNumber == 1) {
                EntityZombieDipsy zombieDipsy = new EntityZombieDipsy(world);
                EntityDipsy.transferredToZombie = true;
                zombieDipsy.func_70012_b(posX, posY, posZ, event.getEntityLiving().field_70177_z, event.getEntityLiving().field_70125_A);
                world.func_72838_d((Entity)zombieDipsy);
            }
            if (event.getEntity() instanceof EntityLaaLaa && randomNumber == 1) {
                EntityZombieLaaLaa zombieLaaLaa = new EntityZombieLaaLaa(world);
                EntityLaaLaa.transferredToZombie = true;
                zombieLaaLaa.func_70012_b(posX, posY, posZ, event.getEntityLiving().field_70177_z, event.getEntityLiving().field_70125_A);
                world.func_72838_d((Entity)zombieLaaLaa);
            }
            if (event.getEntity() instanceof EntityPo && randomNumber == 1) {
                EntityZombiePo zombiePo = new EntityZombiePo(world);
                EntityPo.transferredToZombie = true;
                zombiePo.func_70012_b(posX, posY, posZ, event.getEntityLiving().field_70177_z, event.getEntityLiving().field_70125_A);
                world.func_72838_d((Entity)zombiePo);
            }
        }
    }
}

