/*
 * Decompiled with CFR 0.152.
 */
package teletubbies.block.tileentity;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import teletubbies.Teletubbies;
import teletubbies.block.tileentity.TubbyTileEntity;

public class TileEntityTubbyCustardMachine
extends TubbyTileEntity
implements ITickable {
    private boolean isTower = false;
    private int masterFacing = 0;
    private int ticks = 80;
    private EntityPlayer player = null;

    public void func_73660_a() {
        if (this.ticks < 80) {
            ++this.ticks;
        }
        if (this.ticks == 60 && this.player != null) {
            this.dropCustard(new ItemStack(Teletubbies.tubbyCustard, 1), this.player);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74757_a("isTower", this.isTower);
        data.func_74768_a("masterFacing", this.masterFacing);
        data.func_74768_a("ticks", this.ticks);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.isTower = data.func_74767_n("isTower");
        this.masterFacing = data.func_74762_e("masterFacing");
        this.ticks = data.func_74762_e("ticks");
    }

    private void dropCustard(ItemStack itemstack, EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            Random rand = new Random();
            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.getMasterX() + 0.5, (double)this.getMasterY() + 1.6, (double)this.getMasterZ() + 0.5, itemstack);
            float f2 = 0.3f;
            entityItem.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * f2;
            entityItem.field_70181_x = (double)(-MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * f2 + 0.1f) + 0.1;
            entityItem.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * f2;
            float f3 = rand.nextFloat() * (float)Math.PI * 2.0f;
            f2 = 0.02f * rand.nextFloat();
            entityItem.field_70159_w += Math.cos(f3) * (double)f2;
            entityItem.field_70181_x += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
            entityItem.field_70179_y += Math.sin(f3) * (double)f2;
            entityItem.field_70159_w *= -1.0;
            entityItem.field_70179_y *= -1.0;
            this.field_145850_b.func_72838_d((Entity)entityItem);
            this.setPlayer(null);
        }
    }

    public Boolean isTower() {
        return this.isTower;
    }

    public Integer masterFacing() {
        return this.masterFacing;
    }

    public void setIsTower(boolean isTower) {
        this.isTower = isTower;
    }

    public void setMasterData(int x, int y, int z, boolean ismaster, int facing) {
        this.masterFacing = facing;
        super.setMasterData(x, y, z, ismaster);
    }

    public boolean canDrop() {
        return this.ticks >= 80;
    }

    public void resetDropTicker() {
        this.ticks = 0;
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
    }
}

