/*
 * Decompiled with CFR 0.152.
 */
package teletubbies.world.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import teletubbies.world.structure.TubbyDomeStructure;

public class GenTubbyDomeStructure
implements IWorldGenerator {
    private int progress = 0;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private boolean generateSurface(World world, Random rand, int x, int z) {
        BlockPos[] checkPosArr;
        int xCoord = x + rand.nextInt(16);
        int yCoord = world.func_72800_K();
        int zCoord = z + rand.nextInt(16);
        BlockPos pos = new BlockPos(xCoord, yCoord, zCoord);
        while (world.func_180495_p(pos).func_177230_c() instanceof BlockAir) {
            if (--yCoord <= 0) {
                return false;
            }
            pos = new BlockPos(xCoord, yCoord, zCoord);
        }
        if (this.progress < 1000) {
            ++this.progress;
            return false;
        }
        if (!(world.func_180494_b(pos) instanceof BiomePlains)) {
            return false;
        }
        for (BlockPos check : checkPosArr = new BlockPos[]{new BlockPos(xCoord + 14, yCoord + 0, zCoord + 13), new BlockPos(xCoord + 19, yCoord + 0, zCoord + 13), new BlockPos(xCoord + 9, yCoord + 0, zCoord + 13), new BlockPos(xCoord + 14, yCoord + 0, zCoord + 8), new BlockPos(xCoord + 14, yCoord + 0, zCoord + 18)}) {
            Block block = world.func_180495_p(check).func_177230_c();
            if (block instanceof BlockGrass && !(block instanceof BlockBush) && !(block instanceof BlockLiquid)) continue;
            return false;
        }
        new TubbyDomeStructure().func_180709_b(world, rand, new BlockPos(xCoord, yCoord, zCoord));
        this.progress = 0;
        GenTubbyDomeStructure.removeItems(world, new BlockPos(xCoord + 14, yCoord + 1, zCoord + 13));
        return true;
    }

    public static void removeItems(World world, BlockPos pos) {
        List list = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos).func_72321_a(12.0, 4.0, 12.0));
        for (EntityItem i : list) {
            i.func_70106_y();
        }
    }
}

