/*
 * Decompiled with CFR 0.152.
 */
package teletubbies.world.structure;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLiquid;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import teletubbies.Teletubbies;
import teletubbies.block.tileentity.TubbyTileEntity;

public class GenTubbyVoiceTrumpet
implements IWorldGenerator {
    private int progress = 0;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private boolean generateSurface(World world, Random rand, int x, int z) {
        int xCoord = x + rand.nextInt(16);
        int yCoord = world.func_72800_K();
        int zCoord = z + rand.nextInt(16);
        BlockPos pos = new BlockPos(xCoord, yCoord, zCoord);
        while (world.func_180495_p(pos).func_177230_c() instanceof BlockAir) {
            if (--yCoord <= 0) {
                return false;
            }
            pos = new BlockPos(xCoord, yCoord, zCoord);
        }
        if (this.progress < 50) {
            ++this.progress;
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(world.func_180494_b(pos) instanceof BiomePlains)) {
            return false;
        }
        if (!(block instanceof BlockGrass) || block instanceof BlockBush || block instanceof BlockLiquid) {
            return false;
        }
        pos = new BlockPos(xCoord, yCoord + 1, zCoord);
        BlockPos pos0 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
        int i = new Random().nextInt(4);
        world.func_175656_a(pos, Teletubbies.tubbyVoiceTrumpet.func_176203_a(i));
        world.func_175656_a(pos0, Teletubbies.tubbyVoiceTrumpet.func_176203_a(i + 4));
        TubbyTileEntity te0 = (TubbyTileEntity)world.func_175625_s(pos);
        te0.setMasterData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), true);
        TubbyTileEntity te1 = (TubbyTileEntity)world.func_175625_s(pos0);
        te1.setMasterData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), false);
        this.progress = 0;
        return true;
    }
}

