/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.generation;

import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2839;
import net.minecraft.class_2888;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3537;
import net.minecraft.class_3543;
import net.minecraft.class_3757;

public abstract class BzNoiseChunkGenerator<T extends class_2888>
extends class_2794<T> {
    private static final class_2680 STONE = class_2246.field_10340.method_9564();
    private static final class_2680 WATER = class_2246.field_10382.method_9564();
    private static final class_2680 CAVE_AIR = class_2246.field_10543.method_9564();
    private final int verticalNoiseGranularity;
    private final int horizontalNoiseGranularity;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;
    protected final class_2919 randomSeed;
    private final class_3537 minNoise;
    private final class_3537 maxNoise;
    private final class_3537 mainNoise;
    private final class_3757 surfaceDepthNoise;
    protected final class_2680 defaultBlock;
    protected final class_2680 defaultFluid;

    public BzNoiseChunkGenerator(class_1936 world, class_1966 biomeProvider, int horizontalNoiseGranularityIn, int verticalNoiseGranularityIn, int maxHeight, T settings) {
        super(world, biomeProvider, settings);
        this.verticalNoiseGranularity = verticalNoiseGranularityIn;
        this.horizontalNoiseGranularity = horizontalNoiseGranularityIn;
        this.defaultBlock = STONE;
        this.defaultFluid = WATER;
        this.noiseSizeX = 16 / this.horizontalNoiseGranularity;
        this.noiseSizeY = maxHeight / this.verticalNoiseGranularity;
        this.noiseSizeZ = 16 / this.horizontalNoiseGranularity;
        this.randomSeed = new class_2919(this.field_12759);
        this.minNoise = new class_3537(this.randomSeed, 15, 0);
        this.maxNoise = new class_3537(this.randomSeed, 15, 0);
        this.mainNoise = new class_3537(this.randomSeed, 7, 0);
        this.surfaceDepthNoise = new class_3543(this.randomSeed, 3, 0);
    }

    protected abstract double[] computeNoiseRange(int var1, int var2);

    protected abstract double computeNoiseFalloff(double var1, double var3, int var5);

    protected abstract void sampleNoiseColumn(double[] var1, int var2, int var3);

    private double sampleNoise(int x, int y, int z, double getXCoordinateScale, double getZCoordinateScale, double getHeightScale, double getMainCoordinateScale, double getMainHeightScale, double p_222552_10_) {
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        for (int i = 0; i < 16; ++i) {
            double limitX = class_3537.method_16452((double)((double)x * getXCoordinateScale * d3));
            double limitY = class_3537.method_16452((double)((double)y * getHeightScale * d3));
            double limitZ = class_3537.method_16452((double)((double)z * getZCoordinateScale * d3));
            double mainX = class_3537.method_16452((double)((double)x * getMainCoordinateScale * d3));
            double mainY = class_3537.method_16452((double)((double)y * getMainHeightScale * d3));
            double mainZ = class_3537.method_16452((double)((double)z * getMainCoordinateScale * d3));
            double d7 = getHeightScale * d3;
            d0 += this.minNoise.method_16668(i).method_16447(limitX, limitY, limitZ, d7, (double)y * d7) / d3;
            d1 += this.maxNoise.method_16668(i).method_16447(limitX, limitY, limitZ, d7, (double)y * d7) / d3;
            if (i < 8) {
                d2 += this.mainNoise.method_16668(i).method_16447(mainX, mainY, mainZ, p_222552_10_ * d3, (double)y * p_222552_10_ * d3) / d3;
            }
            d3 /= 2.0;
        }
        return class_3532.method_15390((double)(d0 / 512.0), (double)(d1 / 512.0), (double)((d2 / 10.0 + 1.0) / 2.0));
    }

    protected void setupNoiseGenerators(double[] areaArrayIn, int x, int z, double getXCoordinateScale, double getZCoordinateScale, double getHeightScale, double getMainCoordinateScale, double getMainHeightScale, double p_222546_10_, int p_222546_12_, int p_222546_13_) {
        double[] localAreaArray = this.computeNoiseRange(x, z);
        double d0 = localAreaArray[0];
        double d1 = localAreaArray[1];
        double d2 = this.noiseSizeY - 3;
        double d3 = 0.0;
        for (int y = 0; y < this.noiseSizeY + 1; ++y) {
            double d4 = this.sampleNoise(x, y, z, getXCoordinateScale, getZCoordinateScale, getHeightScale, getMainCoordinateScale, getMainHeightScale, p_222546_10_);
            d4 -= this.computeNoiseFalloff(d0, d1, y);
            if ((double)y > d2) {
                d4 = class_3532.method_15390((double)d4, (double)p_222546_13_, (double)(((double)y - d2) / (double)p_222546_12_));
            } else if ((double)y < d3) {
                d4 = class_3532.method_15390((double)d4, (double)-30.0, (double)((d3 - (double)y) / (d3 - 1.0)));
            }
            areaArrayIn[y] = d4;
        }
    }

    protected double[] sampleNoiseColumn(int x, int z) {
        double[] ds = new double[this.noiseSizeY + 1];
        this.sampleNoiseColumn(ds, x, z);
        return ds;
    }

    public int method_16397(int chunkX, int chunkZ, class_2902.class_2903 heightmapType) {
        int minX = Math.floorDiv(chunkX, this.horizontalNoiseGranularity);
        int minZ = Math.floorDiv(chunkZ, this.horizontalNoiseGranularity);
        int modX = Math.floorMod(chunkX, this.horizontalNoiseGranularity);
        int modZ = Math.floorMod(chunkZ, this.horizontalNoiseGranularity);
        double xFactor = (double)modX / (double)this.horizontalNoiseGranularity;
        double zFactor = (double)modZ / (double)this.horizontalNoiseGranularity;
        double[][] terrain2DArray = new double[][]{this.sampleNoiseColumn(minX, minZ), this.sampleNoiseColumn(minX, minZ + 1), this.sampleNoiseColumn(minX + 1, minZ), this.sampleNoiseColumn(minX + 1, minZ + 1)};
        for (int noiseY = this.noiseSizeY - 1; noiseY >= 0; --noiseY) {
            double d2 = terrain2DArray[0][noiseY];
            double d3 = terrain2DArray[1][noiseY];
            double d4 = terrain2DArray[2][noiseY];
            double d5 = terrain2DArray[3][noiseY];
            double d6 = terrain2DArray[0][noiseY + 1];
            double d7 = terrain2DArray[1][noiseY + 1];
            double d8 = terrain2DArray[2][noiseY + 1];
            double d9 = terrain2DArray[3][noiseY + 1];
            for (int yOffset = this.verticalNoiseGranularity - 1; yOffset >= 0; --yOffset) {
                double yFactor = (double)yOffset / (double)this.verticalNoiseGranularity;
                double finalNoise = class_3532.method_16438((double)yFactor, (double)xFactor, (double)zFactor, (double)d2, (double)d6, (double)d4, (double)d8, (double)d3, (double)d7, (double)d5, (double)d9);
                int y = noiseY * this.verticalNoiseGranularity + yOffset;
                if (!(finalNoise > 0.0)) continue;
                class_2680 blockstate = finalNoise > 0.0 ? this.defaultBlock : this.defaultFluid;
                if (!heightmapType.method_16402().test(blockstate)) continue;
                return y + 1;
            }
        }
        return 0;
    }

    public void method_12110(class_3233 region, class_2791 chunk) {
        class_1923 chunkpos = chunk.method_12004();
        int chunkXSeed = chunkpos.field_9181;
        int chunkZSeed = chunkpos.field_9180;
        class_2919 sharedseedrandom = new class_2919();
        sharedseedrandom.method_12659(chunkXSeed, chunkZSeed);
        class_1923 chunkpos1 = chunk.method_12004();
        int chunkX = chunkpos1.method_8326();
        int chunkZ = chunkpos1.method_8328();
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int xPos = chunkX + x;
                int zPos = chunkZ + z;
                int ySurface = chunk.method_12005(class_2902.class_2903.field_13194, x, z) + 1;
                double noise = this.surfaceDepthNoise.method_16454((double)xPos * 0.0625, (double)zPos * 0.0625, 0.0625, (double)x * 0.0625) * 10.0;
                region.method_23753((class_2338)blockpos$mutable.method_10103(chunkX + x, ySurface, chunkZ + z)).method_8703((Random)sharedseedrandom, chunk, xPos, zPos, ySurface, noise, this.defaultBlock, this.defaultFluid, region.method_8615(), this.field_12760.method_8412());
            }
        }
        this.makeCeilingAndFloor(chunk, (Random)sharedseedrandom);
    }

    protected void makeCeilingAndFloor(class_2791 chunk, Random random) {
        class_2338.class_2339 blockpos$Mutable = new class_2338.class_2339();
        int xStart = chunk.method_12004().method_8326();
        int zStart = chunk.method_12004().method_8328();
        int roofHeight = 255;
        int floorHeight = 0;
        for (class_2338 blockpos : class_2338.method_10094((int)xStart, (int)0, (int)zStart, (int)(xStart + 15), (int)0, (int)(zStart + 15))) {
            for (int ceilingY = roofHeight; ceilingY >= roofHeight - 7; --ceilingY) {
                chunk.method_12010((class_2338)blockpos$Mutable.method_10103(blockpos.method_10263(), ceilingY, blockpos.method_10260()), class_2246.field_21212.method_9564(), false);
            }
            for (int floorY = floorHeight; floorY <= floorHeight; ++floorY) {
                chunk.method_12010((class_2338)blockpos$Mutable.method_10103(blockpos.method_10263(), floorY, blockpos.method_10260()), class_2246.field_21212.method_9564(), false);
            }
        }
    }

    public void method_12088(class_1936 world, class_2791 chunk) {
        class_1923 chunkpos = chunk.method_12004();
        int chunkX = chunkpos.field_9181;
        int chunkZ = chunkpos.field_9180;
        int coordinateX = chunkX << 4;
        int coordinateZ = chunkZ << 4;
        double[][][] terrainNoise2DArray = new double[2][this.noiseSizeZ + 1][this.noiseSizeY + 1];
        for (int index = 0; index < this.noiseSizeZ + 1; ++index) {
            terrainNoise2DArray[0][index] = new double[this.noiseSizeY + 1];
            this.sampleNoiseColumn(terrainNoise2DArray[0][index], chunkX * this.noiseSizeX, chunkZ * this.noiseSizeZ + index);
            terrainNoise2DArray[1][index] = new double[this.noiseSizeY + 1];
        }
        class_2839 protoChunk = (class_2839)chunk;
        class_2902 heightmap = chunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 heightmap1 = chunk.method_12032(class_2902.class_2903.field_13194);
        class_2338.class_2339 blockpos$Mutable = new class_2338.class_2339();
        for (int xNoise = 0; xNoise < this.noiseSizeX; ++xNoise) {
            int zNoise;
            for (zNoise = 0; zNoise < this.noiseSizeZ + 1; ++zNoise) {
                this.sampleNoiseColumn(terrainNoise2DArray[1][zNoise], chunkX * this.noiseSizeX + xNoise + 1, chunkZ * this.noiseSizeZ + zNoise);
            }
            for (zNoise = 0; zNoise < this.noiseSizeZ; ++zNoise) {
                class_2826 chunksection = protoChunk.method_16679(15);
                chunksection.method_16676();
                for (int yNoise = this.noiseSizeY - 1; yNoise >= 0; --yNoise) {
                    double d4;
                    double d3;
                    double d2;
                    double d1;
                    double d0;
                    double d18;
                    double d17;
                    double d16;
                    int yNoiseMod;
                    int yChunk;
                    if (yNoise > 16) {
                        yChunk = yNoise - 1;
                        yNoiseMod = 31 - yChunk;
                        d16 = terrainNoise2DArray[0][zNoise][yNoiseMod + 1];
                        d17 = terrainNoise2DArray[0][zNoise + 1][yNoiseMod + 1];
                        d18 = terrainNoise2DArray[1][zNoise][yNoiseMod + 1];
                        d0 = terrainNoise2DArray[1][zNoise + 1][yNoiseMod + 1];
                        d1 = terrainNoise2DArray[0][zNoise][yNoiseMod];
                        d2 = terrainNoise2DArray[0][zNoise + 1][yNoiseMod];
                        d3 = terrainNoise2DArray[1][zNoise][yNoiseMod];
                        d4 = terrainNoise2DArray[1][zNoise + 1][yNoiseMod];
                    } else {
                        yNoiseMod = yChunk = yNoise;
                        d16 = terrainNoise2DArray[0][zNoise][yNoiseMod];
                        d17 = terrainNoise2DArray[0][zNoise + 1][yNoiseMod];
                        d18 = terrainNoise2DArray[1][zNoise][yNoiseMod];
                        d0 = terrainNoise2DArray[1][zNoise + 1][yNoiseMod];
                        d1 = terrainNoise2DArray[0][zNoise][yNoiseMod + 1];
                        d2 = terrainNoise2DArray[0][zNoise + 1][yNoiseMod + 1];
                        d3 = terrainNoise2DArray[1][zNoise][yNoiseMod + 1];
                        d4 = terrainNoise2DArray[1][zNoise + 1][yNoiseMod + 1];
                    }
                    for (int yInfluence = this.verticalNoiseGranularity - 1; yInfluence >= 0; --yInfluence) {
                        int currentY = yChunk * this.verticalNoiseGranularity + yInfluence;
                        int y = currentY & 0xF;
                        int yChunkFinal = currentY >> 4;
                        if (chunksection.method_12259() >> 4 != yChunkFinal) {
                            chunksection.method_16677();
                            chunksection = protoChunk.method_16679(yChunkFinal);
                            chunksection.method_16676();
                        }
                        double d5 = (double)yInfluence / (double)this.verticalNoiseGranularity;
                        double d6 = class_3532.method_16436((double)d5, (double)d16, (double)d1);
                        double d7 = class_3532.method_16436((double)d5, (double)d18, (double)d3);
                        double d8 = class_3532.method_16436((double)d5, (double)d17, (double)d2);
                        double d9 = class_3532.method_16436((double)d5, (double)d0, (double)d4);
                        for (int horizontalNoiseX = 0; horizontalNoiseX < this.horizontalNoiseGranularity; ++horizontalNoiseX) {
                            int xCoordinate = coordinateX + xNoise * this.horizontalNoiseGranularity + horizontalNoiseX;
                            int xInChunk = xCoordinate & 0xF;
                            double d10 = (double)horizontalNoiseX / (double)this.horizontalNoiseGranularity;
                            double d11 = class_3532.method_16436((double)d10, (double)d6, (double)d7);
                            double d12 = class_3532.method_16436((double)d10, (double)d8, (double)d9);
                            for (int horizontalNoiseZ = 0; horizontalNoiseZ < this.horizontalNoiseGranularity; ++horizontalNoiseZ) {
                                int zCoordinate = coordinateZ + zNoise * this.horizontalNoiseGranularity + horizontalNoiseZ;
                                int zInChunk = zCoordinate & 0xF;
                                double d13 = (double)horizontalNoiseZ / (double)this.horizontalNoiseGranularity;
                                double d14 = class_3532.method_16436((double)d13, (double)d11, (double)d12);
                                double finalTerrainNoise = class_3532.method_15350((double)(d14 / 200.0), (double)-1.0, (double)1.0);
                                class_2680 blockstate = finalTerrainNoise > 0.0 ? this.defaultBlock : (currentY < 40 ? this.defaultFluid : CAVE_AIR);
                                if (blockstate == CAVE_AIR) continue;
                                if (blockstate.method_11630() != 0) {
                                    blockpos$Mutable.method_10103(xCoordinate, currentY, zCoordinate);
                                    protoChunk.method_12315((class_2338)blockpos$Mutable);
                                }
                                chunksection.method_12256(xInChunk, y, zInChunk, blockstate, false);
                                heightmap.method_12597(xInChunk, currentY, zInChunk, blockstate);
                                heightmap1.method_12597(xInChunk, currentY, zInChunk, blockstate);
                            }
                        }
                    }
                }
                chunksection.method_16677();
            }
            double[][] adouble1 = terrainNoise2DArray[0];
            terrainNoise2DArray[0] = terrainNoise2DArray[1];
            terrainNoise2DArray[1] = adouble1;
        }
    }
}

