/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thut.api.TickHandler;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.maths.Matrix3;
import thut.lib.CompatWrapper;

public class BlockEntityUpdater {
    static final Map<Class<? extends TileEntity>, String> tileMap = (Map)ReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"classToNameMap", "field_145853_j", "g"});
    final IBlockEntity blockEntity;
    final Entity theEntity;
    List<AxisAlignedBB> blockBoxes = Lists.newArrayList();
    Set<TileEntity> erroredSet = Sets.newHashSet();

    public static boolean isWhitelisted(TileEntity tile) {
        return IBlockEntity.TEWHITELIST.contains(tileMap.get(tile.getClass()));
    }

    public BlockEntityUpdater(IBlockEntity rocket) {
        this.blockEntity = rocket;
        this.theEntity = (Entity)rocket;
    }

    public void onSetPosition() {
        double xMin = this.theEntity.field_70165_t + (double)this.blockEntity.getMin().func_177958_n() - 0.5;
        double yMin = this.theEntity.field_70163_u + (double)this.blockEntity.getMin().func_177956_o();
        double zMin = this.theEntity.field_70161_v + (double)this.blockEntity.getMin().func_177952_p() - 0.5;
        double xMax = this.theEntity.field_70165_t + (double)this.blockEntity.getMax().func_177958_n() + 0.5;
        double yMax = this.theEntity.field_70163_u + (double)this.blockEntity.getMax().func_177956_o() + 1.0;
        double zMax = this.theEntity.field_70161_v + (double)this.blockEntity.getMax().func_177952_p() + 0.5;
        this.theEntity.func_174826_a(new AxisAlignedBB(xMin, yMin, zMin, xMax, yMax, zMax));
    }

    public void onUpdate() {
        this.theEntity.field_70131_O = this.blockEntity.getMax().func_177956_o();
        this.theEntity.field_70130_N = 1 + this.blockEntity.getMax().func_177958_n() - this.blockEntity.getMin().func_177958_n();
        if (this.theEntity.field_70181_x == 0.0) {
            this.theEntity.func_70107_b(this.theEntity.field_70165_t, (double)Math.round(this.theEntity.field_70163_u), this.theEntity.field_70161_v);
        }
        this.blockEntity.getFakeWorld().func_72912_H().func_82572_b(this.theEntity.field_70170_p.func_82737_E());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int xMin = this.blockEntity.getMin().func_177958_n();
        int zMin = this.blockEntity.getMin().func_177952_p();
        int yMin = this.blockEntity.getMin().func_177956_o();
        int sizeX = this.blockEntity.getTiles().length;
        int sizeY = this.blockEntity.getTiles()[0].length;
        int sizeZ = this.blockEntity.getTiles()[0][0].length;
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    pos.func_189532_c((double)(i + xMin) + this.theEntity.field_70165_t, (double)(j + yMin) + this.theEntity.field_70163_u, (double)(k + zMin) + this.theEntity.field_70161_v);
                    if (this.blockEntity.getTiles()[i][j][k] != null) {
                        this.blockEntity.getTiles()[i][j][k].func_174878_a(pos.func_185334_h());
                        this.blockEntity.getTiles()[i][j][k].func_145834_a((World)this.blockEntity.getFakeWorld());
                    }
                    if (!(this.blockEntity.getTiles()[i][j][k] instanceof ITickable) || this.erroredSet.contains(this.blockEntity.getTiles()[i][j][k]) || !BlockEntityUpdater.isWhitelisted(this.blockEntity.getTiles()[i][j][k])) continue;
                    try {
                        ((ITickable)this.blockEntity.getTiles()[i][j][k]).func_73660_a();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Error with Tile Entity " + this.blockEntity.getTiles()[i][j][k]);
                        this.erroredSet.add(this.blockEntity.getTiles()[i][j][k]);
                    }
                }
            }
        }
    }

    public void applyEntityCollision(Entity entity) {
        if ((this.theEntity.field_70177_z + 360.0f) % 90.0f > 5.0f || this.theEntity.func_184196_w(entity)) {
            return;
        }
        this.blockBoxes.clear();
        int sizeX = this.blockEntity.getBlocks().length;
        int sizeY = this.blockEntity.getBlocks()[0].length;
        int sizeZ = this.blockEntity.getBlocks()[0][0].length;
        HashSet topY = Sets.newHashSet();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int xMin = this.blockEntity.getMin().func_177958_n();
        int yMin = this.blockEntity.getMin().func_177956_o();
        int zMin = this.blockEntity.getMin().func_177952_p();
        BlockPos origin = this.theEntity.func_180425_c();
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    ArrayList toAdd = Lists.newArrayList();
                    pos.func_181079_c(i + xMin + origin.func_177958_n(), j + yMin + origin.func_177956_o(), k + zMin + origin.func_177952_p());
                    IBlockState state = this.blockEntity.getFakeWorld().func_180495_p((BlockPos)pos);
                    try {
                        toAdd.add(state.func_185890_d((World)this.blockEntity.getFakeWorld(), (BlockPos)pos));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (AxisAlignedBB blockBox : toAdd) {
                        if (blockBox == null) continue;
                        float dx = 0.5f;
                        float dz = 0.5f;
                        AxisAlignedBB box = Matrix3.getAABB(this.theEntity.field_70165_t + blockBox.field_72340_a - (double)dx + (double)this.blockEntity.getMin().func_177958_n() + (double)i, this.theEntity.field_70163_u + blockBox.field_72338_b + (double)j, this.theEntity.field_70161_v + blockBox.field_72339_c - (double)dz + (double)this.blockEntity.getMin().func_177952_p() + (double)k, this.theEntity.field_70165_t + blockBox.field_72336_d - (double)dx + (double)this.blockEntity.getMin().func_177958_n() + (double)i, this.theEntity.field_70163_u + blockBox.field_72337_e + (double)j, this.theEntity.field_70161_v + blockBox.field_72334_f - (double)dz + (double)this.blockEntity.getMin().func_177952_p() + (double)k);
                        this.blockBoxes.add(box);
                        topY.add(box.field_72337_e);
                    }
                }
            }
        }
        pos.func_189533_g((Vec3i)this.theEntity.func_180425_c());
        Vector3f temp1 = new Vector3f();
        Vector3f diffs = new Vector3f((float)(this.theEntity.field_70159_w - entity.field_70159_w), (float)(this.theEntity.field_70181_x - entity.field_70181_x), (float)(this.theEntity.field_70181_x - entity.field_70181_x));
        double minX = entity.func_174813_aQ().field_72340_a;
        double minY = entity.func_174813_aQ().field_72338_b;
        double minZ = entity.func_174813_aQ().field_72339_c;
        double maxX = entity.func_174813_aQ().field_72336_d;
        double maxY = entity.func_174813_aQ().field_72337_e;
        double maxZ = entity.func_174813_aQ().field_72334_f;
        double dx = entity.field_70159_w - this.theEntity.field_70159_w;
        double dz = entity.field_70179_y - this.theEntity.field_70179_y;
        double dy = entity.field_70181_x - this.theEntity.field_70181_x;
        if (Math.abs(dx) > 0.5) {
            if (dx > 0.0) {
                maxX += dx;
            } else {
                minX += dx;
            }
        }
        if (Math.abs(dy) > 0.5) {
            if (dy > 0.0) {
                maxY += dy;
            } else {
                minY += dy;
            }
        }
        if (Math.abs(dz) > 0.5) {
            if (dz > 0.0) {
                maxZ += dz;
            } else {
                minZ += dz;
            }
        }
        AxisAlignedBB boundingBox = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        boolean merge = false;
        if (merge) {
            AxisAlignedBB b2;
            int j;
            AxisAlignedBB b1;
            int i;
            double dx1 = 0.0;
            double dy1 = 0.0;
            double dz1 = 0.0;
            Iterator comparator = new Comparator<AxisAlignedBB>(){

                @Override
                public int compare(AxisAlignedBB arg0, AxisAlignedBB arg1) {
                    int minX0 = (int)(arg0.field_72340_a * 32.0);
                    int minY0 = (int)(arg0.field_72338_b * 32.0);
                    int minZ0 = (int)(arg0.field_72339_c * 32.0);
                    int minX1 = (int)(arg1.field_72340_a * 32.0);
                    int minY1 = (int)(arg1.field_72338_b * 32.0);
                    int minZ1 = (int)(arg1.field_72339_c * 32.0);
                    if (minX0 == minX1) {
                        if (minZ0 == minZ1) {
                            return minY0 - minY1;
                        }
                        return minZ0 - minZ1;
                    }
                    return minX0 - minX1;
                }
            };
            AxisAlignedBB[] boxes = this.blockBoxes.toArray(new AxisAlignedBB[this.blockBoxes.size()]);
            this.blockBoxes.clear();
            Arrays.sort(boxes, comparator);
            for (i = 0; i < boxes.length; ++i) {
                b1 = boxes[i];
                if (b1 == null) continue;
                for (j = 0; j < boxes.length; ++j) {
                    b2 = boxes[j];
                    if (i == j || b2 == null || !(Math.abs(b2.field_72337_e - b1.field_72337_e) < dy1) || !(Math.abs(b2.field_72338_b - b1.field_72338_b) < dy1) || !(Math.abs(b2.field_72336_d - b1.field_72336_d) < dx1) || !(Math.abs(b2.field_72340_a - b1.field_72340_a) < dx1) || !(Math.abs(b2.field_72339_c - b1.field_72334_f) < dz1)) continue;
                    boxes[i] = b1 = b1.func_111270_a(b2);
                    boxes[j] = null;
                }
            }
            for (i = 0; i < boxes.length; ++i) {
                b1 = boxes[i];
                if (b1 == null) continue;
                for (j = 0; j < boxes.length; ++j) {
                    b2 = boxes[j];
                    if (i == j || b2 == null || !(Math.abs(b2.field_72337_e - b1.field_72337_e) < dy1) || !(Math.abs(b2.field_72338_b - b1.field_72338_b) < dy1) || !(Math.abs(b2.field_72334_f - b1.field_72334_f) < dz1) || !(Math.abs(b2.field_72339_c - b1.field_72339_c) < dz1) || !(Math.abs(b2.field_72340_a - b1.field_72336_d) < dx1)) continue;
                    boxes[i] = b1 = b1.func_111270_a(b2);
                    boxes[j] = null;
                }
            }
            for (i = 0; i < boxes.length; ++i) {
                b1 = boxes[i];
                if (b1 == null) continue;
                for (j = 0; j < boxes.length; ++j) {
                    b2 = boxes[j];
                    if (i == j || b2 == null || !(Math.abs(b2.field_72336_d - b1.field_72336_d) < dx1) || !(Math.abs(b2.field_72340_a - b1.field_72340_a) < dx1) || !(Math.abs(b2.field_72334_f - b1.field_72334_f) < dz1) || !(Math.abs(b2.field_72339_c - b1.field_72339_c) < dz1) || !(Math.abs(b2.field_72338_b - b1.field_72337_e) < dy1)) continue;
                    boxes[i] = b1 = b1.func_111270_a(b2);
                    boxes[j] = null;
                }
            }
            for (i = 0; i < boxes.length; ++i) {
                b1 = boxes[i];
                if (b1 == null) continue;
                for (j = 0; j < boxes.length; ++j) {
                    b2 = boxes[j];
                    if (i == j || b2 == null || !(b2.field_72336_d <= b1.field_72336_d) || !(b2.field_72337_e <= b1.field_72337_e) || !(b2.field_72334_f <= b1.field_72334_f) || !(b2.field_72340_a >= b1.field_72340_a) || !(b2.field_72338_b >= b1.field_72338_b) || !(b2.field_72339_c >= b1.field_72339_c)) continue;
                    boxes[i] = b1;
                    boxes[j] = null;
                }
            }
            for (AxisAlignedBB b : boxes) {
                if (b == null) continue;
                this.blockBoxes.add(b);
            }
        }
        double yTop = Math.min((double)entity.field_70138_W + entity.field_70163_u + this.theEntity.field_70181_x, maxY);
        boolean floor = false;
        boolean ceiling = false;
        double yMaxFloor = minY;
        for (AxisAlignedBB aabb : this.blockBoxes) {
            double r;
            boolean vert;
            dx = 10000.0;
            dz = 10000.0;
            boolean thisFloor = false;
            boolean thisCieling = false;
            boolean collidesX = maxZ <= aabb.field_72334_f && maxZ >= aabb.field_72339_c || minZ <= aabb.field_72334_f && minZ >= aabb.field_72339_c || minZ <= aabb.field_72339_c && maxZ >= aabb.field_72334_f;
            boolean collidesY = minY >= aabb.field_72338_b && minY <= aabb.field_72337_e || maxY <= aabb.field_72337_e && maxY >= aabb.field_72338_b || minY <= aabb.field_72338_b && maxY >= aabb.field_72337_e;
            boolean collidesZ = maxX <= aabb.field_72336_d && maxX >= aabb.field_72340_a || minX <= aabb.field_72336_d && minX >= aabb.field_72340_a || minX <= aabb.field_72340_a && maxX >= aabb.field_72336_d;
            collidesZ = collidesZ && (collidesX || collidesY);
            boolean bl = collidesX = collidesX && (collidesZ || collidesY);
            if (collidesX && collidesZ && yTop >= aabb.field_72337_e && boundingBox.field_72338_b - (double)entity.field_70138_W - this.theEntity.field_70181_x <= aabb.field_72337_e - (double)diffs.y) {
                if (!floor) {
                    temp1.y = (float)Math.max(aabb.field_72337_e - boundingBox.field_72338_b, (double)temp1.y);
                }
                floor = true;
                boolean bl2 = thisFloor = aabb.field_72337_e >= yMaxFloor;
                if (thisFloor) {
                    yMaxFloor = aabb.field_72337_e;
                }
            }
            if (collidesX && collidesZ && boundingBox.field_72337_e >= aabb.field_72338_b && boundingBox.field_72338_b < aabb.field_72338_b) {
                if (!floor && !ceiling) {
                    dy = aabb.field_72338_b - boundingBox.field_72337_e - (double)diffs.y;
                    temp1.y = (float)Math.min(dy, (double)temp1.y);
                }
                thisCieling = !thisFloor && !floor;
                ceiling = true;
            }
            boolean bl3 = vert = thisFloor || thisCieling;
            if (collidesX && !vert && collidesY && boundingBox.field_72336_d >= aabb.field_72336_d && boundingBox.field_72340_a <= aabb.field_72336_d) {
                r = Math.max(aabb.field_72336_d - boundingBox.field_72340_a, (double)temp1.x);
                dx = Math.min(dx, r);
            }
            if (collidesX && !vert && collidesY && boundingBox.field_72336_d >= aabb.field_72340_a && boundingBox.field_72340_a < aabb.field_72340_a) {
                r = Math.min(aabb.field_72340_a - boundingBox.field_72336_d, (double)temp1.x);
                dx = Math.min(dx, r);
            }
            if (collidesZ && !vert && collidesY && boundingBox.field_72334_f >= aabb.field_72334_f && boundingBox.field_72339_c <= aabb.field_72334_f) {
                r = Math.max(aabb.field_72334_f - boundingBox.field_72339_c, (double)temp1.z);
                dz = Math.min(dz, r);
            }
            if (collidesZ && !vert && collidesY && boundingBox.field_72334_f >= aabb.field_72339_c && boundingBox.field_72339_c < aabb.field_72339_c) {
                r = Math.min(aabb.field_72339_c - boundingBox.field_72334_f, (double)temp1.z);
                dz = Math.min(dz, r);
            }
            if (Math.abs(dx) > Math.abs(dz) && dx < 1000.0 || dx == 10000.0 && dz < 1000.0) {
                temp1.z = (float)dz;
                continue;
            }
            if (!(dx < 1000.0)) continue;
            temp1.x = (float)dx;
        }
        for (Double d : topY) {
            if (!(entity.field_70163_u >= d) || !(entity.field_70163_u + entity.field_70181_x <= d) || !(this.theEntity.field_70181_x <= 0.0)) continue;
            double diff = entity.field_70163_u + entity.field_70181_x - (d + this.theEntity.field_70181_x);
            double check = Math.max(0.5, Math.abs(entity.field_70181_x + this.theEntity.field_70181_x));
            if (!(diff > 0.0) && !(diff < -0.5) && !(Math.abs(diff) > check)) continue;
            entity.field_70181_x = 0.0;
        }
        boolean collidedY = false;
        if (temp1.lengthSquared() > 0.0f) {
            if (temp1.y >= 0.0f) {
                entity.field_70122_E = true;
                entity.field_70143_R = 0.0f;
                entity.func_180430_e(entity.field_70143_R, 0.0f);
            } else if (temp1.y < 0.0f) {
                boolean below;
                boolean bl = below = entity.field_70163_u + (double)entity.field_70131_O - (entity.field_70181_x + this.theEntity.field_70181_x) < this.theEntity.field_70163_u;
                if (below) {
                    temp1.y = 0.0f;
                }
            }
            if (temp1.x != 0.0f) {
                entity.field_70159_w = this.theEntity.field_70159_w;
            }
            if (temp1.y != 0.0f) {
                entity.field_70181_x = this.theEntity.field_70181_x;
            }
            if (temp1.z != 0.0f) {
                entity.field_70179_y = this.theEntity.field_70179_y;
            }
            if (temp1.y != 0.0f) {
                collidedY = true;
            }
            CompatWrapper.moveEntitySelf(entity, temp1.x, temp1.y, temp1.z);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_70170_p.field_72995_K && (Minecraft.func_71410_x().field_71474_y.field_74336_f || TickHandler.playerTickTracker.containsKey(player.func_110124_au()))) {
                TickHandler.playerTickTracker.put(player.func_110124_au(), (int)(System.currentTimeMillis() % 2000L));
                Minecraft.func_71410_x().field_71474_y.field_74336_f = false;
            }
            if (Math.abs(player.field_70181_x) < 0.1 && !player.field_71075_bZ.field_75100_b) {
                entity.field_70122_E = true;
                entity.field_70143_R = 0.0f;
            }
            if (!player.field_71075_bZ.field_75098_d && !player.field_70170_p.field_72995_K) {
                EntityPlayerMP entityplayer = (EntityPlayerMP)player;
                if (collidedY) {
                    entityplayer.field_71135_a.field_147365_f = 0;
                }
            } else if (player.field_70170_p.field_72995_K) {
                // empty if block
            }
        }
    }
}

