/*
 * Decompiled with CFR 0.152.
 */
package thut.api.maths;

import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import thut.api.maths.Cruncher;
import thut.api.maths.Matrix3;
import thut.lib.CompatWrapper;

public class Vector3 {
    public static final Vector3 secondAxis = Vector3.getNewVector().set(0.0, 1.0, 0.0);
    public static final Vector3 secondAxisNeg = Vector3.getNewVector().set(0.0, -1.0, 0.0);
    public static final Vector3 firstAxis = Vector3.getNewVector().set(1.0, 0.0, 0.0);
    public static final Vector3 firstAxisNeg = Vector3.getNewVector().set(-1.0, 0.0, 0.0);
    public static final Vector3 thirdAxis = Vector3.getNewVector().set(0.0, 0.0, 1.0);
    public static final Vector3 thirdAxisNeg = Vector3.getNewVector().set(0.0, 0.0, -1.0);
    public static final Vector3 empty = Vector3.getNewVector();
    public static final int length = 3;
    public static Vector3 vecMult = Vector3.getNewVector();
    public static double[][] rotBox = new double[3][3];
    public static Map<String, Fluid> fluids;
    static Vector3 move1;
    static Vector3 move2;
    public double x;
    public double y;
    public double z;
    MutableBlockPos pos;

    public static Vector3 entity(Entity e) {
        if (e != null) {
            return Vector3.getNewVector().set(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v);
        }
        return null;
    }

    public static Vector3 findMidPoint(List<Vector3> points) {
        Vector3 mid = Vector3.getNewVector();
        for (int j = 0; j < points.size(); ++j) {
            mid.addTo(points.get(j));
        }
        if (points.size() > 0) {
            mid.scalarMultBy(1.0 / (double)points.size());
        }
        return mid;
    }

    public static Vector3 findNextSolidBlock(IBlockAccess worldObj, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        double xprev = source.x;
        double yprev = source.y;
        double zprev = source.z;
        Vector3 test = Vector3.getNewVector();
        for (double i = 0.0; i < range; i += 1.0) {
            double dx = i * direction.x;
            double dy = i * direction.y;
            double dz = i * direction.z;
            double xtest = source.x + dx;
            double ytest = source.y + dy;
            double ztest = source.z + dz;
            if (ytest > 255.0) {
                return null;
            }
            if (Vector3.Int(xtest) != Vector3.Int(xprev) || Vector3.Int(ytest) != Vector3.Int(yprev) || Vector3.Int(ztest) != Vector3.Int(zprev)) {
                test.set(xtest, ytest, ztest);
                boolean clear = test.clearOfBlocks(worldObj);
                if (!clear) {
                    return Vector3.getNewVector().set(Vector3.Int(xtest), Vector3.Int(ytest), Vector3.Int(ztest));
                }
            }
            yprev = ytest;
            xprev = xtest;
            zprev = ztest;
        }
        return null;
    }

    public static Vector3 getNewVector() {
        return new Vector3();
    }

    public static Vector3 getNextSurfacePoint(IBlockAccess worldObj, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        for (double i = 0.0; i < range; i += 0.0625) {
            double dx = i * direction.x;
            double xtest = source.x + dx;
            double dy = i * direction.y;
            double ytest = source.y + dy;
            double dz = i * direction.z;
            double ztest = source.z + dz;
            boolean check = Vector3.isPointClearBlocks(xtest, ytest - dy, ztest - dz, worldObj);
            check = check && Vector3.isPointClearBlocks(xtest - dx, ytest, ztest - dz, worldObj);
            boolean bl = check = check && Vector3.isPointClearBlocks(xtest - dx, ytest - dy, ztest, worldObj);
            if (check) continue;
            return Vector3.getNewVector().set(xtest, ytest, ztest);
        }
        return null;
    }

    public static Vector3 getNextSurfacePoint2(IBlockAccess worldObj, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        Vector3 temp = Vector3.getNewVector();
        for (double i = 0.0; i < range; i += 0.5) {
            double dx = i * direction.x;
            double xtest = source.x + dx;
            double dy = i * direction.y;
            double ytest = source.y + dy;
            double dz = i * direction.z;
            double ztest = source.z + dz;
            boolean check = Vector3.isNotSurfaceBlock((World)worldObj, temp.set(xtest, ytest, ztest));
            if (check) continue;
            return Vector3.getNewVector().set(xtest, ytest, ztest);
        }
        return null;
    }

    public static int Int(double x) {
        return MathHelper.func_76128_c((double)x);
    }

    public static boolean isNotSurfaceBlock(World world, Vector3 v) {
        IBlockState state = v.getBlockState((IBlockAccess)world);
        Block b = state.func_177230_c();
        if (b instanceof IFluidBlock) {
            Fluid f = ((IFluidBlock)b).getFluid();
            return f.getViscosity() < Integer.MAX_VALUE;
        }
        boolean ret = (b == null || v.getBlockMaterial((IBlockAccess)world).func_76222_j() || v.isClearOfBlocks((IBlockAccess)world) || !state.func_185915_l() || b.isLeaves(state, (IBlockAccess)world, v.getPos()) || b.isWood((IBlockAccess)world, v.getPos())) && v.y > 1.0;
        return ret;
    }

    public static boolean isPointClearBlocks(double x, double y, double z, IBlockAccess worldObj) {
        int z0;
        int y0;
        int x0 = MathHelper.func_76128_c((double)x);
        BlockPos pos = new BlockPos(x0, y0 = MathHelper.func_76128_c((double)y), z0 = MathHelper.func_76128_c((double)z));
        IBlockState state = worldObj.func_180495_p(pos);
        if (state == null) {
            return true;
        }
        Block block = state.func_177230_c();
        if (state.func_185915_l()) {
            return false;
        }
        if (block == null || block == Blocks.field_150350_a || !block.func_149703_v()) {
            return true;
        }
        ArrayList aabbs = new ArrayList();
        Vector3 v = Vector3.getNewVector().set(x, y, z);
        if (worldObj instanceof World) {
            state.func_185908_a((World)worldObj, pos, v.getAABB().func_72314_b(0.03, 0.03, 0.03), aabbs, null);
        }
        if (aabbs.size() == 0) {
            return true;
        }
        for (AxisAlignedBB aabb : aabbs) {
            if (aabb == null) continue;
            if (y <= aabb.field_72337_e && y >= aabb.field_72338_b) {
                return false;
            }
            if (z <= aabb.field_72334_f && z >= aabb.field_72339_c) {
                return false;
            }
            if (!(x <= aabb.field_72336_d) || !(x >= aabb.field_72340_a)) continue;
            return false;
        }
        return true;
    }

    public static boolean isVisibleEntityFromEntity(Entity looker, Entity target) {
        if (looker == null || target == null) {
            return false;
        }
        return looker.field_70170_p.func_147447_a(new Vec3d(looker.field_70165_t, looker.field_70163_u + (double)looker.func_70047_e(), looker.field_70161_v), new Vec3d(target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v), false, true, false) == null;
    }

    public static boolean isVisibleRange(IBlockAccess worldObj, Vector3 source, Vector3 direction, double range) {
        direction = direction.normalize();
        if (worldObj instanceof World) {
            direction.scalarMultBy(range).addTo(source);
            return ((World)worldObj).func_147447_a(new Vec3d(source.x, source.y, source.z), new Vec3d(direction.x, direction.y, direction.z), false, true, false) == null;
        }
        for (double i = 0.0; i < range; i += 0.0625) {
            double dx = i * direction.x;
            double xtest = source.x + dx;
            double dy = i * direction.y;
            double ytest = source.y + dy;
            double dz = i * direction.z;
            double ztest = source.z + dz;
            boolean check = Vector3.isPointClearBlocks(xtest, ytest, ztest, worldObj);
            if (check) continue;
            return false;
        }
        return true;
    }

    public static boolean movePointOutOfBlocks(Vector3 v, World world) {
        Vector3 v1 = move1.set(v);
        Vector3 v2 = move2.set(v);
        long start = System.nanoTime();
        if (!v.clearOfBlocks((IBlockAccess)world)) {
            long end;
            double time;
            int n = 0;
            block0: while (!v.clearOfBlocks((IBlockAccess)world)) {
                for (EnumFacing side : EnumFacing.values()) {
                    v2.set(v);
                    if (v.offsetBy(side).clearOfBlocks((IBlockAccess)world)) break block0;
                    v.set(v2);
                }
                boolean step = true;
                if (n < 2) {
                    v.offset(EnumFacing.UP);
                } else if (n < 4) {
                    if (step) {
                        step = false;
                        v.set(v1);
                    }
                    v.offsetBy(EnumFacing.NORTH);
                } else if (n < 6) {
                    if (!step) {
                        step = true;
                        v.set(v1);
                    }
                    v.offsetBy(EnumFacing.SOUTH);
                } else if (n < 8) {
                    if (step) {
                        step = false;
                        v.set(v1);
                    }
                    v.offsetBy(EnumFacing.EAST);
                } else if (n < 10) {
                    if (!step) {
                        step = true;
                        v.set(v1);
                    }
                    v.offsetBy(EnumFacing.WEST);
                } else if (n < 12) {
                    if (step) {
                        step = false;
                        v.set(v1);
                    }
                    v.offsetBy(EnumFacing.DOWN);
                }
                if (++n < 12) continue;
                break;
            }
            if ((time = (double)(end = System.nanoTime() - start) / 1.0E9) > 0.001) {
                System.out.println("Took " + time + "s to check");
            }
            return v.clearOfBlocks((IBlockAccess)world);
        }
        return true;
    }

    public static Vector3 readFromBuff(ByteBuf dat) {
        Vector3 ret = Vector3.getNewVector();
        ret.x = dat.readDouble();
        ret.y = dat.readDouble();
        ret.z = dat.readDouble();
        return ret;
    }

    public static Vector3 readFromNBT(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag + "x")) {
            return null;
        }
        Vector3 ret = Vector3.getNewVector();
        ret.x = nbt.func_74769_h(tag + "x");
        ret.y = nbt.func_74769_h(tag + "y");
        ret.z = nbt.func_74769_h(tag + "z");
        return ret;
    }

    public static void rotateAboutAngles(Vector3[] points, double pitch, double yaw, Vector3 temp, Vector3 temp1) {
        for (int i = 0; i < points.length; ++i) {
            points[i] = points[i].rotateAboutAngles(pitch, yaw, temp, temp1);
        }
    }

    public static double vectorDot(Vector3 vector1, Vector3 vector2) {
        double dot = 0.0;
        for (int i = 0; i < 3; ++i) {
            dot += vector1.get(i) * vector2.get(i);
        }
        return dot;
    }

    private Vector3() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    private Vector3(double pitch, double yaw) {
        this.x = 1.0;
        this.y = Math.toRadians(pitch);
        this.z = Math.toRadians(yaw);
    }

    private Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private Vector3(Entity e, boolean bool) {
        if (e != null && bool) {
            this.x = e.field_70165_t;
            this.y = e.field_70163_u + (double)(e.field_70131_O / 2.0f);
            this.z = e.field_70161_v;
        } else if (e != null) {
            this.x = e.field_70165_t;
            this.y = e.field_70163_u + (double)e.func_70047_e();
            this.z = e.field_70161_v;
        }
    }

    private Vector3(Object a) {
        this();
        this.set(a);
    }

    private Vector3(Object a, Object b) {
        this();
        Vector3 A = Vector3.getNewVector().set(a);
        Vector3 B = Vector3.getNewVector().set(b);
        this.set(B.subtract(A));
    }

    private Vector3(Vec3d vec) {
        this.x = vec.field_72450_a;
        this.y = vec.field_72448_b;
        this.z = vec.field_72449_c;
    }

    public Vector3 add(double i, double j, double k) {
        return Vector3.getNewVector().set(this.x + i, j + this.y, k + this.z);
    }

    public void add(int i, double j) {
        if (i == 0) {
            this.x += j;
        } else if (i == 1) {
            this.y += j;
        } else if (i == 2) {
            this.z += j;
        }
    }

    public Vector3 add(Vector3 vectorB) {
        Vector3 vectorC = Vector3.getNewVector();
        for (int i = 0; i < 3; ++i) {
            vectorC.set(i, this.get(i) + vectorB.get(i));
        }
        return vectorC;
    }

    public Vector3 addTo(double i, double j, double k) {
        this.x += i;
        this.y += j;
        this.z += k;
        return this;
    }

    public Vector3 addTo(Vector3 b) {
        if (b == null) {
            return this;
        }
        this.x += b.x;
        this.y += b.y;
        this.z += b.z;
        return this;
    }

    public void addVelocities(Entity e) {
        e.func_70024_g(this.x, this.y, this.z);
    }

    public List<Entity> allEntityLocationExcluding(int range, double size, Vector3 direction, Vector3 source, World worldObj, Entity excluded) {
        double dz;
        double ztest;
        double dy;
        double ytest;
        double dx;
        double xtest;
        boolean check;
        direction = direction.normalize();
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (double i = 0.0; i < (double)range && (check = Vector3.isPointClearBlocks(xtest = source.x + (dx = i * direction.x), ytest = source.y + (dy = i * direction.y), ztest = source.z + (dz = i * direction.z), (IBlockAccess)worldObj)); i += size) {
            double x0 = xtest;
            double y0 = ytest;
            double z0 = ztest;
            List targets = worldObj.func_72839_b(excluded, new AxisAlignedBB(x0 - size, y0 - size, z0 - size, x0 + size, y0 + size, z0 + size));
            if (targets == null || targets.size() <= 0) continue;
            for (Entity e : targets) {
                if (!(e instanceof EntityLivingBase) || ret.contains(e) || e.func_184215_y(excluded)) continue;
                ret.add(e);
            }
        }
        return ret;
    }

    public int blockCount(IBlockAccess world, Block block, int range) {
        int ret = 0;
        Vector3 v = this.copy();
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    Vector3 test = v.set(this).addTo(i, j, k);
                    if (test.getBlock(world) != block) continue;
                    ++ret;
                }
            }
        }
        return ret;
    }

    public int blockCount2(World world, Block block, int range) {
        int ret = 0;
        Vector3 v = this.copy();
        Chunk chunk = world.func_175726_f(new BlockPos(this.intX(), 0, this.intZ()));
        for (int i = -range / 2; i <= range / 2; ++i) {
            for (int j = -range / 2; j <= range / 2; ++j) {
                for (int k = -range / 2; k <= range / 2; ++k) {
                    int i1 = MathHelper.func_76128_c((double)((double)this.intX() / 16.0));
                    int k1 = MathHelper.func_76128_c((double)((double)this.intZ() / 16.0));
                    int j1 = MathHelper.func_76128_c((double)((double)this.intY() / 16.0));
                    int i2 = MathHelper.func_76128_c((double)((double)(this.intX() + i) / 16.0));
                    int k2 = MathHelper.func_76128_c((double)((double)(this.intZ() + k) / 16.0));
                    int j2 = MathHelper.func_76128_c((double)((double)(this.intY() + j) / 16.0));
                    if (i1 != i2 || k1 != k2 || j1 != j2) continue;
                    v.set(this);
                    Vector3 test = v.addTo(i, j, k);
                    Block testBlock = chunk.func_186032_a(test.intX(), test.intY(), test.intZ()).func_177230_c();
                    if (testBlock != block) continue;
                    ++ret;
                }
            }
        }
        return ret;
    }

    public void breakBlock(World worldObj, boolean drop) {
        if (this.getBlock((IBlockAccess)worldObj) != null) {
            worldObj.func_175655_b(this.getPos(), drop);
        }
    }

    public void breakBlock(World worldObj, int fortune, boolean drop) {
        if (this.getBlock((IBlockAccess)worldObj) != null) {
            if (drop) {
                this.getBlock((IBlockAccess)worldObj).func_176226_b(worldObj, this.getPos(), this.getBlockState((IBlockAccess)worldObj), fortune);
            }
            worldObj.func_175655_b(this.getPos(), false);
        }
    }

    public boolean canSeeSky(IBlockAccess world) {
        return (double)this.getTopBlockY(world) <= this.y;
    }

    public Vector3 clear() {
        return this.set(0.0, 0.0, 0.0);
    }

    public boolean clearOfBlocks(IBlockAccess worldMap) {
        IBlockState state = this.getBlockState(worldMap);
        if (state == null) {
            return true;
        }
        Block block = state.func_177230_c();
        if (state.func_185915_l()) {
            return false;
        }
        if (block == null || block == Blocks.field_150350_a || !state.func_185904_a().func_76230_c() || !block.func_149703_v()) {
            return true;
        }
        ArrayList<AxisAlignedBB> aabbs = new ArrayList<AxisAlignedBB>();
        aabbs.add(state.func_185900_c(worldMap, this.getPos()));
        if (aabbs.size() == 0) {
            return true;
        }
        for (AxisAlignedBB aabb : aabbs) {
            if (aabb == null) continue;
            if (this.y <= aabb.field_72337_e && this.y >= aabb.field_72338_b) {
                return false;
            }
            if (this.z <= aabb.field_72334_f && this.z >= aabb.field_72339_c) {
                return false;
            }
            if (!(this.x <= aabb.field_72336_d) || !(this.x >= aabb.field_72340_a)) continue;
            return false;
        }
        return true;
    }

    public Vector3 copy() {
        Vector3 newVector = Vector3.getNewVector().set(this.x, this.y, this.z);
        return newVector;
    }

    public double distanceTo(Vector3 vec) {
        return this.subtract(vec).mag();
    }

    public double distTo(Vector3 pointB) {
        return this.subtract(pointB).mag();
    }

    public double distToEntity(Entity e) {
        return this.distanceTo(Vector3.entity(e));
    }

    public double distToSq(Vector3 pointB) {
        return this.subtract(pointB).magSq();
    }

    public boolean doChunksExist(World world, int distance) {
        return world.func_175697_a(this.getPos(), distance);
    }

    public double dot(Vector3 vector2) {
        double dot = 0.0;
        for (int i = 0; i < 3; ++i) {
            dot += this.get(i) * vector2.get(i);
        }
        return dot;
    }

    public boolean equals(Object vec) {
        if (!(vec instanceof Vector3)) {
            return false;
        }
        Vector3 v = (Vector3)vec;
        return v.x == this.x && v.y == this.y && v.z == this.z;
    }

    public Vector3 findClosestVisibleObject(IBlockAccess world, boolean water, int sightDistance, Object matching) {
        int size = Math.min(sightDistance, 30);
        ArrayList list = new ArrayList();
        Block seekingBlock = null;
        Class seekingClass = null;
        boolean predicate = matching instanceof Predicate;
        Predicate matcher = null;
        if (predicate) {
            matcher = (Predicate)matching;
        }
        boolean isInterface = false;
        boolean blockList = false;
        boolean predicateList = false;
        Vector3 temp = Vector3.getNewVector();
        if (matching instanceof Block) {
            seekingBlock = (Block)matching;
        }
        if (matching instanceof Class && (seekingClass = (Class)matching).isInterface()) {
            isInterface = true;
        }
        if (matching instanceof Collection && ((Collection)matching).toArray()[0] instanceof Block) {
            blockList = true;
            list.addAll((Collection)matching);
        }
        if (matching instanceof Collection && ((Collection)matching).toArray()[0] instanceof Predicate) {
            predicateList = true;
            list.addAll((Collection)matching);
        }
        Vector3 r = Vector3.getNewVector();
        Vector3 rAbs = Vector3.getNewVector();
        Vector3 rHat = Vector3.getNewVector();
        Vector3 rTest = Vector3.getNewVector();
        Vector3 rTestPrev = Vector3.getNewVector();
        Vector3 rTestAbs = Vector3.getNewVector();
        Vector3 ret = Vector3.getNewVector();
        HashMap interfaces = new HashMap();
        block0: for (int i = 0; i < size * size * size; ++i) {
            Cruncher.indexToVals(i, r);
            rAbs.set(r).addTo(this);
            rHat.set(temp.set(r).norm());
            double rm = r.mag();
            if (rm > (double)size || rm > (double)sightDistance || rAbs.isAir(world) && !r.isEmpty()) continue;
            rTest.clear();
            rTestPrev.clear();
            double rMag = r.mag();
            float dj = 1.0f;
            float j = 0.0f;
            while ((double)j <= rMag) {
                rTest = temp.set(rHat).scalarMultBy(j);
                if (!rTest.sameBlock(rTestPrev)) {
                    rTestAbs.set(rTest).addTo(this);
                    IBlockState state = rTestAbs.getBlockState(world);
                    if (state == null) continue block0;
                    Block b = state.func_177230_c();
                    if (predicateList) {
                        for (Object o : list) {
                            if (!((Predicate)o).apply((Object)state)) continue;
                            ret.set(rTestAbs);
                            return ret;
                        }
                    }
                    if (isInterface) {
                        ArrayList tempList = (ArrayList)interfaces.get(b.getClass());
                        if (tempList == null) {
                            tempList = new ArrayList();
                            interfaces.put(b.getClass(), tempList);
                            for (Class<?> o : b.getClass().getInterfaces()) {
                                tempList.add(o);
                            }
                        }
                        list = tempList;
                    }
                    if (matcher != null && matcher.apply((Object)state)) {
                        ret.set(rTestAbs);
                        return ret;
                    }
                    if (seekingBlock != null && b == seekingBlock) {
                        ret.set(rTestAbs);
                        return ret;
                    }
                    if (!isInterface && seekingClass != null && b.getClass().isAssignableFrom(seekingClass)) {
                        ret.set(rTestAbs);
                        return ret;
                    }
                    if (seekingClass != null && list.contains(seekingClass)) {
                        ret.set(rTestAbs);
                        return ret;
                    }
                    if (blockList && list.contains(b)) {
                        ret.set(rTestAbs);
                        return ret;
                    }
                    if (!rTestAbs.isClearOfBlocks(world) || !water && state.func_185904_a() == Material.field_151586_h) continue block0;
                }
                j += dj;
            }
        }
        return null;
    }

    public Vector3 findNextSolidBlock(IBlockAccess worldObj, Vector3 direction, double range) {
        return Vector3.findNextSolidBlock(worldObj, this, direction, range);
    }

    public Entity firstEntityExcluding(double range, Vector3 direction, World worldObj, boolean effect, Entity excluded) {
        ArrayList<Entity> toExclude = new ArrayList<Entity>();
        if (excluded != null) {
            toExclude.add(excluded);
            toExclude.addAll(excluded.func_184182_bu());
        }
        return this.firstEntityExcluding(range, direction, worldObj, effect, toExclude);
    }

    public Entity firstEntityExcluding(double range, Vector3 direction, World worldObj, boolean effect, List<Entity> excluded) {
        double dz;
        double ztest;
        double dy;
        double ytest;
        double dx;
        double xtest;
        boolean check;
        direction = direction.normalize();
        double xprev = this.x;
        double yprev = this.y;
        double zprev = this.z;
        for (double i = 0.0; i < range && (check = Vector3.isPointClearBlocks(xtest = this.x + (dx = i * direction.x), ytest = this.y + (dy = i * direction.y), ztest = this.z + (dz = i * direction.z), (IBlockAccess)worldObj)); i += 0.0625) {
            int z0;
            int y0;
            int x0;
            List targets;
            if (effect && worldObj.field_72995_K) {
                worldObj.func_175688_a(EnumParticleTypes.TOWN_AURA, xtest, ytest, ztest, 0.0, 0.0, 0.0, new int[0]);
            }
            if (((int)xtest != (int)xprev || (int)ytest != (int)yprev || (int)ztest != (int)zprev) && (targets = worldObj.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)(x0 = xtest > 0.0 ? (int)xtest : (int)xtest - 1) - 0.5, (double)(y0 = ytest > 0.0 ? (int)ytest : (int)ytest - 1) - 0.5, (double)(z0 = ztest > 0.0 ? (int)ztest : (int)ztest - 1) - 0.5, (double)x0 + 0.5, (double)y0 + 0.5, (double)z0 + 0.5))) != null && targets.size() > 0) {
                ArrayList<Entity> ret = new ArrayList<Entity>();
                for (Entity e : targets) {
                    if (!(e instanceof EntityLivingBase) || excluded.contains(e)) continue;
                    ret.add(e);
                }
                if (ret.size() > 0) {
                    return (Entity)ret.get(0);
                }
            }
            yprev = ytest;
            xprev = xtest;
            zprev = ztest;
        }
        return null;
    }

    public List<Entity> firstEntityLocationExcluding(int range, double size, Vector3 direction, Vector3 source, World worldObj, Entity excluded) {
        double dz;
        double ztest;
        double dy;
        double ytest;
        double dx;
        double xtest;
        boolean check;
        direction = direction.normalize();
        for (double i = 0.0; i < (double)range && (check = Vector3.isPointClearBlocks(xtest = source.x + (dx = i * direction.x), ytest = source.y + (dy = i * direction.y), ztest = source.z + (dz = i * direction.z), (IBlockAccess)worldObj)); i += 0.0625) {
            double z0;
            double y0;
            double x0 = xtest > 0.0 ? (int)xtest : (int)xtest - 1;
            List targets = worldObj.func_72839_b(excluded, new AxisAlignedBB(x0 - size, (y0 = (double)(ytest > 0.0 ? (int)ytest : (int)ytest - 1)) - size, (z0 = (double)(ztest > 0.0 ? (int)ztest : (int)ztest - 1)) - size, x0 + size, y0 + size, z0 + size));
            if (targets == null || targets.size() <= 0) continue;
            ArrayList<Entity> ret = new ArrayList<Entity>();
            for (Entity e : targets) {
                if (!(e instanceof EntityLiving)) continue;
                ret.add(e);
            }
            if (ret.size() <= 0) continue;
            return ret;
        }
        return null;
    }

    public double get(int i) {
        assert (i < 3);
        return i == 0 ? this.x : (i == 1 ? this.y : this.z);
    }

    public AxisAlignedBB getAABB() {
        return Matrix3.getAABB(this.x, this.y, this.z, this.x, this.y, this.z);
    }

    public Biome getBiome(Chunk chunk, BiomeProvider mngr) {
        return chunk.func_177411_a(new BlockPos(this.intX() & 0xF, 0, this.intZ() & 0xF), mngr);
    }

    public Biome getBiome(World worldObj) {
        return worldObj.func_180494_b(new BlockPos(this.intX(), 0, this.intZ()));
    }

    public int getBiomeID(World worldObj) {
        return Biome.func_185362_a((Biome)this.getBiome(worldObj));
    }

    public Block getBlock(IBlockAccess worldMap) {
        IBlockState state = worldMap.func_180495_p(this.getPos());
        if (state == null) {
            return Blocks.field_150350_a;
        }
        return state.func_177230_c();
    }

    public Block getBlock(IBlockAccess worldObj, EnumFacing side) {
        Vector3 other = this.offset(side);
        Block ret = other.getBlock(worldObj);
        return ret;
    }

    public int getBlockId(IBlockAccess worldObj) {
        return Block.func_149682_b((Block)worldObj.func_180495_p(this.getPos()).func_177230_c());
    }

    public Material getBlockMaterial(IBlockAccess worldObj) {
        IBlockState state = worldObj.func_180495_p(this.getPos());
        if (state == null || state.func_177230_c() == null) {
            return Material.field_151579_a;
        }
        return state.func_185904_a();
    }

    public int getBlockMetadata(IBlockAccess worldObj) {
        IBlockState state = worldObj.func_180495_p(this.getPos());
        Block b = state.func_177230_c();
        return b.func_176201_c(state);
    }

    public IBlockState getBlockState(IBlockAccess world) {
        return world.func_180495_p(this.getPos());
    }

    public float getExplosionResistance(Explosion boom, IBlockAccess world) {
        IBlockState state = this.getBlockState(world);
        if (state == null) {
            return 0.0f;
        }
        Block block = state.func_177230_c();
        if (block != null && !block.isAir(state, world, this.getPos())) {
            return block.func_149638_a((Entity)boom.func_94613_c());
        }
        return 0.0f;
    }

    public int getLightValue(World world) {
        return world.func_175699_k(this.getPos());
    }

    public int getMaxY(World world) {
        return this.getMaxY(world, this.intX(), this.intZ());
    }

    public int getMaxY(World world, int x, int z) {
        IBlockState state;
        int y;
        Vector3 temp = Vector3.getNewVector().set(x, this.y, z);
        Chunk chunk = world.func_175726_f(this.getPos());
        for (y = chunk.func_177433_f(this.getPos()); !(y <= 5 || (state = world.func_180495_p(new BlockPos(this.intX(), y, this.intZ()))) != null && state.func_185904_a().func_76220_a()); --y) {
        }
        if (Vector3.Int(y) == this.intY()) {
            return y;
        }
        while (Vector3.isNotSurfaceBlock(world, temp)) {
            temp.y = --y;
        }
        return y;
    }

    public int[] getMinMaxY(World world, int range) {
        int[] ret = new int[2];
        int minY = 255;
        int maxY = 0;
        for (int i = 0; i < range; ++i) {
            for (int j = 0; j < range; ++j) {
                if (this.getMaxY(world, this.intX() + i, this.intZ() + j) < minY) {
                    minY = this.getMaxY(world, this.intX() + i, this.intZ() + j);
                }
                if (this.getMaxY(world, this.intX() + i, this.intZ() + j) <= maxY) continue;
                maxY = this.getMaxY(world, this.intX() + i, this.intZ() + j);
            }
        }
        ret[0] = minY;
        ret[1] = maxY;
        return ret;
    }

    public BlockPos getPos() {
        if (this.pos == null) {
            this.pos = new MutableBlockPos(this.intX(), this.intY(), this.intZ());
        } else {
            this.pos.setTo(this);
        }
        return this.pos;
    }

    public TileEntity getTileEntity(IBlockAccess worldObj) {
        return worldObj.func_175625_s(this.getPos());
    }

    public TileEntity getTileEntity(IBlockAccess worldObj, EnumFacing side) {
        Vector3 other = this.offset(side);
        TileEntity ret = other.getTileEntity(worldObj);
        return ret;
    }

    public Vector3 getTopBlockPos(World world) {
        int y = this.getTopBlockY((IBlockAccess)world);
        return Vector3.getNewVector().set(this.intX(), y, this.intZ());
    }

    public int getTopBlockY(IBlockAccess world) {
        int ret = 255;
        for (ret = 255; ret > 1; --ret) {
            IBlockState state = world.func_180495_p(new BlockPos(this.intX(), ret, this.intZ()));
            if (state == null || !state.func_185904_a().func_76220_a()) continue;
            return ret;
        }
        return ret;
    }

    public Vector3 horizonalPerp() {
        Vector3 vectorH = Vector3.getNewVector().set(-this.z, 0.0, this.x);
        return vectorH.norm();
    }

    public boolean inAABB(AxisAlignedBB aabb) {
        if (this.y >= aabb.field_72337_e || this.y <= aabb.field_72338_b) {
            return false;
        }
        if (this.z >= aabb.field_72334_f || this.z <= aabb.field_72339_c) {
            return false;
        }
        return !(this.x >= aabb.field_72336_d) && !(this.x <= aabb.field_72340_a);
    }

    public boolean inMatBox(Matrix3 box) {
        Vector3 min = box.get(0);
        Vector3 max = box.get(1);
        boolean ycheck = false;
        boolean xcheck = false;
        boolean zcheck = false;
        if (this.y <= max.y && this.y >= min.y) {
            ycheck = true;
        }
        if (this.z <= max.z && this.z >= min.z) {
            zcheck = true;
        }
        if (this.x <= max.x && this.x >= min.x) {
            xcheck = true;
        }
        return ycheck && zcheck && xcheck;
    }

    public int intX() {
        return MathHelper.func_76128_c((double)this.x);
    }

    public int intY() {
        return MathHelper.func_76128_c((double)this.y);
    }

    public int intZ() {
        return MathHelper.func_76128_c((double)this.z);
    }

    public boolean isAir(IBlockAccess worldObj) {
        if (worldObj instanceof World) {
            Material m;
            IBlockState state = worldObj.func_180495_p(this.getPos());
            return state.func_177230_c() == null || (m = this.getBlockMaterial(worldObj)) == null || m == Material.field_151579_a || state.func_177230_c().isAir(state, worldObj, this.getPos());
        }
        Material m = this.getBlockMaterial(worldObj);
        return m == null || m == Material.field_151579_a;
    }

    public boolean isClearOfBlocks(IBlockAccess worldObj) {
        boolean ret = false;
        IBlockState state = worldObj.func_180495_p(this.getPos());
        if (state == null) {
            return true;
        }
        ret = this.isAir(worldObj);
        if (!ret) {
            boolean bl = ret = ret || this.getBlockMaterial(worldObj).func_76224_d();
        }
        if (!ret) {
            boolean bl = ret = ret || this.getBlockMaterial(worldObj).func_76222_j();
        }
        if (!ret) {
            boolean bl = ret = ret || !this.getBlockMaterial(worldObj).func_76230_c();
        }
        if (!ret) {
            ret = Vector3.isPointClearBlocks(this.x, this.y, this.z, worldObj);
        }
        return ret;
    }

    public boolean isEmpty() {
        return this.x == 0.0 && this.z == 0.0 && this.y == 0.0;
    }

    public boolean isEntityClearOfBlocks(IBlockAccess worldObj, Entity e) {
        int j;
        int i;
        boolean ret = false;
        Vector3 v = Vector3.getNewVector();
        Vector3 v1 = Vector3.getNewVector();
        v.set(this);
        ret = v.addTo(v1.set(0.0, e.field_70131_O, 0.0)).isClearOfBlocks(worldObj);
        if (!ret) {
            return ret;
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                ret = ret && v.set(this).addTo(v1.set((float)i * e.field_70130_N / 2.0f, 0.0, (float)j * e.field_70130_N / 2.0f)).isClearOfBlocks(worldObj);
            }
        }
        if (!ret) {
            return ret;
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                ret = ret && v.set(this).addTo(v1.set((float)i * e.field_70130_N / 2.0f, e.field_70131_O, (float)j * e.field_70130_N / 2.0f)).isClearOfBlocks(worldObj);
            }
        }
        return ret;
    }

    public boolean isFluid(World world) {
        return FluidRegistry.lookupFluidForBlock((Block)this.getBlock((IBlockAccess)world)) != null;
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.z) || Double.isNaN(this.y);
    }

    public boolean isOnSurface(Chunk chunk) {
        return (double)chunk.func_76611_b(this.intX() & 0xF, this.intZ() & 0xF) <= this.y;
    }

    public boolean isOnSurface(World world) {
        return (double)this.getMaxY(world) <= this.y;
    }

    public boolean isOnSurfaceIgnoringDecorationAndWater(Chunk chunk, IBlockAccess world) {
        int h = chunk.func_76611_b(this.intX() & 0xF, this.intZ() & 0xF);
        if ((double)h <= this.y) {
            return true;
        }
        int i = h;
        while ((double)i > this.y) {
            Material m = world.func_180495_p(new BlockPos(this.intX(), i, this.intZ())).func_185904_a();
            if (m != Material.field_151586_h && m != Material.field_151579_a && m != Material.field_151584_j && m != Material.field_151575_d) {
                return false;
            }
            --i;
        }
        return true;
    }

    public boolean isPointClearOfEntity(double x, double y, double z, Entity e) {
        AxisAlignedBB aabb = e.func_174813_aQ();
        if (y <= aabb.field_72337_e && y >= aabb.field_72338_b) {
            return false;
        }
        if (z <= aabb.field_72334_f && z >= aabb.field_72339_c) {
            return false;
        }
        return !(x <= aabb.field_72336_d) || !(x >= aabb.field_72340_a);
    }

    public boolean isSideSolid(IBlockAccess worldObj, EnumFacing side) {
        boolean ret = worldObj.isSideSolid(this.getPos(), side, false);
        return ret;
    }

    public boolean isVisible(IBlockAccess world, Vector3 location) {
        Vector3 direction = location.subtract(this);
        double range = direction.mag();
        return Vector3.isVisibleRange(world, this, direction, range);
    }

    public List<Entity> livingEntityAtPoint(World worldObj) {
        int x0 = this.intX();
        int y0 = this.intY();
        int z0 = this.intZ();
        ArrayList<Entity> ret = new ArrayList<Entity>();
        List targets = worldObj.func_72872_a(EntityLiving.class, new AxisAlignedBB((double)x0, (double)y0, (double)z0, (double)(x0 + 1), (double)(y0 + 1), (double)(z0 + 1)));
        for (Entity e : targets) {
            if (this.isPointClearOfEntity(this.x, this.y, this.z, e)) continue;
            ret.add(e);
        }
        return ret;
    }

    public List<Entity> livingEntityAtPointExcludingEntity(World worldObj, Entity entity) {
        int x0 = this.intX();
        int y0 = this.intY();
        int z0 = this.intZ();
        ArrayList<Entity> ret = new ArrayList<Entity>();
        List targets = worldObj.func_72872_a(EntityLiving.class, new AxisAlignedBB((double)x0, (double)y0, (double)z0, (double)(x0 + 1), (double)(y0 + 1), (double)(z0 + 1)));
        for (Entity e : targets) {
            if (this.isPointClearOfEntity(this.x, this.y, this.z, e) || e == entity) continue;
            ret.add(e);
        }
        return ret;
    }

    public double mag() {
        double vmag = Math.sqrt(this.magSq());
        return vmag;
    }

    public double magSq() {
        double vmag = 0.0;
        for (int i = 0; i < 3; ++i) {
            vmag += this.get(i) * this.get(i);
        }
        return vmag;
    }

    public Vector3 matrixMult(Matrix3 Matrix) {
        Vector3 newVect = vecMult.clear();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                newVect.add(i, Matrix.get(i).get(j) * this.get(j));
            }
        }
        return newVect;
    }

    public void moveEntity(Entity e) {
        e.func_70107_b(this.x, this.y, this.z);
    }

    public Vector3 norm() {
        double vmag = this.mag();
        if (vmag == 0.0) {
            return this.clear();
        }
        this.scalarMultBy(1.0 / vmag);
        return this;
    }

    public Vector3 normalize() {
        double vmag = this.mag();
        Vector3 vHat = Vector3.getNewVector();
        if (vmag == 0.0) {
            return vHat.clear();
        }
        vHat.set(this).scalarMultBy(1.0 / vmag);
        return vHat;
    }

    public Vector3 offset(EnumFacing side) {
        return this.add(Vector3.getNewVector().set(side));
    }

    public Vector3 offsetBy(EnumFacing side) {
        return this.addTo(side.func_82601_c(), side.func_96559_d(), side.func_82599_e());
    }

    public Vector3 reverse() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3 rotateAboutAngles(double pitch, double yaw, Vector3 temp, Vector3 temp1) {
        if (this.isEmpty() || pitch == 0.0 && yaw == 0.0) {
            return this;
        }
        temp.set(this);
        if (yaw != 0.0) {
            this.rotateAboutLine(secondAxis, yaw, temp);
        }
        if (pitch != 0.0) {
            this.rotateAboutLine(this.horizonalPerp(), pitch, temp);
        }
        if (temp.isNaN()) {
            return temp.clear();
        }
        return temp;
    }

    public Vector3 rotateAboutLine(Vector3 line, double angle, Vector3 ret) {
        if (line.magSq() != 1.0) {
            line = line.normalize();
        }
        if (ret == null) {
            ret = Vector3.getNewVector();
        }
        double[][] mat = rotBox;
        mat[0][0] = line.get(0) * line.get(0) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + (double)MathHelper.func_76134_b((float)((float)angle));
        mat[0][1] = line.get(0) * line.get(1) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) - line.get(2) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[0][2] = line.get(0) * line.get(2) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + line.get(1) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[1][0] = line.get(1) * line.get(0) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + line.get(2) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[1][1] = line.get(1) * line.get(1) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + (double)MathHelper.func_76134_b((float)((float)angle));
        mat[1][2] = line.get(1) * line.get(2) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) - line.get(0) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[2][0] = line.get(2) * line.get(0) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) - line.get(1) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[2][1] = line.get(2) * line.get(1) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + line.get(0) * (double)MathHelper.func_76126_a((float)((float)angle));
        mat[2][2] = line.get(2) * line.get(2) * (double)(1.0f - MathHelper.func_76134_b((float)((float)angle))) + (double)MathHelper.func_76134_b((float)((float)angle));
        ret.x = mat[0][0] * this.x + mat[0][1] * this.y + mat[0][2] * this.z;
        ret.y = mat[1][0] * this.x + mat[1][1] * this.y + mat[1][2] * this.z;
        ret.z = mat[2][0] * this.x + mat[2][1] * this.y + mat[2][2] * this.z;
        return ret;
    }

    public boolean sameBlock(Vector3 vec) {
        return this.intX() == vec.intX() && this.intY() == vec.intY() && this.intZ() == vec.intZ();
    }

    public Vector3 scalarMult(double constant) {
        Vector3 newVector = Vector3.getNewVector();
        for (int i = 0; i < 3; ++i) {
            newVector.set(i, constant * this.get(i));
        }
        return newVector;
    }

    public Vector3 scalarMultBy(double i) {
        this.x *= i;
        this.y *= i;
        this.z *= i;
        return this;
    }

    public Vector3 set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3 set(double[] vec) {
        this.x = vec[0];
        this.y = vec[1];
        this.z = vec[2];
        return this;
    }

    public Vector3 set(Entity e, boolean b) {
        if (e != null && b) {
            this.x = e.field_70165_t;
            this.y = e.field_70163_u + (double)(e.field_70131_O / 2.0f);
            this.z = e.field_70161_v;
        } else if (e != null) {
            this.x = e.field_70165_t;
            this.y = e.field_70163_u + (double)e.func_70047_e();
            this.z = e.field_70161_v;
        }
        return this;
    }

    public Vector3 set(EnumFacing dir) {
        this.x = dir.func_82601_c();
        this.y = dir.func_96559_d();
        this.z = dir.func_82599_e();
        return this;
    }

    public void set(int i, double j) {
        if (i == 0) {
            this.x = j;
        } else if (i == 1) {
            this.y = j;
        } else if (i == 2) {
            this.z = j;
        }
    }

    public Vector3 set(Object o) {
        if (o instanceof Entity) {
            Entity e = (Entity)o;
            this.set(e.field_70165_t, e.field_70163_u, e.field_70161_v);
        } else if (o instanceof TileEntity) {
            TileEntity te = (TileEntity)o;
            this.set(te.func_174877_v());
        } else if (o instanceof double[]) {
            double[] d = (double[])o;
            this.set(d[0], d[1], d[2]);
        } else if (o instanceof EnumFacing) {
            EnumFacing side = (EnumFacing)o;
            this.set(side.func_82601_c(), side.func_96559_d(), side.func_82599_e());
        } else if (o instanceof Vector3) {
            this.set((Vector3)o);
        } else if (o instanceof BlockPos) {
            BlockPos c = (BlockPos)o;
            this.set(c.func_177958_n(), c.func_177956_o(), c.func_177952_p());
        } else if (o instanceof ICommandSender) {
            ICommandSender c = (ICommandSender)o;
            this.set(c.func_180425_c());
        } else if (o instanceof PathPoint) {
            PathPoint p = (PathPoint)o;
            this.set(p.field_75839_a, p.field_75837_b, p.field_75838_c);
        } else if (o instanceof Vec3d) {
            Vec3d p = (Vec3d)o;
            this.set(p.field_72450_a, p.field_72448_b, p.field_72449_c);
        } else if (o instanceof int[]) {
            int[] p = (int[])o;
            this.set(p[0], p[1], p[2]);
        } else if (o instanceof Double) {
            this.y = this.z = ((Double)o).doubleValue();
            this.x = this.z;
        }
        return this;
    }

    public Vector3 set(Vector3 vec) {
        if (vec != null) {
            this.x = vec.x;
            this.y = vec.y;
            this.z = vec.z;
        }
        return this;
    }

    public void setAir(World worldObj) {
        worldObj.func_175698_g(this.getPos());
    }

    public void setBiome(Biome biome, World worldObj) {
        int chunkZ;
        int x = this.intX();
        int z = this.intZ();
        Chunk chunk = worldObj.func_175726_f(new BlockPos(x, 0, z));
        byte[] biomes = chunk.func_76605_m();
        byte newBiome = (byte)Biome.func_185362_a((Biome)biome);
        int chunkX = Math.abs(x & 0xF);
        int point = chunkX + 16 * (chunkZ = Math.abs(z & 0xF));
        if (biomes[point] != newBiome) {
            biomes[point] = newBiome;
            chunk.func_76616_a(biomes);
            chunk.func_76630_e();
        }
    }

    public boolean setBlock(World worldObj, Block id) {
        return this.setBlock(worldObj, id, 0, 3);
    }

    public boolean setBlock(World worldObj, Block id, int meta) {
        return this.setBlock(worldObj, id, meta, 3);
    }

    public boolean setBlock(World worldObj, Block id, int meta, int flag) {
        if (this.doChunksExist(worldObj, 1)) {
            worldObj.func_180501_a(this.getPos(), CompatWrapper.getBlockStateFromMeta(id, meta), flag);
            return true;
        }
        return false;
    }

    public void setBlock(World world, IBlockState defaultState) {
        world.func_175656_a(this.getPos(), defaultState);
    }

    public boolean setBlockId(World worldObj, int id, int meta, int flag) {
        return this.setBlock(worldObj, Block.func_149729_e((int)id), meta, flag);
    }

    public Vector3 setToVelocity(Entity e) {
        this.set(e.field_70159_w, e.field_70181_x, e.field_70179_y);
        return this;
    }

    public void setVelocities(Entity e) {
        e.field_70159_w = this.x;
        e.field_70181_x = this.y;
        e.field_70179_y = this.z;
    }

    public Vector3 subtract(Vector3 vectorB) {
        Vector3 vectorC = Vector3.getNewVector();
        for (int i = 0; i < 3; ++i) {
            vectorC.set(i, this.get(i) - vectorB.get(i));
        }
        return vectorC;
    }

    public Vector3 subtractFrom(Vector3 b) {
        if (b == null) {
            return this;
        }
        this.x -= b.x;
        this.y -= b.y;
        this.z -= b.z;
        return this;
    }

    public Vector3 toSpherical() {
        Vector3 vectorSpher = Vector3.getNewVector();
        vectorSpher.x = this.mag();
        vectorSpher.y = Math.acos(this.get(1) / vectorSpher.x) - 1.5707963267948966;
        vectorSpher.z = Math.atan2(this.get(2), this.x);
        return vectorSpher;
    }

    public String toString() {
        return "x:" + this.x + " y:" + this.y + " z:" + this.z;
    }

    public void writeToBuff(ByteBuf data) {
        data.writeDouble(this.x);
        data.writeDouble(this.y);
        data.writeDouble(this.z);
    }

    public void writeToNBT(NBTTagCompound nbt, String tag) {
        nbt.func_74780_a(tag + "x", this.x);
        nbt.func_74780_a(tag + "y", this.y);
        nbt.func_74780_a(tag + "z", this.z);
    }

    public int hashCode() {
        return super.hashCode();
    }

    static {
        move1 = Vector3.getNewVector();
        move2 = Vector3.getNewVector();
    }

    public static final class MutableBlockPos
    extends BlockPos {
        public int field_177962_a;
        public int field_177960_b;
        public int field_177961_c;

        public MutableBlockPos(int x_, int y_, int z_) {
            super(0, 0, 0);
            this.field_177962_a = x_;
            this.field_177960_b = y_;
            this.field_177961_c = z_;
        }

        MutableBlockPos(int p_i46025_1_, int p_i46025_2_, int p_i46025_3_, Object p_i46025_4_) {
            this(p_i46025_1_, p_i46025_2_, p_i46025_3_);
        }

        public BlockPos func_177955_d(Vec3i vec) {
            return super.func_177955_d(vec);
        }

        public int func_177958_n() {
            return this.field_177962_a;
        }

        public int func_177956_o() {
            return this.field_177960_b;
        }

        public int func_177952_p() {
            return this.field_177961_c;
        }

        void setTo(Vector3 vector) {
            this.field_177962_a = vector.intX();
            this.field_177960_b = vector.intY();
            this.field_177961_c = vector.intZ();
        }
    }
}

