/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import java.util.HashMap;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import thut.api.maths.Vector3;
import thut.api.terrain.BiomeType;
import thut.lib.CompatWrapper;

public class BiomeDatabase {
    public static HashMap<Biome, BiomeDictionary.Type[]> biomeTypes = new HashMap();

    public static boolean contains(Biome b, BiomeDictionary.Type type) {
        return CompatWrapper.isOfType(b, type);
    }

    public static BiomeType getBiome(Biome b) {
        if (b != null && b.func_185359_l().toLowerCase(Locale.ENGLISH).contains("flower")) {
            return BiomeType.FLOWER;
        }
        return BiomeType.NONE;
    }

    public static Biome getBiome(String name) {
        return (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(name));
    }

    public static String getBiome(World world, Vector3 v) {
        int type = v.getBiomeID(world);
        return BiomeDatabase.getNameFromType(type);
    }

    public static String getBiome(World world, Vector3 v, boolean checkIndandVillage) {
        Village village;
        String ret = "";
        if (checkIndandVillage && (village = world.field_72982_D.func_176056_a(new BlockPos(MathHelper.func_76128_c((double)v.intX()), MathHelper.func_76128_c((double)v.intY()), MathHelper.func_76128_c((double)v.intZ())), 2)) != null) {
            return "village";
        }
        Biome biome = v.getBiome(world);
        ret = BiomeDatabase.getBiome((Biome)biome).name;
        return ret;
    }

    public static int getBiomeType(Biome biome) {
        return Biome.func_185362_a((Biome)biome);
    }

    public static int getBiomeType(String name) {
        for (BiomeType b : BiomeType.values()) {
            if (!b.name.equalsIgnoreCase(name)) continue;
            return (byte)b.getType();
        }
        for (ResourceLocation key : Biome.field_185377_q.func_148742_b()) {
            Biome b = (Biome)Biome.field_185377_q.func_82594_a((Object)key);
            if (b == null || !b.func_185359_l().equalsIgnoreCase(name)) continue;
            return BiomeDatabase.getBiomeType(b);
        }
        return BiomeType.NONE.getType();
    }

    public static String getNameFromType(int type) {
        if (type > 255) {
            return BiomeType.getType((int)type).name;
        }
        if (Biome.func_150568_d((int)type) != null) {
            return Biome.func_150568_d((int)type).func_185359_l();
        }
        return "none";
    }

    public static String getReadableNameFromType(int type) {
        if (type > 255) {
            return BiomeType.getType((int)type).readableName;
        }
        if (Biome.func_150568_d((int)type) != null) {
            return Biome.func_150568_d((int)type).func_185359_l();
        }
        return "None " + type;
    }
}

