/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.smd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import thut.core.client.render.smd.SMDModel;
import thut.core.client.render.smd.Skeleton;
import thut.core.client.render.smd.SkeletonAnimation;
import thut.core.client.render.smd.Triangles;

public class SMDParser {
    public SMDModel model;

    public SMDParser(File model) {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(model);
            this.parseModel(stream);
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
        }
    }

    public void parseAnimation(InputStream stream, String name) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = reader.readLine();
        Skeleton skelly = this.model.skeleton;
        SkeletonAnimation anim = new SkeletonAnimation(skelly);
        anim.animationName = name;
        SkeletonAnimation.SkeletonFrame currentFrame = null;
        String section = "";
        boolean end = true;
        while ((line = reader.readLine()) != null) {
            if (end) {
                section = line;
                end = false;
                continue;
            }
            if (line.equals("end")) {
                end = true;
                continue;
            }
            if (!section.equals("skeleton")) continue;
            if (line.contains("time")) {
                currentFrame = new SkeletonAnimation.SkeletonFrame(Integer.parseInt(line.split(" ")[1].trim()), anim);
                anim.frames.add(currentFrame);
                continue;
            }
            currentFrame.addFromLine(line);
        }
        this.model.poses.put(name, anim);
    }

    public SMDModel parseModel(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        this.model = new SMDModel();
        String line = reader.readLine();
        Skeleton skelly = null;
        SkeletonAnimation.SkeletonFrame currentFrame = null;
        SkeletonAnimation pose = null;
        String section = "";
        Triangles.Triangle currentTriangle = null;
        Triangles triangles = null;
        boolean end = true;
        while ((line = reader.readLine()) != null) {
            if (end) {
                section = line;
                end = false;
                continue;
            }
            if (line.equals("end")) {
                end = true;
                continue;
            }
            if (section.equals("nodes")) {
                if (skelly == null) {
                    this.model.skeleton = skelly = new Skeleton(this.model);
                    triangles = new Triangles(this.model);
                }
                Skeleton.Bone bone = new Skeleton.Bone(line, skelly);
                skelly.addBone(bone);
                continue;
            }
            if (section.equals("skeleton")) {
                if (pose == null) {
                    pose = new SkeletonAnimation(skelly);
                    pose.animationName = "default";
                    this.model.poses.put("default", pose);
                }
                if (line.contains("time")) {
                    currentFrame = new SkeletonAnimation.SkeletonFrame(Integer.parseInt(line.split(" ")[1].trim()), pose);
                    pose.frames.add(currentFrame);
                    continue;
                }
                currentFrame.addFromLine(line);
                continue;
            }
            if (!section.equals("triangles")) continue;
            line = line.replaceAll("\\s+", " ");
            String[] args = line.split(" ");
            boolean test = false;
            try {
                Integer.parseInt(args[0]);
                test = true;
                currentTriangle.addVertex(line);
            }
            catch (NumberFormatException e) {
                if (test) continue;
                currentTriangle = new Triangles.Triangle(line, triangles);
                triangles.triangles.add(currentTriangle);
            }
        }
        this.model.triangles = triangles;
        skelly.init();
        skelly.setPose(pose);
        return this.model;
    }
}

