/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.smd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.smd.SMDModel;
import thut.core.client.render.smd.SkeletonAnimation;

public class Skeleton {
    public HashMap<Integer, Bone> boneMap = new HashMap();
    public final SMDModel model;
    public SkeletonAnimation pose;
    public Bone root;

    public static void ensureIndex(ArrayList<?> a, int i) {
        while (a.size() <= i) {
            a.add(null);
        }
    }

    public Skeleton(SMDModel model) {
        this.model = model;
    }

    public void addBone(Bone bone) {
        if (this.boneMap.containsKey(bone.id)) {
            throw new IllegalArgumentException("Already has bone of id " + bone.id);
        }
        this.boneMap.put(bone.id, bone);
    }

    public void applyChange() {
        for (Bone b : this.boneMap.values()) {
            for (BoneVertex v : b.vertices.keySet()) {
                v.applyDeformation();
            }
        }
    }

    public void applyPose() {
        if (this.pose.lastPoseChange == this.pose.currentIndex) {
            return;
        }
        this.pose.lastPoseChange = this.pose.currentIndex;
        this.reset();
        this.root.deform();
        this.root.applyDeform();
        this.applyChange();
    }

    public Bone getBone(int id) {
        return this.boneMap.get(id);
    }

    public void init() {
        for (Bone bone : this.boneMap.values()) {
            Bone parent;
            if (bone.parentId == -1) continue;
            bone.parent = parent = this.boneMap.get(bone.parentId);
            parent.children.add(bone);
        }
        for (Bone b : this.boneMap.values()) {
            if (b.parent != null || b.children.isEmpty()) continue;
            this.root = b;
        }
    }

    private void initPose() {
        System.out.println(this.pose.animationName + " " + this.pose.frames.size());
        SkeletonAnimation.SkeletonFrame frame = this.pose.frames.get(0);
        this.pose.reset();
        this.pose.precalculateAnimation();
        for (Integer i : frame.positions.keySet()) {
            Matrix4f trans = frame.positions.get(i);
            Bone bone = this.boneMap.get(i);
            bone.setRest(trans);
        }
        this.root.reformChildren();
        for (Bone b : this.boneMap.values()) {
            b.invertRestMatrix();
        }
        this.pose.reform();
    }

    public void reset() {
        for (Bone b : this.boneMap.values()) {
            b.reset();
            for (BoneVertex v : b.vertices.keySet()) {
                v.reset();
            }
        }
    }

    public void setPose(SkeletonAnimation pose) {
        if (this.pose == pose) {
            return;
        }
        this.pose = pose;
        this.initPose();
    }

    public static class BoneVertex
    extends Vertex {
        private final Vector4f originalPos;
        public Vector4f positionDeform = new Vector4f();
        private final Vector4f originalNormal;
        public Vector4f normalDeform = new Vector4f();
        public final int id;
        public float xn;
        public float yn;
        public float zn;

        public BoneVertex(float x, float y, float z, float xn, float yn, float zn, int id) {
            super(x, y, z);
            this.xn = xn;
            this.yn = yn;
            this.zn = zn;
            this.id = id;
            this.originalPos = new Vector4f(x, y, z, 1.0f);
            this.originalNormal = new Vector4f(xn, yn, zn, 0.0f);
        }

        public void applyDeformation() {
            if (this.positionDeform == null) {
                this.x = this.originalPos.x;
                this.y = this.originalPos.y;
                this.z = this.originalPos.z;
            } else {
                this.x = this.positionDeform.x;
                this.y = this.positionDeform.y;
                this.z = this.positionDeform.z;
            }
            if (this.normalDeform == null) {
                this.xn = this.originalNormal.x;
                this.yn = this.originalNormal.y;
                this.zn = this.originalNormal.z;
            } else {
                this.xn = this.normalDeform.x;
                this.yn = this.normalDeform.y;
                this.zn = this.normalDeform.z;
            }
        }

        public void applyTransform(Matrix4f transform, float weight) {
            if (transform != null) {
                this.positionDeform = new Vector4f();
                this.normalDeform = new Vector4f();
                Vector4f loc = Matrix4f.transform((Matrix4f)transform, (Vector4f)this.originalPos, null);
                Vector4f normal = Matrix4f.transform((Matrix4f)transform, (Vector4f)this.originalNormal, null);
                loc.scale(weight);
                normal.scale(weight);
                Vector4f.add((Vector4f)loc, (Vector4f)this.positionDeform, (Vector4f)this.positionDeform);
                Vector4f.add((Vector4f)normal, (Vector4f)this.normalDeform, (Vector4f)this.normalDeform);
                Matrix4f.transform((Matrix4f)transform, (Vector4f)this.originalPos, (Vector4f)this.positionDeform);
                Matrix4f.transform((Matrix4f)transform, (Vector4f)this.originalNormal, (Vector4f)this.normalDeform);
            }
        }

        public void reset() {
            this.positionDeform = null;
            this.normalDeform = null;
        }

        public String toString() {
            return this.id + ":" + this.x + "," + this.y + "," + this.z;
        }
    }

    public static class Bone {
        public final int id;
        public final int parentId;
        final String name;
        public final HashSet<Bone> children = new HashSet();
        public final HashMap<BoneVertex, Float> vertices = new HashMap();
        public Matrix4f rest = new Matrix4f();
        public Matrix4f restInverse = new Matrix4f();
        public Matrix4f deform = new Matrix4f();
        public Matrix4f deformInverse = new Matrix4f();
        public HashMap<String, ArrayList<Matrix4f>> animatedTransforms = new HashMap();
        public Bone parent;
        final Skeleton skeleton;

        public Bone(int id, int parentId, String name, Skeleton skeleton) {
            this.skeleton = skeleton;
            this.id = id;
            this.parentId = parentId;
            this.name = name;
        }

        public Bone(String line, Skeleton skeleton) {
            this.skeleton = skeleton;
            String[] args = this.parse(line);
            this.id = Integer.parseInt(args[0]);
            this.name = args[1];
            this.parentId = Integer.parseInt(args[2]);
        }

        public void applyDeform() {
            for (BoneVertex v : this.vertices.keySet()) {
                v.applyTransform(this.deform, this.vertices.get(v).floatValue());
            }
            for (Bone b : this.children) {
                b.applyDeform();
            }
        }

        public void clear() {
            this.reset();
            this.restInverse.setIdentity();
            this.rest.setIdentity();
            this.animatedTransforms.clear();
            for (Bone b : this.children) {
                b.clear();
            }
        }

        public void deform() {
            SkeletonAnimation animation = this.skeleton.pose;
            if (animation != null) {
                ArrayList<Matrix4f> precalc = this.animatedTransforms.get(animation.animationName);
                Matrix4f animated = precalc.get(animation.currentIndex);
                Matrix4f dAnimated = Matrix4f.mul((Matrix4f)animated, (Matrix4f)this.restInverse, null);
                Matrix4f.mul((Matrix4f)this.deform, (Matrix4f)dAnimated, (Matrix4f)this.deform);
                Matrix4f.invert((Matrix4f)this.deform, (Matrix4f)this.deformInverse);
            }
            for (Bone b : this.children) {
                b.deform();
            }
        }

        public void invertRestMatrix() {
            this.restInverse = Matrix4f.invert((Matrix4f)this.rest, null);
        }

        String[] parse(String line) {
            String[] ret = new String[3];
            int indexQuoteStart = line.indexOf("\"");
            int indexQuoteEnd = line.lastIndexOf("\"");
            ret[0] = line.substring(0, indexQuoteStart - 1);
            ret[1] = line.substring(indexQuoteStart + 1, indexQuoteEnd);
            ret[2] = line.substring(indexQuoteEnd + 2);
            return ret;
        }

        public void preloadAnimation(SkeletonAnimation.SkeletonFrame key, Matrix4f animated) {
            ArrayList<Object> transforms = this.animatedTransforms.containsKey(key.animation.animationName) ? this.animatedTransforms.get(key.animation.animationName) : new ArrayList();
            Skeleton.ensureIndex(transforms, key.time);
            transforms.set(key.time, animated);
            this.animatedTransforms.put(key.animation.animationName, transforms);
        }

        private void reform(Matrix4f parentMatrix) {
            this.rest = Matrix4f.mul((Matrix4f)parentMatrix, (Matrix4f)this.rest, null);
            this.reformChildren();
        }

        public void reformChildren() {
            for (Bone child : this.children) {
                child.reform(this.rest);
            }
        }

        public void reset() {
            this.deform.setIdentity();
            this.deformInverse.setIdentity();
        }

        public void setRest(Matrix4f resting) {
            this.rest = resting;
        }

        public String toString() {
            return this.id + " " + this.name + " " + this.parentId;
        }
    }
}

