/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.x3d;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.lwjgl.opengl.GL11;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.model.IAnimationChanger;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IPartTexturer;
import thut.core.client.render.model.IRetexturableModel;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.x3d.Shape;

public class X3dObject
implements IExtendedModelPart,
IRetexturableModel {
    public int GLMODE = 4;
    public List<Shape> shapes = Lists.newArrayList();
    public HashMap<String, IExtendedModelPart> childParts = new HashMap();
    public final String name;
    public IExtendedModelPart parent = null;
    IPartTexturer texturer;
    IAnimationChanger changer;
    public Vector4 preRot = new Vector4();
    public Vector4 postRot = new Vector4();
    public Vector4 postRot1 = new Vector4();
    public Vector3 preTrans = Vector3.getNewVector();
    public Vector3 postTrans = Vector3.getNewVector();
    public Vertex preScale = new Vertex(1.0f, 1.0f, 1.0f);
    public Vector3 offset = Vector3.getNewVector();
    public Vector4 rotations = new Vector4();
    public Vertex scale = new Vertex(1.0f, 1.0f, 1.0f);
    public int red = 255;
    public int green = 255;
    public int blue = 255;
    public int alpha = 255;
    public int brightness = 0xF00000;

    public X3dObject(String name) {
        this.name = name;
    }

    @Override
    public void addChild(IExtendedModelPart subPart) {
        this.childParts.put(subPart.getName(), subPart);
        subPart.setParent(this);
    }

    public void addForRender() {
        GL11.glColor4f((float)((float)this.red / 255.0f), (float)((float)this.green / 255.0f), (float)((float)this.blue / 255.0f), (float)((float)this.alpha / 255.0f));
        for (Shape s : this.shapes) {
            s.renderShape(this.texturer);
        }
    }

    @Override
    public Vector4 getDefaultRotations() {
        return this.rotations;
    }

    @Override
    public Vector3 getDefaultTranslations() {
        return this.offset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IExtendedModelPart getParent() {
        return this.parent;
    }

    @Override
    public int[] getRGBAB() {
        return new int[]{this.red, this.green, this.blue, this.alpha, this.brightness};
    }

    @Override
    public HashMap<String, IExtendedModelPart> getSubParts() {
        return this.childParts;
    }

    @Override
    public String getType() {
        return "x3d";
    }

    public void render() {
        this.preRender();
        this.addForRender();
        this.postRender();
    }

    private void postRender() {
        GL11.glPopMatrix();
    }

    private void preRender() {
        this.rotateToParent();
        GL11.glTranslated((double)this.offset.x, (double)this.offset.y, (double)this.offset.z);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)this.preTrans.x, (double)this.preTrans.y, (double)this.preTrans.z);
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.rotations.glRotate();
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.preRot.glRotate();
        GL11.glTranslated((double)this.postTrans.x, (double)this.postTrans.y, (double)this.postTrans.z);
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)(-this.offset.x), (double)(-this.offset.y), (double)(-this.offset.z));
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.offset.x, (double)this.offset.y, (double)this.offset.z);
        this.postRot.glRotate();
        this.postRot1.glRotate();
        GL11.glScalef((float)this.scale.x, (float)this.scale.y, (float)this.scale.z);
    }

    @Override
    public void renderAll() {
        GL11.glScalef((float)this.preScale.x, (float)this.preScale.y, (float)this.preScale.z);
        this.render();
        for (IExtendedModelPart o : this.childParts.values()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)this.offset.x, (double)this.offset.y, (double)this.offset.z);
            GL11.glScalef((float)this.scale.x, (float)this.scale.y, (float)this.scale.z);
            o.renderAll();
            GL11.glPopMatrix();
        }
    }

    @Override
    public void renderAllExcept(String ... excludedGroupNames) {
        boolean rendered = false;
        for (String s1 : excludedGroupNames) {
            rendered = s1.equalsIgnoreCase(this.name);
            if (!rendered) continue;
            this.render();
            break;
        }
        if (!rendered) {
            this.preRender();
            this.postRender();
        }
        for (IExtendedModelPart o : this.childParts.values()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)this.offset.x, (double)this.offset.y, (double)this.offset.z);
            GL11.glScalef((float)this.scale.x, (float)this.scale.y, (float)this.scale.z);
            o.renderAllExcept(excludedGroupNames);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void renderOnly(String ... groupNames) {
        boolean rendered = false;
        for (String s1 : groupNames) {
            rendered = s1.equalsIgnoreCase(this.name);
            if (!rendered) continue;
            this.render();
            break;
        }
        if (!rendered) {
            this.preRender();
            this.postRender();
        }
        for (IExtendedModelPart o : this.childParts.values()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)this.offset.x, (double)this.offset.y, (double)this.offset.z);
            GL11.glScalef((float)this.scale.x, (float)this.scale.y, (float)this.scale.z);
            o.renderOnly(groupNames);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void renderPart(String partName) {
        this.renderOnly(partName);
    }

    @Override
    public void resetToInit() {
        this.preRot.set(0.0f, 1.0f, 0.0f, 0.0f);
        this.postRot.set(0.0f, 1.0f, 0.0f, 0.0f);
        this.postRot1.set(0.0f, 1.0f, 0.0f, 0.0f);
        this.preTrans.clear();
        this.postTrans.clear();
    }

    private void rotateToParent() {
        if (this.parent != null && this.parent instanceof X3dObject) {
            X3dObject parent = (X3dObject)this.parent;
            parent.postRot.glRotate();
            parent.postRot1.glRotate();
        }
    }

    @Override
    public void setAnimationChanger(IAnimationChanger changer) {
        this.changer = changer;
        for (IExtendedModelPart part : this.childParts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setAnimationChanger(changer);
        }
    }

    @Override
    public void setParent(IExtendedModelPart parent) {
        this.parent = parent;
    }

    @Override
    public void setPostRotations(Vector4 angles) {
        this.postRot = angles;
    }

    @Override
    public void setPostRotations2(Vector4 rotations) {
        this.postRot1 = rotations;
    }

    @Override
    public void setPostTranslations(Vector3 point) {
        this.postTrans.set(point);
    }

    @Override
    public void setPreRotations(Vector4 angles) {
        this.preRot = angles;
    }

    @Override
    public void setPreTranslations(Vector3 point) {
        this.preTrans.set(point);
    }

    @Override
    public void setRGBAB(int[] array) {
        this.red = array[0];
        this.blue = array[1];
        this.green = array[2];
        this.alpha = array[3];
        this.brightness = array[4];
    }

    @Override
    public void setTexturer(IPartTexturer texturer) {
        this.texturer = texturer;
        for (IExtendedModelPart part : this.childParts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setTexturer(texturer);
        }
    }

    @Override
    public void setPreScale(Vector3 scale) {
        this.preScale.x = (float)scale.x;
        this.preScale.y = (float)scale.y;
        this.preScale.z = (float)scale.z;
    }
}

