/*
 * Decompiled with CFR 0.152.
 */
package thut.lib;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CompatWrapper {
    public static final ItemStack nullStack = null;

    public static ItemStack fromTag(NBTTagCompound tag) {
        return ItemStack.func_77949_a((NBTTagCompound)tag);
    }

    public static ItemStack copy(ItemStack in) {
        return ItemStack.func_77944_b((ItemStack)in);
    }

    public static Entity createEntity(World world, String in) {
        return EntityList.func_188429_b((String)in, (World)world);
    }

    public static Entity createEntity(World world, ResourceLocation in) {
        return EntityList.func_188429_b((String)in.toString(), (World)world);
    }

    public static Entity createEntity(World world, Entity in) {
        return EntityList.func_188429_b((String)EntityList.func_75621_b((Entity)in), (World)world);
    }

    public static void moveEntitySelf(Entity in, double x, double y, double z) {
        in.func_70091_d(x, y, z);
    }

    public static void sendChatMessage(ICommandSender to, ITextComponent message) {
        to.func_145747_a(message);
    }

    public static void registerTileEntity(Class<? extends TileEntity> tileClass, String id) {
        GameRegistry.registerTileEntity(tileClass, (String)id);
    }

    public static void registerModEntity(Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public static ItemStack setStackSize(ItemStack stack, int amount) {
        if (amount <= 0) {
            stack.field_77994_a = 0;
            return nullStack;
        }
        stack.field_77994_a = amount;
        return stack;
    }

    public static int getStackSize(ItemStack stack) {
        if (stack == nullStack || stack.field_77994_a < 0 || stack.func_77973_b() == null) {
            return 0;
        }
        return stack.field_77994_a;
    }

    public static boolean isValid(ItemStack stack) {
        return CompatWrapper.getStackSize(stack) > 0;
    }

    public static ItemStack validate(ItemStack in) {
        if (!CompatWrapper.isValid(in)) {
            return nullStack;
        }
        return in;
    }

    public static void setAnimationToGo(ItemStack stack, int num) {
        stack.field_77992_b = num;
    }

    public static int increment(ItemStack in, int amt) {
        in.field_77994_a += amt;
        return in.field_77994_a;
    }

    public static List<ItemStack> makeList(int size) {
        ArrayList ret = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            ret.add(nullStack);
        }
        return ret;
    }

    public static void rightClickWith(ItemStack stack, EntityPlayer player, EnumHand hand) {
        stack.func_77973_b().func_77659_a(stack, player.field_70170_p, player, hand);
    }

    public static NBTTagCompound getTag(ItemStack stack, String name, boolean create) {
        return stack.func_179543_a(name, create);
    }

    public static void processInitialInteract(Entity in, EntityPlayer player, EnumHand hand, ItemStack stack) {
        in.func_184230_a(player, stack, hand);
    }

    public static boolean interactWithBlock(Block block, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return block.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public static EntityList.EntityEggInfo getEggInfo(String name, int colour1, int colour2) {
        return new EntityList.EntityEggInfo(name, colour1, colour2);
    }

    public static IBlockState getBlockStateFromMeta(Block block, int meta) {
        return block.func_176203_a(meta);
    }

    public static BiomeDictionary.Type getBiomeType(String name) {
        try {
            return BiomeDictionary.Type.valueOf((String)name.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isOfType(Biome biome, BiomeDictionary.Type type) {
        return BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)type);
    }

    public static Set<BiomeDictionary.Type> getTypes(Biome biome) {
        return Sets.newHashSet((Object[])BiomeDictionary.getTypesForBiome((Biome)biome));
    }

    public static Set<Biome> getBiomes(BiomeDictionary.Type type) {
        return Sets.newHashSet((Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type));
    }
}

