/*
 * Decompiled with CFR 0.152.
 */
package thut.lib;

import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;
import thut.lib.CompatWrapper;

public class ItemStackTools {
    public static boolean addItemStackToInventory(ItemStack itemStackIn, IInventory toAddTo, int minIndex) {
        if (CompatWrapper.isValid(itemStackIn)) {
            try {
                int i;
                int num;
                int size;
                if (itemStackIn.func_77951_h()) {
                    int j = ItemStackTools.getFirstEmptyStack(toAddTo, minIndex);
                    if (j >= 0) {
                        toAddTo.func_70299_a(j, CompatWrapper.copy(itemStackIn));
                        CompatWrapper.setAnimationToGo(toAddTo.func_70301_a(j), 5);
                        CompatWrapper.setStackSize(itemStackIn, 0);
                        return true;
                    }
                    return false;
                }
                do {
                    i = CompatWrapper.getStackSize(itemStackIn);
                } while ((size = CompatWrapper.getStackSize(itemStackIn = CompatWrapper.setStackSize(itemStackIn, num = ItemStackTools.storePartialItemStack(itemStackIn, toAddTo, minIndex)))) > 0 && size < i);
                return CompatWrapper.getStackSize(itemStackIn) < i;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Adding item to inventory");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being added");
                crashreportcategory.func_71507_a("Item ID", (Object)Item.func_150891_b((Item)itemStackIn.func_77973_b()));
                crashreportcategory.func_71507_a("Item data", (Object)itemStackIn.func_77960_j());
                throw new ReportedException(crashreport);
            }
        }
        return false;
    }

    private static boolean canMergeStacks(ItemStack stack1, ItemStack stack2) {
        return CompatWrapper.isValid(stack1) && ItemStackTools.stackEqualExact(stack1, stack2) && stack1.func_77985_e() && CompatWrapper.getStackSize(stack1) < stack1.func_77976_d() && CompatWrapper.getStackSize(stack1) < 64;
    }

    private static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static int getFirstEmptyStack(IInventory inventory, int minIndex) {
        for (int i = minIndex; i < inventory.func_70302_i_(); ++i) {
            if (CompatWrapper.isValid(inventory.func_70301_a(i))) continue;
            return i;
        }
        return -1;
    }

    private static int storeItemStack(ItemStack itemStackIn, IInventory inventory, int minIndex) {
        for (int i = minIndex; i < inventory.func_70302_i_(); ++i) {
            if (!ItemStackTools.canMergeStacks(inventory.func_70301_a(i), itemStackIn)) continue;
            return i;
        }
        return -1;
    }

    private static int storePartialItemStack(ItemStack itemStackIn, IInventory inventory, int minIndex) {
        int i = CompatWrapper.getStackSize(itemStackIn);
        int j = ItemStackTools.storeItemStack(itemStackIn, inventory, minIndex);
        if (j < 0) {
            j = ItemStackTools.getFirstEmptyStack(inventory, minIndex);
        }
        if (j < 0) {
            return i;
        }
        ItemStack itemstack = inventory.func_70301_a(j);
        if (!CompatWrapper.isValid(itemstack)) {
            itemstack = itemStackIn.func_77946_l();
            CompatWrapper.setStackSize(itemstack, 0);
            if (itemStackIn.func_77942_o()) {
                itemstack.func_77982_d((NBTTagCompound)itemStackIn.func_77978_p().func_74737_b());
            }
            inventory.func_70299_a(j, itemstack);
        }
        int k = i;
        int size = CompatWrapper.getStackSize(inventory.func_70301_a(j));
        if (i > inventory.func_70301_a(j).func_77976_d() - size) {
            k = inventory.func_70301_a(j).func_77976_d() - size;
        }
        if (k > inventory.func_70297_j_() - size) {
            k = inventory.func_70297_j_() - size;
        }
        if (k == 0) {
            return i;
        }
        CompatWrapper.setStackSize(inventory.func_70301_a(j), size + k);
        CompatWrapper.setAnimationToGo(inventory.func_70301_a(j), 5);
        return i -= k;
    }
}

