/*
 * Decompiled with CFR 0.152.
 */
package thut.api.boom;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thut.api.boom.Checker;
import thut.api.maths.Vector3;
import thut.lib.CompatWrapper;

public class ExplosionCustom
extends Explosion {
    public static int MAX_RADIUS = 127;
    public static int[] MAXPERTICK = new int[]{10000, 50000};
    public static float MINBLASTDAMAGE = 0.1f;
    public static boolean AFFECTINAIR = true;
    public static Block melt;
    public static Block solidmelt;
    public static Block dust;
    public IEntityHitter hitter = new IEntityHitter(){

        @Override
        public void hitEntity(Entity e, float power, Explosion boom) {
            float area = e.field_70130_N * e.field_70131_O;
            float damage = area * power;
            e.func_70097_a(DamageSource.func_94539_a((Explosion)boom), damage);
        }
    };
    int dimension;
    int currentIndex = 0;
    int nextIndex = 0;
    float minBlastDamage;
    public int[] maxPerTick;
    World world;
    Vector3 centre;
    float strength;
    public boolean meteor = false;
    public EntityPlayer owner = null;
    List<Entity> targets = new ArrayList<Entity>();
    private double explosionX;
    private double explosionY;
    private double explosionZ;
    private float explosionSize;
    private boolean isSmoking = false;
    Entity field_77283_e;
    public Set<BlockPos> field_77281_g = new HashSet<BlockPos>();
    Map<EntityLivingBase, Float> damages = new HashMap<EntityLivingBase, Float>();
    List<Chunk> affected = new ArrayList<Chunk>();
    HashMap<Integer, Float> resists = new HashMap(100000, 1.0f);
    HashSet<Integer> blockedSet = new HashSet(100000, 1.0f);
    Int2ObjectOpenHashMap<Float> thisShell = new Int2ObjectOpenHashMap();
    BitSet checked = new BitSet();
    Vector3 r = Vector3.getNewVector();
    Vector3 rAbs = Vector3.getNewVector();
    Vector3 rHat = Vector3.getNewVector();
    Vector3 rTest = Vector3.getNewVector();
    Vector3 rTestPrev = Vector3.getNewVector();
    Vector3 rTestAbs = Vector3.getNewVector();

    public ExplosionCustom(World world, Entity par2Entity, double x, double y, double z, float power) {
        this(world, par2Entity, Vector3.getNewVector().set(x, y, z), power);
    }

    public ExplosionCustom(World world, Entity par2Entity, Vector3 center, float power) {
        super(world, par2Entity, center.x, center.y, center.z, power, false, false);
        this.world = world;
        this.field_77283_e = par2Entity;
        this.strength = power;
        this.explosionX = center.x;
        this.explosionY = center.y;
        this.explosionZ = center.z;
        this.explosionSize = power;
        this.centre = center.copy();
        this.dimension = world.field_73011_w.getDimension();
        this.minBlastDamage = MINBLASTDAMAGE;
        this.maxPerTick = MAXPERTICK;
    }

    public void addChunkPosition(Vector3 v) {
        this.field_77281_g.add(new BlockPos(v.intX(), v.intY(), v.intZ()));
    }

    public boolean canBreak(Vector3 location) {
        boolean ret = true;
        if (this.owner != null) {
            try {
                BlockEvent.BreakEvent evt = new BlockEvent.BreakEvent(this.world, location.getPos(), location.getBlockState((IBlockAccess)this.world), this.owner);
                MinecraftForge.EVENT_BUS.post((Event)evt);
                if (evt.isCanceled()) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return ret;
    }

    public void doExplosion() {
        this.world.func_184148_a((EntityPlayer)null, this.explosionX, this.explosionY, this.explosionZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.explosionSize >= 2.0f && this.isSmoking) {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, new int[0]);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.nextIndex = this.currentIndex + MAXPERTICK[0];
    }

    public void func_77278_a() {
        this.field_77281_g.clear();
        System.err.println("This should not be run anymore");
        new Exception().printStackTrace();
    }

    public void func_77279_a(boolean par1) {
    }

    public void doKineticImpactor(World worldObj, Vector3 velocity, Vector3 hitLocation, Vector3 acceleration, float density, float energy) {
        if (density < 0.0f || energy <= 0.0f) {
            return;
        }
        int max = 63;
        this.field_77281_g.clear();
        if (acceleration == null) {
            acceleration = Vector3.empty;
        }
        float factor = 1.0f;
        int n = 0;
        ArrayList<Vector3> locations = new ArrayList<Vector3>();
        ArrayList<Float> blasts = new ArrayList<Float>();
        float resist = hitLocation.getExplosionResistance(this, (IBlockAccess)worldObj);
        float blast = Math.min(energy * (resist / density), energy);
        if (resist > density) {
            hitLocation = hitLocation.subtract(velocity.normalize());
            ExplosionCustom boo = new ExplosionCustom(worldObj, this.field_77283_e, hitLocation, blast * factor);
            boo.doExplosion();
            return;
        }
        Vector3 absorbedLoc = Vector3.getNewVector();
        float remainingEnergy = 0.0f;
        density -= resist;
        while (energy > 0.0f && density > 0.0f) {
            locations.add(hitLocation.subtract(velocity.normalize()));
            blasts.add(Float.valueOf(blast));
            hitLocation = hitLocation.add(velocity.normalize());
            velocity.add(acceleration);
            resist = Math.max(hitLocation.getExplosionResistance(this, (IBlockAccess)worldObj), 0.0f);
            blast = Math.min(energy * (resist / density), energy);
            if (resist > density) {
                absorbedLoc.set(hitLocation);
                remainingEnergy = energy;
                break;
            }
            energy -= energy * (resist / density);
            density = (float)((double)density - ((double)resist + 0.1));
        }
        if ((n = locations.size()) != 0) {
            for (int i = 0; i < n; ++i) {
                Vector3 source = (Vector3)locations.get(i);
                float strength = Math.min(((Float)blasts.get(i)).floatValue(), 256.0f);
                if (!worldObj.func_175697_a(source.getPos(), max) || strength == 0.0f) continue;
                ExplosionCustom boo = new ExplosionCustom(worldObj, this.field_77283_e, source, strength * factor);
                boo.doExplosion();
            }
        }
        if (remainingEnergy > 10.0f) {
            absorbedLoc = absorbedLoc.subtract(velocity.normalize());
            ExplosionCustom boo = new ExplosionCustom(worldObj, this.field_77283_e, absorbedLoc, remainingEnergy * factor);
            boo.doExplosion();
        }
    }

    public void doMeteorStuff(IBlockState destroyed, BlockPos pos) {
        if (!destroyed.func_185904_a().func_76220_a() && !destroyed.func_185904_a().func_76224_d()) {
            return;
        }
        if (!this.meteor) {
            this.world.func_175698_g(pos);
            return;
        }
        float resistance = destroyed.func_177230_c().getExplosionResistance(this.world, pos, this.field_77283_e, (Explosion)this);
        if (melt == null) {
            melt = Blocks.field_150350_a;
        }
        if (dust == null) {
            dust = Blocks.field_150350_a;
        }
        if (resistance > 2.0f && !destroyed.func_185904_a().func_76224_d()) {
            int meta = (int)Math.min(resistance / 2.0f, 15.0f);
            this.world.func_175656_a(pos, CompatWrapper.getBlockStateFromMeta(melt, meta));
        } else {
            this.world.func_175656_a(pos, dust.func_176223_P());
        }
    }

    @SubscribeEvent
    public void WorldUnloadEvent(WorldEvent.Unload evt) {
        if (evt.getWorld() == this.world) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    @SubscribeEvent
    void doRemoveBlocks(TickEvent.WorldTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START || evt.world != this.world) {
            return;
        }
        BlastResult result = new Checker(this).getBlocksToRemove();
        this.applyBlockEffects(result.results);
        this.applyEntityEffects(result.hit);
        this.func_77279_a(false);
        ExplosionEvent.Detonate evt2 = new ExplosionEvent.Detonate(this.world, (Explosion)this, this.targets);
        MinecraftForge.EVENT_BUS.post((Event)evt2);
        if (result.done) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    private void applyBlockEffects(List<BlockPos> toRemove) {
        this.func_180343_e().clear();
        for (BlockPos pos : toRemove) {
            this.func_180343_e().add(pos);
            IBlockState state = this.world.func_180495_p(pos);
            this.doMeteorStuff(state, pos);
        }
    }

    private void applyEntityEffects(List<HitEntity> affected) {
        this.targets.clear();
        for (HitEntity e : affected) {
            Entity hit = e.entity;
            float power = e.blastStrength;
            if (!(power > 0.0f)) continue;
            this.hitter.hitEntity(hit, power, this);
            this.targets.add(hit);
        }
    }

    public ExplosionCustom setMeteor(boolean meteor) {
        this.meteor = meteor;
        return this;
    }

    static class BlastResult {
        final List<BlockPos> results;
        final List<HitEntity> hit;
        final boolean done;

        public BlastResult(List<BlockPos> results, List<HitEntity> hit, boolean done) {
            this.results = results;
            this.hit = hit;
            this.done = done;
        }
    }

    static class HitEntity {
        final Entity entity;
        final float blastStrength;

        public HitEntity(Entity entity, float blastStrength) {
            this.entity = entity;
            this.blastStrength = blastStrength;
        }
    }

    public static interface IEntityHitter {
        public void hitEntity(Entity var1, float var2, Explosion var3);
    }
}

