/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import java.util.List;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public interface IMultiplePassengerEntity {
    public Vector3f getSeat(Entity var1);

    public Entity getPassenger(Vector3f var1);

    public List<Vector3f> getSeats();

    public float getYaw();

    public float getPitch();

    public float getPrevYaw();

    public float getPrevPitch();

    public static class MultiplePassengerManager {
        public static void managePassenger(Entity passenger, IMultiplePassengerEntity multipassenger) {
            Entity entity = (Entity)multipassenger;
            if (!entity.func_184196_w(passenger)) {
                return;
            }
            Vector3f v = multipassenger.getSeat(passenger);
            float yaw = -multipassenger.getYaw() * ((float)Math.PI / 180);
            float pitch = -multipassenger.getPitch() * ((float)Math.PI / 180);
            float sinYaw = MathHelper.func_76126_a((float)yaw);
            float cosYaw = MathHelper.func_76134_b((float)yaw);
            float sinPitch = MathHelper.func_76126_a((float)pitch);
            float cosPitch = MathHelper.func_76134_b((float)pitch);
            Matrix3f matrixYaw = new Matrix3f(cosYaw, 0.0f, sinYaw, 0.0f, 1.0f, 0.0f, -sinYaw, 0.0f, cosYaw);
            Matrix3f matrixPitch = new Matrix3f(cosPitch, -sinPitch, 0.0f, sinPitch, cosPitch, 0.0f, 0.0f, 0.0f, 1.0f);
            Matrix3f transform = new Matrix3f();
            transform.mul(matrixYaw, matrixPitch);
            if (v == null) {
                v = new Vector3f();
            } else {
                v = (Vector3f)v.clone();
                transform.transform((Tuple3f)v);
            }
            passenger.func_70107_b(entity.field_70165_t + (double)v.x, entity.field_70163_u + passenger.func_70033_W() + (double)v.y, entity.field_70161_v + (double)v.z);
        }
    }
}

