/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeType {
    private static final Map<Integer, BiomeType> typeMap = Maps.newHashMap();
    private static final Map<Integer, BiomeType> typeMapClient = Maps.newHashMap();
    private static int MAXID = 256;
    public static final BiomeType NONE = new BiomeType("none", "none");
    public static final BiomeType SKY = new BiomeType("sky", "Sky");
    public static final BiomeType FLOWER = new BiomeType("flower", "Flowers");
    public static final BiomeType LAKE = new BiomeType("lake", "Lake");
    public static final BiomeType INDUSTRIAL = new BiomeType("industrial", "Industrial Area");
    public static final BiomeType METEOR = new BiomeType("meteor", "Meteor Area");
    public static final BiomeType RUIN = new BiomeType("ruin", "Ruins");
    public static final BiomeType CAVE = new BiomeType("cave", "Cave");
    public static final BiomeType CAVE_WATER = new BiomeType("cavewater", "Cave Lake");
    public static final BiomeType VILLAGE = new BiomeType("village", "Village");
    public static final BiomeType ALL = new BiomeType("all", "All");
    public final String name;
    private int id;
    public final String readableName;

    @SideOnly(value=Side.CLIENT)
    public static void setMap(Map<Integer, String> mapIn) {
        typeMapClient.clear();
        ArrayList types = Lists.newArrayList();
        for (Integer i : mapIn.keySet()) {
            String name = mapIn.get(i);
            BiomeType type = BiomeType.getBiome(name, true);
            typeMapClient.put(i, type);
            types.add(type);
        }
    }

    public static Map<Integer, String> getMap() {
        HashMap map = Maps.newHashMap();
        for (BiomeType type : BiomeType.values()) {
            map.put(type.getType(), type.name);
        }
        return map;
    }

    public static BiomeType getBiome(String name) {
        return BiomeType.getBiome(name, true);
    }

    public static BiomeType getBiome(String name, boolean generate) {
        for (BiomeType b : BiomeType.values()) {
            if (!b.name.equalsIgnoreCase(name) && !b.readableName.equalsIgnoreCase(name)) continue;
            return b;
        }
        if (generate) {
            BiomeType ret = new BiomeType(name.toLowerCase(Locale.ENGLISH), name);
            return ret;
        }
        return NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<BiomeType> values() {
        Collection<BiomeType> values;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            Collection<BiomeType> values2;
            ArrayList types = Lists.newArrayList();
            Collection<BiomeType> collection = values2 = typeMapClient.values();
            synchronized (collection) {
                types.addAll(values2);
            }
            return types;
        }
        ArrayList types = Lists.newArrayList();
        Collection<BiomeType> collection = values = typeMap.values();
        synchronized (collection) {
            types.addAll(values);
        }
        return types;
    }

    public static BiomeType getType(int id) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return typeMapClient.containsKey(id) ? typeMapClient.get(id) : NONE;
        }
        return typeMap.containsKey(id) ? typeMap.get(id) : NONE;
    }

    private BiomeType(String name, String readableName) {
        this.name = name;
        this.readableName = readableName;
        this.id = MAXID++;
        typeMap.put(this.id, this);
        typeMapClient.put(this.id, this);
    }

    public int getType() {
        return this.id;
    }
}

