/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import thut.api.maths.Vector3;
import thut.api.terrain.BiomeDatabase;
import thut.api.terrain.BiomeType;

public class TerrainSegment {
    public static final int GRIDSIZE = 4;
    public static ISubBiomeChecker defaultChecker = new ISubBiomeChecker(){

        @Override
        public int getSubBiome(World world, Vector3 v, TerrainSegment segment, Chunk chunk, boolean caveAdjusted) {
            if (caveAdjusted) {
                if (world.field_73011_w.func_177500_n()) {
                    return -1;
                }
                boolean sky = false;
                Vector3 temp1 = Vector3.getNewVector();
                int x0 = segment.chunkX * 16;
                int y0 = segment.chunkY * 16;
                int z0 = segment.chunkZ * 16;
                int dx = (v.intX() - x0) / 4 * 4;
                int dy = (v.intY() - y0) / 4 * 4;
                int dz = (v.intZ() - z0) / 4 * 4;
                int x1 = x0 + dx;
                int y1 = y0 + dy;
                int z1 = z0 + dz;
                block0: for (int i = x1; i < x1 + 4; ++i) {
                    for (int j = y1; j < y1 + 4; ++j) {
                        for (int k = z1; k < z1 + 4; ++k) {
                            temp1.set(i, j, k);
                            if (segment.isInTerrainSegment(temp1.x, temp1.y, temp1.z)) {
                                double y = temp1.getMaxY(world);
                                boolean bl = sky = y <= temp1.y;
                            }
                            if (sky) break block0;
                        }
                    }
                }
                if (sky) {
                    return -1;
                }
                if (!sky && TerrainSegment.count(world, (Block)Blocks.field_150355_j, v, 1) > 2) {
                    return BiomeType.CAVE_WATER.getType();
                }
                if (!sky) {
                    return BiomeType.CAVE.getType();
                }
            } else {
                Village village;
                int biome = 0;
                Biome b = v.getBiome(chunk, world.func_72959_q());
                biome = BiomeDatabase.getBiomeType(b);
                boolean notLake = BiomeDatabase.contains(b, BiomeDictionary.Type.OCEAN) || BiomeDatabase.contains(b, BiomeDictionary.Type.SWAMP) || BiomeDatabase.contains(b, BiomeDictionary.Type.RIVER) || BiomeDatabase.contains(b, BiomeDictionary.Type.WATER) || BiomeDatabase.contains(b, BiomeDictionary.Type.BEACH);
                int water = v.blockCount2(world, (Block)Blocks.field_150355_j, 3);
                if (water > 4) {
                    if (!notLake) {
                        biome = BiomeType.LAKE.getType();
                    }
                    return biome;
                }
                if (world.field_72982_D != null && (village = world.field_72982_D.func_176056_a(new BlockPos(MathHelper.func_76128_c((double)v.x), MathHelper.func_76128_c((double)v.y), MathHelper.func_76128_c((double)v.z)), 2)) != null) {
                    biome = BiomeType.VILLAGE.getType();
                }
                return biome;
            }
            return 0;
        }
    };
    public static List<ISubBiomeChecker> biomeCheckers = Lists.newArrayList();
    public static boolean noLoad = false;
    static Map<Integer, Integer> idReplacements = Maps.newHashMap();
    public final int chunkX;
    public final int chunkY;
    public final int chunkZ;
    public final BlockPos pos;
    private Chunk chunk;
    public boolean toSave = false;
    public boolean isSky = false;
    public boolean init = true;
    Vector3 temp = Vector3.getNewVector();
    Vector3 temp1 = Vector3.getNewVector();
    Vector3 mid = Vector3.getNewVector();
    int[] biomes = new int[64];
    HashMap<String, ITerrainEffect> effects = new HashMap();

    public static int count(World world, Block b, Vector3 v, int range) {
        Vector3 temp = Vector3.getNewVector();
        temp.set(v);
        int ret = 0;
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    boolean bool = true;
                    int i1 = MathHelper.func_76128_c((double)(v.intX() + i)) >> 4;
                    int k1 = MathHelper.func_76128_c((double)(v.intZ() + i)) >> 4;
                    boolean bl = bool = i1 == v.intX() >> 4 && k1 == v.intZ() >> 4;
                    if (!bool) continue;
                    temp.set(v).addTo(i, j, k);
                    if (temp.getBlock((IBlockAccess)world) != b && (b != null || temp.getBlock((IBlockAccess)world) != null)) continue;
                    ++ret;
                }
            }
        }
        return ret;
    }

    static Biome getBiome(BiomeDictionary.Type not, BiomeDictionary.Type ... types) {
        Biome ret = null;
        block0: for (ResourceLocation key : Biome.field_185377_q.func_148742_b()) {
            Biome b = (Biome)Biome.field_185377_q.func_82594_a((Object)key);
            if (b == null || not != null && BiomeDatabase.contains(b, not)) continue;
            for (BiomeDictionary.Type t : types) {
                if (!BiomeDatabase.contains(b, t)) continue block0;
            }
            ret = b;
        }
        return ret;
    }

    public static boolean isInTerrainColumn(Vector3 t, Vector3 point) {
        boolean ret = true;
        int i = MathHelper.func_76128_c((double)((double)point.intX() / 16.0));
        int k = MathHelper.func_76128_c((double)((double)point.intZ() / 16.0));
        ret = i == t.intX() && k == t.intZ();
        return ret;
    }

    public static void readFromNBT(TerrainSegment t, NBTTagCompound nbt) {
        if (noLoad) {
            return;
        }
        int[] biomes = nbt.func_74759_k("biomes");
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && nbt.func_74764_b("ids")) {
            idReplacements.clear();
            NBTTagList tags = (NBTTagList)nbt.func_74781_a("ids");
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                NBTTagCompound tag = tags.func_150305_b(i);
                String name = tag.func_74779_i("name");
                int id = tag.func_74762_e("id");
                BiomeType type = BiomeType.getBiome(name, false);
                if (type.getType() == id) continue;
                idReplacements.put(id, type.getType());
            }
            boolean replacements = false;
            for (int i = 0; i < biomes.length; ++i) {
                if (!idReplacements.containsKey(biomes[i])) continue;
                biomes[i] = idReplacements.get(biomes[i]);
                replacements = true;
            }
            if (replacements) {
                System.out.println("Replacement subbiomes found for " + t.chunkX + " " + t.chunkY + " " + t.chunkZ);
            }
        }
        t.toSave = nbt.func_74767_n("toSave");
        t.init = false;
        t.setBiome(biomes);
    }

    public TerrainSegment(int x, int y, int z) {
        this.chunkX = x;
        this.chunkY = y;
        this.chunkZ = z;
        this.pos = new BlockPos(x, y, z);
        this.mid.set(this.chunkX * 16 + 8, this.chunkY * 16 + 8, this.chunkZ * 16 + 8);
    }

    public void addEffect(ITerrainEffect effect, String name) {
        effect.bindToTerrain(this.chunkX, this.chunkY, this.chunkZ);
        this.effects.put(name, effect);
    }

    public int adjustedCaveBiome(World world, Vector3 v) {
        return this.getBiome(world, v, true);
    }

    public int adjustedNonCaveBiome(World world, Vector3 v) {
        return this.getBiome(world, v, false);
    }

    void checkToSave() {
        for (int temp1 : this.biomes) {
            if (temp1 <= 255 || temp1 == BiomeType.SKY.getType()) continue;
            this.toSave = true;
            return;
        }
        this.toSave = false;
    }

    public void doEffects(String effect, EntityLivingBase entity, boolean firstEntry) {
        if (this.effects.containsKey(effect)) {
            this.effects.get(effect).doEffect(entity, firstEntry);
        }
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof TerrainSegment) {
            ret = ((TerrainSegment)o).chunkX == this.chunkX && ((TerrainSegment)o).chunkY == this.chunkY && ((TerrainSegment)o).chunkZ == this.chunkZ;
        }
        return ret;
    }

    public double getAverageSlope(World world, Vector3 point, int range) {
        double slope = 0.0;
        double prevY = point.getMaxY(world);
        double dy = 0.0;
        double dz = 0.0;
        this.temp1.set(this.temp);
        this.temp.set(point);
        int count = 0;
        for (int i = -range; i <= range; ++i) {
            dz = 0.0;
            for (int j = -range; j <= range; ++j) {
                if (TerrainSegment.isInTerrainColumn(point, this.temp.addTo(i, 0.0, j))) {
                    dy += Math.abs((double)point.getMaxY(world, point.intX() + i, point.intZ() + j) - prevY);
                }
                dz += 1.0;
                ++count;
                this.temp.set(point);
            }
            slope += dy / dz;
        }
        this.temp.set(this.temp1);
        return slope / (double)count;
    }

    public int getBiome(int x, int y, int z) {
        int ret = 0;
        int relX = (x & 0xF) / 4;
        int relY = (y & 0xF) / 4;
        int relZ = (z & 0xF) / 4;
        if (relX < 4 && relY < 4 && relZ < 4) {
            ret = this.biomes[relX + 4 * relY + 16 * relZ];
        }
        if (ret > 255) {
            this.toSave = true;
        }
        return ret;
    }

    public int getBiome(Vector3 v) {
        return this.getBiome(v.intX(), v.intY(), v.intZ());
    }

    private int getBiome(World world, Vector3 v, boolean caveAdjust) {
        if (this.chunk == null || this.chunk.field_76635_g != this.chunkX || this.chunk.field_76647_h != this.chunkZ) {
            this.chunk = world.func_72964_e(this.chunkX, this.chunkZ);
        }
        if (this.chunk == null) {
            Thread.dumpStack();
            return 0;
        }
        if (!biomeCheckers.isEmpty()) {
            for (ISubBiomeChecker checker : biomeCheckers) {
                int biome = checker.getSubBiome(world, v, this, this.chunk, caveAdjust);
                if (biome == -1) continue;
                return biome;
            }
        }
        return defaultChecker.getSubBiome(world, v, this, this.chunk, caveAdjust);
    }

    public Vector3 getCentre() {
        return this.mid;
    }

    public BlockPos getChunkCoords() {
        return this.pos;
    }

    public ITerrainEffect geTerrainEffect(String name) {
        return this.effects.get(name);
    }

    public void initBiomes(World world) {
        if (this.init) {
            this.refresh(world);
            this.init = false;
        }
    }

    public boolean isInTerrainSegment(double x, double y, double z) {
        boolean ret = true;
        int i = MathHelper.func_76128_c((double)(x / 16.0));
        int j = MathHelper.func_76128_c((double)(y / 16.0));
        int k = MathHelper.func_76128_c((double)(z / 16.0));
        ret = i == this.chunkX && k == this.chunkZ && j == this.chunkY;
        return ret;
    }

    public void refresh(World world) {
        long time = System.nanoTime();
        this.chunk = world.func_72964_e(this.chunkX, this.chunkZ);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.temp.set(this.chunkX * 16 + i * 16 / 4, this.chunkY * 16 + j * 16 / 4, this.chunkZ * 16 + k * 16 / 4);
                    int biome = this.adjustedCaveBiome(world, this.temp);
                    int biome2 = this.adjustedNonCaveBiome(world, this.temp);
                    if (biome > 255 || biome2 > 255) {
                        this.toSave = true;
                    }
                    if (biome == -1) {
                        biome = biome2;
                    }
                    this.biomes[i + 4 * j + 16 * k] = biome;
                }
            }
        }
        double dt = (double)(System.nanoTime() - time) / 1.0E10;
        if (dt > 0.01) {
            System.out.println("subBiome refresh took " + dt);
        }
    }

    public void saveToNBT(NBTTagCompound nbt) {
        if (!this.toSave) {
            return;
        }
        nbt.func_74783_a("biomes", this.biomes);
        nbt.func_74768_a("x", this.chunkX);
        nbt.func_74768_a("y", this.chunkY);
        nbt.func_74768_a("z", this.chunkZ);
        nbt.func_74757_a("toSave", this.toSave);
        NBTTagList biomeList = new NBTTagList();
        for (BiomeType t : BiomeType.values()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("name", t.name);
            tag.func_74768_a("id", t.getType());
            biomeList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("ids", (NBTBase)biomeList);
    }

    public void setBiome(BlockPos p, int type) {
        this.setBiome(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), type);
    }

    public void setBiome(int x, int y, int z, int biome) {
        int relX = (x & 0xF) / 4;
        int relY = (y & 0xF) / 4;
        int relZ = (z & 0xF) / 4;
        this.biomes[relX + 4 * relY + 16 * relZ] = biome;
        if (biome > 255) {
            this.toSave = true;
        }
    }

    public int getBiomeLocal(int x, int y, int z) {
        int relX = x % 4;
        int relY = y % 4;
        int relZ = z % 4;
        return this.biomes[relX + 4 * relY + 16 * relZ];
    }

    public void setBiomeLocal(int x, int y, int z, int biome) {
        int relX = x % 4;
        int relY = y % 4;
        int relZ = z % 4;
        this.biomes[relX + 4 * relY + 16 * relZ] = biome;
    }

    public void setBiome(int[] biomes) {
        if (biomes.length == this.biomes.length) {
            this.biomes = biomes;
        } else {
            for (int i = 0; i < biomes.length; ++i) {
                if (i >= this.biomes.length) {
                    return;
                }
                this.biomes[i] = biomes[i];
            }
        }
    }

    public void setBiome(Vector3 v, int i) {
        this.setBiome(v.intX(), v.intY(), v.intZ(), i);
    }

    public String toString() {
        String ret = "Terrian Segment " + this.chunkX + "," + this.chunkY + "," + this.chunkZ + " Centre:" + this.getCentre();
        String eol = System.getProperty("line.separator");
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                String line = "[";
                for (int k = 0; k < 4; ++k) {
                    line = line + this.biomes[i + 4 * j + 16 * k];
                    if (k == 3) continue;
                    line = line + ", ";
                }
                line = line + "]";
                ret = ret + eol + line;
            }
        }
        return ret;
    }

    public int hashCode() {
        return this.chunkX + this.chunkZ << 8 << 8 + this.chunkY;
    }

    public static interface ITerrainEffect {
        public void bindToTerrain(int var1, int var2, int var3);

        public void doEffect(EntityLivingBase var1, boolean var2);

        public void readFromNBT(NBTTagCompound var1);

        public void writeToNBT(NBTTagCompound var1);
    }

    public static interface ISubBiomeChecker {
        public int getSubBiome(World var1, Vector3 var2, TerrainSegment var3, Chunk var4, boolean var5);
    }
}

