/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import java.io.DataInputStream;
import java.io.File;
import java.util.HashMap;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thut.api.terrain.TerrainSegment;

public class WorldTerrain {
    final World world;
    public final int dimID;
    private TerrainMap terrainMap = new TerrainMap();

    public WorldTerrain(int dimID) {
        this.dimID = dimID;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        this.world = server != null ? server.func_71218_a(dimID) : null;
    }

    public void addTerrain(TerrainSegment terrain) {
        if (terrain != null) {
            this.terrainMap.setSegment(terrain, terrain.pos);
        }
    }

    public TerrainSegment getTerrain(int chunkX, int chunkY, int chunkZ) {
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185339_c((int)chunkX, (int)chunkY, (int)chunkZ);
        TerrainSegment segment = this.getTerrain((BlockPos)pos, false);
        pos.func_185344_t();
        return segment;
    }

    public TerrainSegment getTerrain(BlockPos pos) {
        return this.getTerrain(pos, false);
    }

    public TerrainSegment getTerrain(BlockPos pos, boolean saving) {
        TerrainSegment ret = null;
        ret = this.terrainMap.getSegment(pos);
        if (ret == null && !saving) {
            block10: {
                ISaveHandler saveHandler;
                File file;
                if (this.world != null && !this.world.field_72995_K && this.world.field_73011_w != null && !TerrainSegment.noLoad && (file = (saveHandler = this.world.func_72860_G()).func_75765_b()) != null && file.exists()) {
                    if (this.world.field_73011_w.getSaveFolder() != null) {
                        file = new File(file, this.world.field_73011_w.getSaveFolder());
                    }
                    if (file.exists()) {
                        try {
                            DataFixer dataFixer = (DataFixer)ReflectionHelper.getPrivateValue(SaveHandler.class, (Object)((SaveHandler)saveHandler), (String[])new String[]{"field_186341_a", "a", "dataFixer"});
                            DataInputStream datainputstream = RegionFileCache.func_76549_c((File)file, (int)pos.func_177958_n(), (int)pos.func_177952_p());
                            if (datainputstream == null) break block10;
                            NBTTagCompound tag = dataFixer.func_188257_a((IFixType)FixTypes.CHUNK, CompressedStreamTools.func_74794_a((DataInputStream)datainputstream));
                            try {
                                NBTTagCompound nbt = tag.func_74775_l("pokecubeTerrainData");
                                tag = nbt.func_74775_l("terrain" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "," + this.dimID);
                                if (tag != null && !tag.func_82582_d()) {
                                    ret = new TerrainSegment(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                                    TerrainSegment.readFromNBT(ret, tag);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            datainputstream.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (ret == null) {
                ret = new TerrainSegment(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            this.terrainMap.setSegment(ret, pos.func_185334_h());
        }
        return ret;
    }

    public void loadTerrain(NBTTagCompound nbt) {
        this.loadTerrain(nbt, 16);
    }

    public void loadTerrain(NBTTagCompound nbt, int max) {
        int x = nbt.func_74762_e("xCoord");
        int z = nbt.func_74762_e("zCoord");
        max = Math.min(16, max + 1);
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int i = 0; i < max; ++i) {
            NBTTagCompound terrainTag = null;
            pos.func_181079_c(x, i, z);
            try {
                terrainTag = nbt.func_74775_l("terrain" + x + "," + i + "," + z + "," + this.dimID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            TerrainSegment t = null;
            if (terrainTag != null && !terrainTag.func_82582_d() && !TerrainSegment.noLoad) {
                t = new TerrainSegment(x, i, z);
                TerrainSegment.readFromNBT(t, terrainTag);
                this.addTerrain(t);
            }
            if (t != null || (t = this.getTerrain((BlockPos)pos, true)) != null) continue;
            t = new TerrainSegment(x, i, z);
            this.addTerrain(t);
        }
        pos.func_185344_t();
    }

    public void removeTerrain(int chunkX, int chunkZ) {
        for (int i = 0; i < 16; ++i) {
            this.terrainMap.setSegment(null, new BlockPos(chunkX, i, chunkZ));
        }
    }

    public boolean saveTerrain(NBTTagCompound nbt, int x, int z) {
        nbt.func_74768_a("xCoord", x);
        nbt.func_74768_a("zCoord", z);
        boolean saved = false;
        for (int i = 0; i < 16; ++i) {
            TerrainSegment t = this.getTerrain(new BlockPos(x, i, z), true);
            if (t == null) continue;
            t.checkToSave();
            if (!t.toSave) continue;
            saved = true;
            NBTTagCompound terrainTag = new NBTTagCompound();
            t.saveToNBT(terrainTag);
            nbt.func_74782_a("terrain" + x + "," + i + "," + z + "," + this.dimID, (NBTBase)terrainTag);
        }
        return saved;
    }

    public static class TerrainMap {
        final HashMap<BlockPos, TerrainSegment> terrain = new HashMap();

        public TerrainSegment getSegment(BlockPos pos) {
            return this.terrain.get(pos);
        }

        public void setSegment(TerrainSegment t, BlockPos pos) {
            if (t != null) {
                this.terrain.put(pos, t);
            } else {
                this.terrain.remove(pos);
            }
        }
    }
}

