/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import thut.api.maths.Vector3;
import thut.api.network.PacketHandler;
import thut.api.terrain.BiomeDatabase;
import thut.api.terrain.TerrainManager;
import thut.api.terrain.TerrainSegment;
import thut.core.client.render.particle.ParticleFactory;
import thut.core.common.CommonProxy;

public class ClientProxy
extends CommonProxy {
    public static int renderPass;
    public static Minecraft mc;

    public static ITextComponent getOutdatedMessage(ForgeVersion.CheckResult result, String name) {
        String linkName = "[" + TextFormatting.GREEN + name + " " + result.target + TextFormatting.WHITE;
        String link = "" + result.url;
        String linkComponent = "{\"text\":\"" + linkName + "\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + link + "\"}}";
        String info = "\"" + TextFormatting.RED + "New " + name + " version available, please update before reporting bugs.\nClick the green link for the page to download.\n\"";
        String mess = "[" + info + "," + linkComponent + ",\"]\"]";
        return ITextComponent.Serializer.func_150699_a((String)mess);
    }

    public ClientProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.getPlayer(null);
    }

    @Override
    public EntityPlayer getPlayer(String playerName) {
        if (this.isOnClientSide()) {
            if (playerName != null) {
                return this.getWorld().func_72924_a(playerName);
            }
            return Minecraft.func_71410_x().field_71439_g;
        }
        return super.getPlayer(playerName);
    }

    @Override
    public World getWorld() {
        if (this.isOnClientSide()) {
            return Minecraft.func_71410_x().field_71441_e;
        }
        return super.getWorld();
    }

    @Override
    public void initClient() {
        mc = FMLClientHandler.instance().getClient();
        PacketHandler.provider = this;
        new UpdateNotifier();
        ParticleFactory.initVanillaParticles();
    }

    @Override
    public boolean isOnClientSide() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    @Override
    public void loadSounds() {
    }

    @Override
    public void preinit(FMLPreInitializationEvent e) {
    }

    @SubscribeEvent
    public void textOverlay(RenderGameOverlayEvent.Text event) {
        boolean debug = Minecraft.func_71410_x().field_71474_y.field_74330_P;
        if (!debug) {
            return;
        }
        TerrainSegment t = TerrainManager.getInstance().getTerrainForEntity((Entity)Minecraft.func_71410_x().field_71439_g);
        Vector3 v = Vector3.getNewVector().set(Minecraft.func_71410_x().field_71439_g);
        String msg = "Sub-Biome: " + BiomeDatabase.getReadableNameFromType(t.getBiome(v));
        for (String s : event.getLeft()) {
            if (s == null || !s.equals(msg)) continue;
            return;
        }
        event.getLeft().add("");
        event.getLeft().add(msg);
    }

    public static class UpdateNotifier {
        public UpdateNotifier() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onPlayerJoin(TickEvent.PlayerTickEvent event) {
            if (event.player.field_70170_p.field_72995_K && event.player == FMLClientHandler.instance().getClientPlayerEntity()) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                Object o = Loader.instance().getIndexedModList().get("thutcore");
                ForgeVersion.CheckResult result = ForgeVersion.getResult((ModContainer)((ModContainer)o));
                if (result.status == ForgeVersion.Status.OUTDATED) {
                    ITextComponent mess = ClientProxy.getOutdatedMessage(result, "Thut Core");
                    event.player.func_145747_a(mess);
                }
            }
        }
    }
}

