/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import thut.core.client.render.animation.AnimationRegistry;
import thut.core.client.render.tabula.components.Animation;
import thut.core.client.render.tabula.components.AnimationComponent;

public class AnimationBuilder {
    public static Animation build(Node node, @Nullable AnimationRegistry.IPartRenamer renamer) {
        Animation ret = null;
        if (node.getAttributes().getNamedItem("type") == null) {
            return null;
        }
        String animName = node.getAttributes().getNamedItem("type").getNodeValue();
        ret = new Animation();
        ret.name = animName;
        ret.loops = true;
        if (node.getAttributes().getNamedItem("loops") != null) {
            ret.loops = Boolean.parseBoolean(node.getAttributes().getNamedItem("loops").getNodeValue());
        }
        NodeList parts = node.getChildNodes();
        for (int i = 0; i < parts.getLength(); ++i) {
            Node part = parts.item(i);
            if (!part.getNodeName().equals("part")) continue;
            NodeList components = part.getChildNodes();
            String partName = part.getAttributes().getNamedItem("name").getNodeValue();
            if (renamer != null) {
                String[] names = new String[]{partName};
                renamer.convertToIdents(names);
                partName = names[0];
            }
            ArrayList set = Lists.newArrayList();
            for (int j = 0; j < components.getLength(); ++j) {
                String[] vals;
                Node component = components.item(j);
                if (!component.getNodeName().equals("component")) continue;
                AnimationComponent comp = new AnimationComponent();
                Node temp = component.getAttributes().getNamedItem("name");
                if (temp != null) {
                    comp.name = temp.getNodeValue();
                }
                if ((temp = component.getAttributes().getNamedItem("rotChange")) != null) {
                    vals = temp.getNodeValue().split(",");
                    comp.rotChange[0] = Double.parseDouble(vals[0]);
                    comp.rotChange[1] = Double.parseDouble(vals[1]);
                    comp.rotChange[2] = Double.parseDouble(vals[2]);
                }
                if ((temp = component.getAttributes().getNamedItem("posChange")) != null) {
                    vals = temp.getNodeValue().split(",");
                    comp.posChange[0] = Double.parseDouble(vals[0]);
                    comp.posChange[1] = Double.parseDouble(vals[1]);
                    comp.posChange[2] = Double.parseDouble(vals[2]);
                }
                if ((temp = component.getAttributes().getNamedItem("scaleChange")) != null) {
                    vals = temp.getNodeValue().split(",");
                    comp.scaleChange[0] = Double.parseDouble(vals[0]);
                    comp.scaleChange[1] = Double.parseDouble(vals[1]);
                    comp.scaleChange[2] = Double.parseDouble(vals[2]);
                }
                if ((temp = component.getAttributes().getNamedItem("rotOffset")) != null) {
                    vals = temp.getNodeValue().split(",");
                    comp.rotOffset[0] = Double.parseDouble(vals[0]);
                    comp.rotOffset[1] = Double.parseDouble(vals[1]);
                    comp.rotOffset[2] = Double.parseDouble(vals[2]);
                }
                if ((temp = component.getAttributes().getNamedItem("posOffset")) != null) {
                    vals = temp.getNodeValue().split(",");
                    comp.posOffset[0] = Double.parseDouble(vals[0]);
                    comp.posOffset[1] = Double.parseDouble(vals[1]);
                    comp.posOffset[2] = Double.parseDouble(vals[2]);
                }
                if ((temp = component.getAttributes().getNamedItem("scaleOffset")) != null) {
                    vals = temp.getNodeValue().split(",");
                    comp.scaleOffset[0] = Double.parseDouble(vals[0]);
                    comp.scaleOffset[1] = Double.parseDouble(vals[1]);
                    comp.scaleOffset[2] = Double.parseDouble(vals[2]);
                }
                if ((temp = component.getAttributes().getNamedItem("length")) != null) {
                    comp.length = Integer.parseInt(temp.getNodeValue());
                }
                if ((temp = component.getAttributes().getNamedItem("startKey")) != null) {
                    comp.startKey = Integer.parseInt(temp.getNodeValue());
                }
                if ((temp = component.getAttributes().getNamedItem("opacityChange")) != null) {
                    comp.opacityChange = Double.parseDouble(temp.getNodeValue());
                }
                if ((temp = component.getAttributes().getNamedItem("opacityOffset")) != null) {
                    comp.opacityOffset = Double.parseDouble(temp.getNodeValue());
                }
                if ((temp = component.getAttributes().getNamedItem("hidden")) != null) {
                    comp.hidden = Boolean.parseBoolean(temp.getNodeValue());
                }
                set.add(comp);
            }
            if (set.isEmpty()) continue;
            ret.sets.put(partName, set);
        }
        return ret;
    }

    public static void merge(Animation from, Animation to) {
        for (String s1 : from.sets.keySet()) {
            if (to.sets.containsKey(s1)) continue;
            to.sets.put(s1, from.sets.get(s1));
        }
    }
}

