/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.smd;

import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.util.vector.Matrix4f;
import thut.core.client.render.model.VectorMath;
import thut.core.client.render.smd.Skeleton;

public class SkeletonAnimation {
    public final Skeleton skeleton;
    public int currentIndex = 0;
    public int lastIndex;
    public int lastPoseChange = -1;
    public int frameCount;
    public String animationName;
    public ArrayList<SkeletonFrame> frames = new ArrayList();

    public SkeletonAnimation(Skeleton skeleton) {
        this.skeleton = skeleton;
    }

    public SkeletonFrame getCurrentFrame() {
        return this.frames.get(this.currentIndex);
    }

    public int getNumFrames() {
        return this.frames.size();
    }

    public void nextFrame() {
        this.currentIndex = this.currentIndex >= this.frames.size() - 1 ? 0 : ++this.currentIndex;
    }

    public void precalculateAnimation() {
        if (this.lastPoseChange == this.currentIndex || this.frames.isEmpty()) {
            return;
        }
        SkeletonFrame prev = this.frames.get(0);
        for (int i = 0; i < this.frames.size(); ++i) {
            SkeletonFrame frame = this.frames.get(i);
            for (Integer j : this.skeleton.boneMap.keySet()) {
                if (frame == prev) {
                    frame.diffs.put(j, new Matrix4f());
                    frame.invDiffs.put(j, new Matrix4f());
                } else {
                    Matrix4f trans = frame.positions.get(j);
                    Matrix4f original = prev.positions.get(j);
                    Matrix4f temp = Matrix4f.invert((Matrix4f)original, null);
                    Matrix4f diff = Matrix4f.mul((Matrix4f)trans, (Matrix4f)temp, null);
                    frame.diffs.put(j, diff);
                    frame.invDiffs.put(j, Matrix4f.invert((Matrix4f)temp, null));
                }
                Skeleton.Bone bone = this.skeleton.boneMap.get(j);
                Matrix4f transform = frame.positions.get(j);
                bone.preloadAnimation(frame, transform);
            }
            prev = frame;
        }
    }

    public void reform() {
        System.out.println("reform");
        for (int i = 0; i < this.frames.size(); ++i) {
            SkeletonFrame frame = this.frames.get(i);
            frame.reform();
        }
    }

    public void reset() {
        for (SkeletonFrame frame : this.frames) {
            frame.reset();
        }
    }

    public void setCurrentFrame(int i) {
        if (this.lastIndex != i) {
            this.lastIndex = this.currentIndex;
            this.currentIndex = i;
        }
        if (this.currentIndex >= this.getNumFrames()) {
            this.currentIndex = 0;
            this.lastIndex = this.getNumFrames() - 1;
        }
    }

    public static class SkeletonFrame {
        public final SkeletonAnimation animation;
        final int time;
        HashMap<Integer, Matrix4f> positions = new HashMap();
        HashMap<Integer, Matrix4f> inversePositions = new HashMap();
        HashMap<Integer, Matrix4f> diffs = new HashMap();
        HashMap<Integer, Matrix4f> invDiffs = new HashMap();
        HashMap<Integer, Matrix4f> positionsOriginal = new HashMap();
        HashMap<Integer, Matrix4f> positionsOriginalInverse = new HashMap();

        public SkeletonFrame(int time, SkeletonAnimation animation) {
            this.time = time;
            this.animation = animation;
        }

        public void addFromLine(String line) {
            line = line.replaceAll("\\s+", " ");
            String[] args = line.split(" ");
            int id = Integer.parseInt(args[0]);
            Matrix4f matrix = VectorMath.fromVector6f(Float.parseFloat(args[1]), Float.parseFloat(args[2]), Float.parseFloat(args[3]), Float.parseFloat(args[4]), Float.parseFloat(args[5]), Float.parseFloat(args[6]));
            this.positions.put(id, matrix);
            this.inversePositions.put(id, Matrix4f.invert((Matrix4f)matrix, null));
            this.positionsOriginal.put(id, new Matrix4f(matrix));
            this.positionsOriginalInverse.put(id, Matrix4f.invert((Matrix4f)matrix, null));
        }

        public void reform() {
            this.reformChildren(this.animation.skeleton.root);
        }

        private void reformChildren(Skeleton.Bone bone) {
            if (bone.parent != null) {
                Matrix4f temp = this.positions.get(bone.id);
                Matrix4f.mul((Matrix4f)this.positions.get(bone.parent.id), (Matrix4f)temp, (Matrix4f)temp);
                Matrix4f.invert((Matrix4f)temp, (Matrix4f)this.inversePositions.get(bone.id));
            }
            for (Skeleton.Bone b : bone.children) {
                this.reformChildren(b);
            }
        }

        public void reset() {
            for (Integer i : this.positions.keySet()) {
                Matrix4f.load((Matrix4f)this.positionsOriginal.get(i), (Matrix4f)this.positions.get(i));
                Matrix4f.load((Matrix4f)this.positionsOriginalInverse.get(i), (Matrix4f)this.inversePositions.get(i));
            }
        }

        public String toString() {
            return this.time + "=" + this.positions;
        }
    }
}

