/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.tabula.animation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.w3c.dom.NamedNodeMap;
import thut.core.client.render.animation.AnimationRegistry;
import thut.core.client.render.tabula.components.Animation;
import thut.core.client.render.tabula.components.AnimationComponent;

public class AdvancedFlapAnimation
extends Animation {
    public AdvancedFlapAnimation() {
        this.loops = true;
        this.name = "flying";
    }

    @Override
    public Animation init(NamedNodeMap map, @Nullable AnimationRegistry.IPartRenamer renamer) {
        int flapdur = 0;
        float walkAngle2 = 20.0f;
        flapdur = Integer.parseInt(map.getNamedItem("duration").getNodeValue());
        for (int i = 1; i <= 255 && map.getNamedItem("leftWing" + i) != null; ++i) {
            int flapaxis = 2;
            float[] walkAngle1 = new float[]{20.0f, 20.0f};
            HashSet<String> hl = new HashSet<String>();
            HashSet<String> hr = new HashSet<String>();
            String[] lh = map.getNamedItem("leftWing" + i).getNodeValue().split(":");
            String[] rh = map.getNamedItem("rightWing" + i).getNodeValue().split(":");
            if (renamer != null) {
                renamer.convertToIdents(lh);
                renamer.convertToIdents(rh);
            }
            for (String s : lh) {
                if (s == null) continue;
                hl.add(s);
            }
            for (String s : rh) {
                if (s == null) continue;
                hr.add(s);
            }
            if (map.getNamedItem("angle" + i) != null) {
                String[] args = map.getNamedItem("angle" + i).getNodeValue().split(",");
                walkAngle1[0] = Float.parseFloat(args[0]);
                walkAngle1[1] = Float.parseFloat(args[1]);
            }
            if (map.getNamedItem("start" + i) != null) {
                walkAngle2 = Float.parseFloat(map.getNamedItem("start" + i).getNodeValue());
            }
            if (map.getNamedItem("axis" + i) != null) {
                flapaxis = Integer.parseInt(map.getNamedItem("axis" + i).getNodeValue());
            }
            this.init(hl, hr, flapdur, walkAngle1, walkAngle2, flapaxis, i > 1);
        }
        return this;
    }

    public AdvancedFlapAnimation init(Set<String> lw, Set<String> rw, int duration, float[] angle, float start, int axis, boolean reverse) {
        ArrayList set;
        AnimationComponent component3;
        AnimationComponent component2;
        AnimationComponent component1;
        String ident;
        int dir = reverse ? -1 : 1;
        for (String s : rw) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = ident + "1";
            component1.identifier = ident + "1";
            component1.startKey = 0;
            component1.rotOffset[axis] = -start;
            component1.rotChange[axis] = angle[0];
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = ident + "2";
            component2.identifier = ident + "2";
            component2.startKey = duration / 4;
            component2.rotChange[axis] = -(angle[1] + angle[0]);
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = ident + "3";
            component3.identifier = ident + "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[axis] = angle[1];
            set = Lists.newArrayList();
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (String s : lw) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = ident + "1";
            component1.identifier = ident + "1";
            component1.startKey = 0;
            component1.rotOffset[axis] = start;
            component1.rotChange[axis] = (float)dir * -angle[0];
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = ident + "2";
            component2.identifier = ident + "2";
            component2.startKey = duration / 4;
            component2.rotChange[axis] = (float)dir * (angle[1] + angle[0]);
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = ident + "3";
            component3.identifier = ident + "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[axis] = (float)dir * -angle[1];
            set = Lists.newArrayList();
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        return this;
    }
}

