/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.tabula.animation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.w3c.dom.NamedNodeMap;
import thut.core.client.render.animation.AnimationRegistry;
import thut.core.client.render.tabula.components.Animation;
import thut.core.client.render.tabula.components.AnimationComponent;

public class BiWalkAnimation
extends Animation {
    public BiWalkAnimation() {
        this.loops = true;
        this.name = "walking";
    }

    @Override
    public Animation init(NamedNodeMap map, @Nullable AnimationRegistry.IPartRenamer renamer) {
        HashSet<String> hl = new HashSet<String>();
        HashSet<String> hr = new HashSet<String>();
        HashSet<String> fl = new HashSet<String>();
        HashSet<String> fr = new HashSet<String>();
        int biwalkdur = 0;
        float walkAngle1 = 20.0f;
        float walkAngle2 = 20.0f;
        String[] lh = map.getNamedItem("leftLeg").getNodeValue().split(":");
        String[] rh = map.getNamedItem("rightLeg").getNodeValue().split(":");
        String[] lf = map.getNamedItem("leftArm").getNodeValue().split(":");
        String[] rf = map.getNamedItem("rightArm").getNodeValue().split(":");
        if (renamer != null) {
            renamer.convertToIdents(lh);
            renamer.convertToIdents(rh);
            renamer.convertToIdents(lf);
            renamer.convertToIdents(rf);
        }
        for (String s : lh) {
            if (s == null) continue;
            hl.add(s);
        }
        for (String s : rh) {
            if (s == null) continue;
            hr.add(s);
        }
        for (String s : rf) {
            if (s == null) continue;
            fr.add(s);
        }
        for (String s : lf) {
            if (s == null) continue;
            fl.add(s);
        }
        biwalkdur = Integer.parseInt(map.getNamedItem("duration").getNodeValue());
        try {
            if (map.getNamedItem("legAngle") != null) {
                walkAngle1 = Float.parseFloat(map.getNamedItem("legAngle").getNodeValue());
            }
            if (map.getNamedItem("armAngle") != null) {
                walkAngle2 = Float.parseFloat(map.getNamedItem("armAngle").getNodeValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init(hl, hr, fl, fr, biwalkdur, walkAngle1, walkAngle2);
        return this;
    }

    public BiWalkAnimation init(Set<String> hl, Set<String> hr, Set<String> fl, Set<String> fr, int duration, float legAngle, float armAngle) {
        ArrayList set;
        AnimationComponent component3;
        AnimationComponent component2;
        AnimationComponent component1;
        String ident;
        for (String s : hr) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = ident + "1";
            component1.identifier = ident + "1";
            component1.startKey = 0;
            component1.rotChange[0] = legAngle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = ident + "2";
            component2.identifier = ident + "2";
            component2.startKey = duration / 4;
            component2.rotChange[0] = -2.0f * legAngle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = ident + "3";
            component3.identifier = ident + "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[0] = -legAngle;
            set = Lists.newArrayList();
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (String s : hl) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = ident + "1";
            component1.identifier = ident + "1";
            component1.startKey = 0;
            component1.rotChange[0] = -legAngle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = ident + "2";
            component2.identifier = ident + "2";
            component2.startKey = duration / 4;
            component2.rotChange[0] = 2.0f * legAngle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = ident + "3";
            component3.identifier = ident + "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[0] = legAngle;
            set = Lists.newArrayList();
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (String s : fr) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = ident + "1";
            component1.identifier = ident + "1";
            component1.startKey = 0;
            component1.rotChange[0] = armAngle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = ident + "2";
            component2.identifier = ident + "2";
            component2.startKey = duration / 4;
            component2.rotChange[0] = -2.0f * armAngle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = ident + "3";
            component3.identifier = ident + "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[0] = -armAngle;
            set = Lists.newArrayList();
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (String s : fl) {
            ident = "";
            component1 = new AnimationComponent();
            component1.length = duration / 4;
            component1.name = ident + "1";
            component1.identifier = ident + "1";
            component1.startKey = 0;
            component1.rotChange[0] = -armAngle;
            component2 = new AnimationComponent();
            component2.length = duration / 2;
            component2.name = ident + "2";
            component2.identifier = ident + "2";
            component2.startKey = duration / 4;
            component2.rotChange[0] = 2.0f * armAngle;
            component3 = new AnimationComponent();
            component3.length = duration / 4;
            component3.name = ident + "3";
            component3.identifier = ident + "3";
            component3.startKey = 3 * duration / 4;
            component3.rotChange[0] = armAngle;
            set = Lists.newArrayList();
            set.add(component1);
            set.add(component2);
            set.add(component3);
            this.sets.put(s, set);
        }
        for (ArrayList set2 : this.sets.values()) {
            for (AnimationComponent c : set2) {
                c.limbBased = true;
            }
        }
        return this;
    }
}

