/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.tabula.components;

import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.w3c.dom.NamedNodeMap;
import thut.core.client.render.animation.AnimationRegistry;
import thut.core.client.render.tabula.components.AnimationComponent;

@SideOnly(value=Side.CLIENT)
public class Animation {
    public String name = "";
    public String identifier = "";
    public int length = -1;
    public boolean loops = true;
    private Set<String> checked = Sets.newHashSet();
    public TreeMap<String, ArrayList<AnimationComponent>> sets = new TreeMap(Ordering.natural());

    public ArrayList<AnimationComponent> getComponents(String key) {
        if (!this.checked.contains(key)) {
            ArrayList<AnimationComponent> comps = null;
            for (String s : this.sets.keySet()) {
                if (!s.startsWith("*") || !key.matches(s.substring(1))) continue;
                comps = this.sets.get(s);
                break;
            }
            if (comps != null) {
                this.sets.put(key, comps);
            }
            this.checked.add(key);
        }
        return this.sets.get(key);
    }

    public int getLength() {
        return this.length;
    }

    public Animation init(NamedNodeMap map, @Nullable AnimationRegistry.IPartRenamer renamer) {
        return this;
    }

    public void initLength() {
        for (Map.Entry<String, ArrayList<AnimationComponent>> entry : this.sets.entrySet()) {
            for (AnimationComponent component : entry.getValue()) {
                if (component.startKey + component.length <= this.length) continue;
                this.length = component.startKey + component.length;
            }
        }
    }

    public String toString() {
        return this.name + "|" + this.identifier + "|" + this.loops;
    }
}

