/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.x3d;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.model.IAnimationChanger;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IModel;
import thut.core.client.render.model.IModelCustom;
import thut.core.client.render.model.IPartTexturer;
import thut.core.client.render.model.IRetexturableModel;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.tabula.components.Animation;
import thut.core.client.render.tabula.components.AnimationComponent;
import thut.core.client.render.x3d.Material;
import thut.core.client.render.x3d.Shape;
import thut.core.client.render.x3d.X3dObject;
import thut.core.client.render.x3d.X3dXML;

public class X3dModel
implements IModelCustom,
IModel,
IRetexturableModel {
    public HashMap<String, IExtendedModelPart> parts = new HashMap();
    Map<String, Material> mats = Maps.newHashMap();
    public String name;

    public X3dModel() {
    }

    public X3dModel(ResourceLocation l) {
        this();
        this.loadModel(l);
    }

    private void addChildren(Set<X3dXML.Transform> allTransforms, X3dXML.Transform transform) {
        for (X3dXML.Transform f : transform.transforms) {
            if (f.DEF.contains("ifs_TRANSFORM")) continue;
            allTransforms.add(f);
            this.addChildren(allTransforms, f);
        }
    }

    private Material getMaterial(X3dXML.Appearance appearance) {
        X3dXML.Material mat = appearance.material;
        if (mat == null) {
            return null;
        }
        String matName = mat.DEF;
        boolean isDef = matName != null;
        Material material = this.mats.get(matName = matName == null ? mat.USE.substring(3) : matName.substring(3));
        if (material == null || isDef) {
            String texName;
            if (appearance.tex != null && appearance.tex.DEF != null) {
                texName = appearance.tex.DEF.substring(3);
                if (texName.contains("_png")) {
                    texName = texName.substring(0, texName.lastIndexOf("_png"));
                }
            } else {
                texName = null;
            }
            if (material == null) {
                material = new Material(matName, texName, mat.getDiffuse(), mat.getSpecular(), mat.getEmissive(), mat.ambientIntensity, mat.shininess, mat.transparency);
            }
            if (isDef) {
                if (material.texture == null) {
                    material.texture = texName;
                }
                material.ambientIntensity = mat.ambientIntensity;
                material.shininess = mat.shininess;
                material.transparency = mat.transparency;
                material.emissiveColor = mat.getEmissive();
                material.specularColor = mat.getSpecular();
                material.diffuseColor = mat.getDiffuse();
                material.emissiveMagnitude = Math.min(1.0f, (float)((double)mat.getEmissive().length() / Math.sqrt(3.0)) / 0.8f);
            }
            this.mats.put(matName, material);
        }
        return material;
    }

    @Override
    public HashMap<String, IExtendedModelPart> getParts() {
        return this.parts;
    }

    public void loadModel(ResourceLocation model) {
        try {
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(model);
            X3dXML xml = new X3dXML(res.func_110527_b());
            res.close();
            this.makeObjects(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    HashMap<String, IExtendedModelPart> makeObjects(X3dXML xml) throws Exception {
        HashMap childMap = Maps.newHashMap();
        HashSet allTransforms = Sets.newHashSet();
        for (X3dXML.Transform transform : xml.model.scene.transforms) {
            allTransforms.add(transform);
            this.addChildren(allTransforms, transform);
        }
        for (X3dXML.Transform transform : allTransforms) {
            String[] offset = transform.translation.split(" ");
            Vector3 translation = Vector3.getNewVector().set(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]));
            offset = transform.scale.split(" ");
            Vertex scale = new Vertex(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]));
            offset = transform.rotation.split(" ");
            Vector4 rotations = new Vector4(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]), (float)Math.toDegrees(Float.parseFloat(offset[3])));
            Set<String> children = transform.getChildNames();
            X3dXML.Transform transform2 = transform.getIfsTransform();
            X3dXML.Group group = transform2.group;
            String name = transform2.getGroupName();
            ArrayList shapes = Lists.newArrayList();
            for (X3dXML.Shape shape : group.shapes) {
                X3dXML.IndexedTriangleSet triangleSet = shape.triangleSet;
                Shape renderShape = new Shape(triangleSet.getOrder(), triangleSet.getVertices(), triangleSet.getNormals(), triangleSet.getTexture());
                shapes.add(renderShape);
                X3dXML.Appearance appearance = shape.appearance;
                Material material = this.getMaterial(appearance);
                if (material == null) continue;
                renderShape.setMaterial(material);
            }
            X3dObject o = new X3dObject(name);
            o.shapes = shapes;
            o.rotations.set(rotations.x, rotations.y, rotations.z, rotations.w);
            o.offset.set(translation);
            o.scale = scale;
            this.parts.put(name, o);
            childMap.put(name, children);
        }
        for (Map.Entry entry : childMap.entrySet()) {
            String key = (String)entry.getKey();
            if (this.parts.get(key) == null) continue;
            IExtendedModelPart part = this.parts.get(key);
            for (String s : (Set)entry.getValue()) {
                if (this.parts.get(s) == null || this.parts.get(s) == part) continue;
                part.addChild(this.parts.get(s));
            }
        }
        return this.parts;
    }

    @Override
    public void preProcessAnimations(Collection<Animation> animations) {
        for (Animation animation : animations) {
            for (String s : animation.sets.keySet()) {
                ArrayList<AnimationComponent> components = animation.sets.get(s);
                for (AnimationComponent comp : components) {
                    comp.posOffset[0] = comp.posOffset[0] / -16.0;
                    comp.posOffset[1] = comp.posOffset[1] / -16.0;
                    comp.posOffset[2] = comp.posOffset[2] / -16.0;
                    comp.posChange[0] = comp.posChange[0] / -16.0;
                    comp.posChange[1] = comp.posChange[1] / -16.0;
                    comp.posChange[2] = comp.posChange[2] / -16.0;
                }
            }
        }
    }

    @Override
    public void renderAll() {
        for (IExtendedModelPart o : this.parts.values()) {
            o.renderAll();
        }
    }

    @Override
    public void renderAllExcept(String ... excludedGroupNames) {
        for (IExtendedModelPart o : this.parts.values()) {
            o.renderAllExcept(excludedGroupNames);
        }
    }

    @Override
    public void renderOnly(String ... groupNames) {
        for (IExtendedModelPart o : this.parts.values()) {
            o.renderOnly(groupNames);
        }
    }

    @Override
    public void renderPart(String partName) {
        for (IExtendedModelPart o : this.parts.values()) {
            o.renderPart(partName);
        }
    }

    @Override
    public void setAnimationChanger(IAnimationChanger changer) {
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setAnimationChanger(changer);
        }
    }

    @Override
    public void setTexturer(IPartTexturer texturer) {
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setTexturer(texturer);
        }
    }
}

